/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.client;

import com.google.common.base.Strings;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.logging.LogUtils;
import com.mojang.realmsclient.exception.RealmsHttpException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.util.GsonHelper;
import org.slf4j.Logger;

public interface RealmsError {
    public static final Component f_290321_ = Component.m_237115_("mco.errorMessage.noDetails");
    public static final Logger f_87295_ = LogUtils.getLogger();

    public int m_294199_();

    public Component m_292809_();

    public String m_293097_();

    public static RealmsError m_87303_(int p_298954_, String p_87304_) {
        if (p_298954_ == 429) {
            return CustomError.f_290429_;
        }
        if (Strings.isNullOrEmpty((String)p_87304_)) {
            return CustomError.m_296023_(p_298954_);
        }
        try {
            JsonObject $$2 = JsonParser.parseString((String)p_87304_).getAsJsonObject();
            String $$3 = GsonHelper.m_13851_($$2, "reason", null);
            String $$4 = GsonHelper.m_13851_($$2, "errorMsg", null);
            int $$5 = GsonHelper.m_13824_($$2, "errorCode", -1);
            if ($$4 != null || $$3 != null || $$5 != -1) {
                return new ErrorWithJsonPayload(p_298954_, $$5 != -1 ? $$5 : p_298954_, $$3, $$4);
            }
        }
        catch (Exception $$6) {
            f_87295_.error("Could not parse RealmsError", (Throwable)$$6);
        }
        return new ErrorWithRawPayload(p_298954_, p_87304_);
    }

    public record CustomError(int f_290502_, @Nullable Component f_290469_) implements RealmsError
    {
        public static final CustomError f_290429_ = new CustomError(429, Component.m_237115_("mco.errorMessage.serviceBusy"));
        public static final Component f_290843_ = Component.m_237115_("mco.errorMessage.retry");

        public static CustomError m_293774_(String p_300024_) {
            return new CustomError(500, Component.m_237110_("mco.errorMessage.realmsService.unknownCompatibility", p_300024_));
        }

        public static CustomError m_294899_(RealmsHttpException p_298467_) {
            return new CustomError(500, Component.m_237110_("mco.errorMessage.realmsService.connectivity", p_298467_.getMessage()));
        }

        public static CustomError m_293569_(int p_297862_) {
            return new CustomError(p_297862_, f_290843_);
        }

        public static CustomError m_296023_(int p_298598_) {
            return new CustomError(p_298598_, null);
        }

        @Override
        public int m_294199_() {
            return this.f_290502_;
        }

        @Override
        public Component m_292809_() {
            return this.f_290469_ != null ? this.f_290469_ : f_290321_;
        }

        @Override
        public String m_293097_() {
            if (this.f_290469_ != null) {
                return String.format(Locale.ROOT, "Realms service error (%d) with message '%s'", this.f_290502_, this.f_290469_.getString());
            }
            return String.format(Locale.ROOT, "Realms service error (%d) with no payload", this.f_290502_);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{CustomError.class, "httpCode;payload", "f_290502_", "f_290469_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{CustomError.class, "httpCode;payload", "f_290502_", "f_290469_"}, this);
        }

        @Override
        public final boolean equals(Object p_300502_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{CustomError.class, "httpCode;payload", "f_290502_", "f_290469_"}, this, p_300502_);
        }
    }

    public record ErrorWithJsonPayload(int f_291492_, int f_291482_, @Nullable String f_291781_, @Nullable String f_290787_) implements RealmsError
    {
        @Override
        public int m_294199_() {
            return this.f_291482_;
        }

        @Override
        public Component m_292809_() {
            String $$1;
            String $$0 = "mco.errorMessage." + this.f_291482_;
            if (I18n.m_118936_($$0)) {
                return Component.m_237115_($$0);
            }
            if (this.f_291781_ != null && I18n.m_118936_($$1 = "mco.errorReason." + this.f_291781_)) {
                return Component.m_237115_($$1);
            }
            return this.f_290787_ != null ? Component.m_237113_(this.f_290787_) : f_290321_;
        }

        @Override
        public String m_293097_() {
            return String.format(Locale.ROOT, "Realms service error (%d/%d/%s) with message '%s'", this.f_291492_, this.f_291482_, this.f_291781_, this.f_290787_);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ErrorWithJsonPayload.class, "httpCode;code;reason;message", "f_291492_", "f_291482_", "f_291781_", "f_290787_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ErrorWithJsonPayload.class, "httpCode;code;reason;message", "f_291492_", "f_291482_", "f_291781_", "f_290787_"}, this);
        }

        @Override
        public final boolean equals(Object p_300239_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ErrorWithJsonPayload.class, "httpCode;code;reason;message", "f_291492_", "f_291482_", "f_291781_", "f_290787_"}, this, p_300239_);
        }
    }

    public record ErrorWithRawPayload(int f_290890_, String f_291066_) implements RealmsError
    {
        @Override
        public int m_294199_() {
            return this.f_290890_;
        }

        @Override
        public Component m_292809_() {
            return Component.m_237113_(this.f_291066_);
        }

        @Override
        public String m_293097_() {
            return String.format(Locale.ROOT, "Realms service error (%d) with raw payload '%s'", this.f_290890_, this.f_291066_);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ErrorWithRawPayload.class, "httpCode;payload", "f_290890_", "f_291066_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ErrorWithRawPayload.class, "httpCode;payload", "f_290890_", "f_291066_"}, this);
        }

        @Override
        public final boolean equals(Object p_297603_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ErrorWithRawPayload.class, "httpCode;payload", "f_290890_", "f_291066_"}, this, p_297603_);
        }
    }

    public record AuthenticationError(String f_291818_) implements RealmsError
    {
        public static final int f_290369_ = 401;

        @Override
        public int m_294199_() {
            return 401;
        }

        @Override
        public Component m_292809_() {
            return Component.m_237113_(this.f_291818_);
        }

        @Override
        public String m_293097_() {
            return String.format(Locale.ROOT, "Realms authentication error with message '%s'", this.f_291818_);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{AuthenticationError.class, "message", "f_291818_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{AuthenticationError.class, "message", "f_291818_"}, this);
        }

        @Override
        public final boolean equals(Object p_299302_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{AuthenticationError.class, "message", "f_291818_"}, this, p_299302_);
        }
    }
}

