/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.RateLimiter;
import com.mojang.logging.LogUtils;
import com.mojang.math.Axis;
import com.mojang.realmsclient.RealmsAvailability;
import com.mojang.realmsclient.client.Ping;
import com.mojang.realmsclient.client.RealmsClient;
import com.mojang.realmsclient.dto.PingResult;
import com.mojang.realmsclient.dto.RealmsNews;
import com.mojang.realmsclient.dto.RealmsNotification;
import com.mojang.realmsclient.dto.RealmsServer;
import com.mojang.realmsclient.dto.RegionPingResult;
import com.mojang.realmsclient.exception.RealmsServiceException;
import com.mojang.realmsclient.gui.RealmsDataFetcher;
import com.mojang.realmsclient.gui.RealmsServerList;
import com.mojang.realmsclient.gui.screens.RealmsConfigureWorldScreen;
import com.mojang.realmsclient.gui.screens.RealmsCreateRealmScreen;
import com.mojang.realmsclient.gui.screens.RealmsGenericErrorScreen;
import com.mojang.realmsclient.gui.screens.RealmsLongConfirmationScreen;
import com.mojang.realmsclient.gui.screens.RealmsLongRunningMcoTaskScreen;
import com.mojang.realmsclient.gui.screens.RealmsPendingInvitesScreen;
import com.mojang.realmsclient.gui.screens.RealmsPopupScreen;
import com.mojang.realmsclient.gui.task.DataFetcher;
import com.mojang.realmsclient.util.RealmsPersistence;
import com.mojang.realmsclient.util.RealmsUtil;
import com.mojang.realmsclient.util.task.GetServerDetailsTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.FocusableTextWidget;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.ImageWidget;
import net.minecraft.client.gui.components.LoadingDotsWidget;
import net.minecraft.client.gui.components.MultiLineTextWidget;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.SpriteIconButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.FrameLayout;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.Layout;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.layouts.SpacerElement;
import net.minecraft.client.gui.navigation.CommonInputs;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.realms.RealmsObjectSelectionList;
import net.minecraft.realms.RealmsScreen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.CommonLinks;
import net.minecraft.util.Mth;
import org.slf4j.Logger;

public class RealmsMainScreen
extends RealmsScreen {
    static final ResourceLocation f_291684_ = new ResourceLocation("icon/info");
    static final ResourceLocation f_290854_ = new ResourceLocation("icon/new_realm");
    static final ResourceLocation f_290924_ = new ResourceLocation("realm_status/expired");
    static final ResourceLocation f_291137_ = new ResourceLocation("realm_status/expires_soon");
    static final ResourceLocation f_290678_ = new ResourceLocation("realm_status/open");
    static final ResourceLocation f_290414_ = new ResourceLocation("realm_status/closed");
    private static final ResourceLocation f_290673_ = new ResourceLocation("icon/invite");
    private static final ResourceLocation f_291632_ = new ResourceLocation("icon/news");
    static final Logger f_86257_ = LogUtils.getLogger();
    private static final ResourceLocation f_86308_ = new ResourceLocation("textures/gui/title/realms.png");
    private static final ResourceLocation f_291111_ = new ResourceLocation("textures/gui/realms/no_realms.png");
    private static final Component f_290532_ = Component.m_237115_("menu.online");
    private static final Component f_291739_ = Component.m_237115_("mco.selectServer.loading");
    static final Component f_86238_ = Component.m_237115_("mco.selectServer.uninitialized").m_130940_(ChatFormatting.GREEN);
    static final Component f_86239_ = Component.m_237115_("mco.selectServer.expiredList");
    private static final Component f_86240_ = Component.m_237115_("mco.selectServer.expiredRenew");
    static final Component f_86241_ = Component.m_237115_("mco.selectServer.expiredTrial");
    static final Component f_86243_ = Component.m_237115_("mco.selectServer.minigame").m_7220_(CommonComponents.f_263701_);
    private static final Component f_271303_ = Component.m_237115_("mco.selectServer.play");
    private static final Component f_271231_ = Component.m_237115_("mco.selectServer.leave");
    private static final Component f_271441_ = Component.m_237115_("mco.selectServer.configure");
    static final Component f_86245_ = Component.m_237115_("mco.selectServer.expired");
    static final Component f_86246_ = Component.m_237115_("mco.selectServer.expires.soon");
    static final Component f_86247_ = Component.m_237115_("mco.selectServer.expires.day");
    static final Component f_86248_ = Component.m_237115_("mco.selectServer.open");
    static final Component f_86249_ = Component.m_237115_("mco.selectServer.closed");
    static final Component f_167175_ = Component.m_237110_("gui.narrate.button", f_86238_);
    private static final Component f_290707_ = Component.m_237115_("mco.selectServer.noRealms");
    private static final Tooltip f_291641_ = Tooltip.m_257550_(Component.m_237115_("mco.invites.nopending"));
    private static final Tooltip f_290929_ = Tooltip.m_257550_(Component.m_237115_("mco.invites.pending"));
    private static final int f_271378_ = 100;
    private static final int f_290754_ = 3;
    private static final int f_291666_ = 4;
    private static final int f_290880_ = 308;
    private static final int f_278420_ = 128;
    private static final int f_278497_ = 34;
    private static final int f_278430_ = 128;
    private static final int f_278488_ = 64;
    private static final int f_278451_ = 5;
    private static final int f_278457_ = 44;
    private static final int f_290986_ = 10;
    private static final int f_301848_ = 216;
    private static final int f_301849_ = 36;
    private final CompletableFuture<RealmsAvailability.Result> f_290846_ = RealmsAvailability.m_294859_();
    @Nullable
    private DataFetcher.Subscription f_238705_;
    private final Set<UUID> f_273876_ = new HashSet<UUID>();
    private static boolean f_86279_;
    private final RateLimiter f_86280_;
    private final Screen f_86282_;
    private Button f_86285_;
    private Button f_86286_;
    private Button f_86287_;
    private Button f_86288_;
    private Button f_86289_;
    private RealmSelectionList f_86283_;
    private RealmsServerList f_238533_;
    private volatile boolean f_86297_;
    @Nullable
    private volatile String f_86259_;
    long f_212359_;
    private final List<RealmsNotification> f_273903_ = new ArrayList<RealmsNotification>();
    private Button f_291106_;
    private NotificationButton f_86269_;
    private NotificationButton f_86270_;
    private LayoutState f_291447_;
    @Nullable
    private HeaderAndFooterLayout f_290558_;

    public RealmsMainScreen(Screen p_86315_) {
        super(f_290532_);
        this.f_86282_ = p_86315_;
        this.f_86280_ = RateLimiter.create((double)0.01666666753590107);
    }

    @Override
    public void m_7856_() {
        this.f_238533_ = new RealmsServerList(this.f_96541_);
        this.f_86283_ = this.m_142416_(new RealmSelectionList());
        MutableComponent $$0 = Component.m_237115_("mco.invites.title");
        this.f_86269_ = new NotificationButton($$0, f_290673_, p_296029_ -> this.f_96541_.m_91152_(new RealmsPendingInvitesScreen(this, $$0)));
        MutableComponent $$1 = Component.m_237115_("mco.news");
        this.f_86270_ = new NotificationButton($$1, f_291632_, p_296035_ -> {
            if (this.f_86259_ == null) {
                return;
            }
            ConfirmLinkScreen.m_274480_(this.f_86259_, this, true);
            if (this.f_86270_.m_294789_() != 0) {
                RealmsPersistence.RealmsPersistenceData $$1 = RealmsPersistence.m_90171_();
                $$1.f_90176_ = false;
                RealmsPersistence.m_90172_($$1);
                this.f_86270_.m_294712_(0);
            }
        });
        this.f_86270_.m_257544_(Tooltip.m_257550_($$1));
        this.f_86285_ = Button.m_253074_(f_271303_, p_86659_ -> RealmsMainScreen.m_86515_(this.m_193481_(), this)).m_252780_(100).m_253136_();
        this.f_86288_ = Button.m_253074_(f_271441_, p_86672_ -> this.m_86656_(this.m_193481_())).m_252780_(100).m_253136_();
        this.f_86287_ = Button.m_253074_(f_86240_, p_86622_ -> this.m_193499_(this.m_193481_())).m_252780_(100).m_253136_();
        this.f_86289_ = Button.m_253074_(f_271231_, p_86679_ -> this.m_86669_(this.m_193481_())).m_252780_(100).m_253136_();
        this.f_291106_ = Button.m_253074_(Component.m_237115_("mco.selectServer.purchase"), p_296032_ -> this.m_294891_()).m_253046_(100, 20).m_253136_();
        this.f_86286_ = Button.m_253074_(CommonComponents.f_130660_, p_296030_ -> this.f_96541_.m_91152_(this.f_86282_)).m_252780_(100).m_253136_();
        this.m_293990_(LayoutState.LOADING);
        this.m_86393_();
        this.f_290846_.thenAcceptAsync(p_296034_ -> {
            Screen $$1 = p_296034_.m_294247_(this.f_86282_);
            if ($$1 == null) {
                this.f_238705_ = this.m_86354_(this.f_96541_.m_239420_());
            } else {
                this.f_96541_.m_91152_($$1);
            }
        }, this.f_289574_);
    }

    @Override
    protected void m_267719_() {
        if (this.f_290558_ != null) {
            this.f_86283_.m_93437_(this.f_96543_, this.f_96544_, this.f_290558_.m_269355_(), this.f_96544_ - this.f_290558_.m_269040_());
            this.f_290558_.m_264036_();
        }
    }

    private void m_293990_(LayoutState p_297284_) {
        if (this.f_291447_ == p_297284_) {
            return;
        }
        if (this.f_290558_ != null) {
            this.f_290558_.m_264134_(p_296026_ -> this.m_169411_((GuiEventListener)p_296026_));
        }
        this.f_290558_ = this.m_293610_(p_297284_);
        this.f_291447_ = p_297284_;
        this.f_290558_.m_264134_(p_272289_ -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.m_142416_(p_272289_);
        });
        this.m_267719_();
    }

    private HeaderAndFooterLayout m_293610_(LayoutState p_299759_) {
        HeaderAndFooterLayout $$1 = new HeaderAndFooterLayout(this);
        $$1.m_269376_(44);
        $$1.m_269471_(this.m_292856_());
        Layout $$2 = this.m_294892_(p_299759_);
        $$2.m_264036_();
        $$1.m_269413_($$2.m_93694_() + 20);
        $$1.m_269281_($$2);
        switch (p_299759_) {
            case LOADING: {
                $$1.m_268999_(new LoadingDotsWidget(this.f_96547_, f_291739_));
                break;
            }
            case NO_REALMS: {
                $$1.m_268999_(this.m_292821_());
            }
        }
        return $$1;
    }

    private Layout m_292856_() {
        int $$0 = 90;
        LinearLayout $$1 = LinearLayout.m_295847_().m_294554_(4);
        $$1.m_294823_().m_264623_();
        $$1.m_264406_(this.f_86269_);
        $$1.m_264406_(this.f_86270_);
        LinearLayout $$2 = LinearLayout.m_295847_();
        $$2.m_294823_().m_264623_();
        $$2.m_264406_(SpacerElement.m_264527_(90));
        $$2.m_293842_(ImageWidget.m_295223_(128, 34, f_86308_, 128, 64), LayoutSettings::m_264356_);
        $$2.m_264406_(new FrameLayout(90, 44)).m_295002_($$1, LayoutSettings::m_264443_);
        return $$2;
    }

    private Layout m_294892_(LayoutState p_299205_) {
        GridLayout $$1 = new GridLayout().m_267612_(4);
        GridLayout.RowHelper $$2 = $$1.m_264606_(3);
        if (p_299205_ == LayoutState.LIST) {
            $$2.m_264139_(this.f_86285_);
            $$2.m_264139_(this.f_86288_);
            $$2.m_264139_(this.f_86287_);
            $$2.m_264139_(this.f_86289_);
        }
        $$2.m_264139_(this.f_291106_);
        $$2.m_264139_(this.f_86286_);
        return $$1;
    }

    private LinearLayout m_292821_() {
        LinearLayout $$0 = LinearLayout.m_293633_().m_294554_(10);
        $$0.m_294823_().m_264356_();
        $$0.m_264406_(ImageWidget.m_295223_(130, 64, f_291111_, 130, 64));
        FocusableTextWidget $$1 = new FocusableTextWidget(308, f_290707_, this.f_96547_, false);
        $$0.m_264406_($$1);
        return $$0;
    }

    void m_86393_() {
        RealmsServer $$0 = this.m_193481_();
        this.f_291106_.f_93623_ = this.f_291447_ != LayoutState.LOADING;
        this.f_86285_.f_93623_ = this.m_86562_($$0);
        this.f_86287_.f_93623_ = this.m_86594_($$0);
        this.f_86289_.f_93623_ = this.m_86644_($$0);
        this.f_86288_.f_93623_ = this.m_86619_($$0);
    }

    boolean m_86562_(@Nullable RealmsServer p_86563_) {
        return p_86563_ != null && !p_86563_.f_87482_ && p_86563_.f_87477_ == RealmsServer.State.OPEN;
    }

    private boolean m_86594_(@Nullable RealmsServer p_86595_) {
        return p_86595_ != null && p_86595_.f_87482_ && this.m_86683_(p_86595_);
    }

    private boolean m_86619_(@Nullable RealmsServer p_86620_) {
        return p_86620_ != null && this.m_86683_(p_86620_);
    }

    private boolean m_86644_(@Nullable RealmsServer p_86645_) {
        return p_86645_ != null && !this.m_86683_(p_86645_);
    }

    @Override
    public void m_86600_() {
        super.m_86600_();
        if (this.f_238705_ != null) {
            this.f_238705_.m_239355_();
        }
    }

    public static void m_294569_() {
        Minecraft.m_91087_().m_239420_().f_238709_.m_239964_();
    }

    public void m_294350_() {
        Minecraft.m_91087_().m_239420_().f_87797_.m_239964_();
    }

    private DataFetcher.Subscription m_86354_(RealmsDataFetcher p_238836_) {
        DataFetcher.Subscription $$1 = p_238836_.f_238549_.m_239139_();
        $$1.m_239441_(p_238836_.f_87797_, p_296033_ -> {
            this.f_238533_.m_239868_((List<RealmsServer>)p_296033_);
            this.m_293990_(this.f_238533_.m_294497_() && this.f_273903_.isEmpty() ? LayoutState.NO_REALMS : LayoutState.LIST);
            this.m_274604_();
            boolean $$1 = false;
            for (RealmsServer $$2 : this.f_238533_) {
                if (!this.m_86688_($$2)) continue;
                $$1 = true;
            }
            if (!f_86279_ && $$1) {
                f_86279_ = true;
                this.m_86327_();
            }
        });
        RealmsMainScreen.m_274332_(RealmsClient::m_274314_, p_274622_ -> {
            this.f_273903_.clear();
            this.f_273903_.addAll((Collection<RealmsNotification>)p_274622_);
            if (!this.f_273903_.isEmpty() && this.f_291447_ != LayoutState.LOADING) {
                this.m_293990_(LayoutState.LIST);
                this.m_274604_();
            }
        });
        $$1.m_239441_(p_238836_.f_238709_, p_296027_ -> {
            this.f_86269_.m_294712_((int)p_296027_);
            this.f_86269_.m_257544_(p_296027_ == 0 ? f_291641_ : f_290929_);
            if (p_296027_ > 0 && this.f_86280_.tryAcquire(1)) {
                this.f_96541_.m_240477_().m_168785_(Component.m_237110_("mco.configure.world.invite.narration", p_296027_));
            }
        });
        $$1.m_239441_(p_238836_.f_87799_, p_296031_ -> {
            this.f_86297_ = p_296031_;
        });
        $$1.m_239441_(p_238836_.f_238681_, p_296037_ -> {
            p_296036_.f_238737_.m_239190_((RealmsNews)p_296037_);
            this.f_86259_ = p_296036_.f_238737_.m_240058_();
            this.f_86270_.m_294712_(p_296036_.f_238737_.m_239499_() ? Integer.MAX_VALUE : 0);
        });
        return $$1;
    }

    private static <T> void m_274332_(RealmsCall<T> p_275561_, Consumer<T> p_275686_) {
        Minecraft $$2 = Minecraft.m_91087_();
        ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            try {
                return p_275561_.m_274420_(RealmsClient.m_239151_($$2));
            }
            catch (RealmsServiceException $$2) {
                throw new RuntimeException($$2);
            }
        }).thenAcceptAsync(p_275686_, (Executor)$$2)).exceptionally(p_274626_ -> {
            f_86257_.error("Failed to execute call to Realms Service", p_274626_);
            return null;
        });
    }

    private void m_274604_() {
        RealmsServer $$0 = this.m_193481_();
        this.f_86283_.m_7178_();
        ArrayList<UUID> $$1 = new ArrayList<UUID>();
        for (RealmsNotification $$2 : this.f_273903_) {
            this.m_274411_(this.f_86283_, $$2);
            if ($$2.m_274594_() || this.f_273876_.contains($$2.m_274400_())) continue;
            $$1.add($$2.m_274400_());
        }
        if (!$$1.isEmpty()) {
            RealmsMainScreen.m_274332_(p_274625_ -> {
                p_274625_.m_274582_($$1);
                return null;
            }, p_274630_ -> this.f_273876_.addAll($$1));
        }
        for (RealmsServer $$3 : this.f_238533_) {
            ServerEntry $$4 = new ServerEntry($$3);
            this.f_86283_.m_7085_($$4);
            if ($$0 == null || $$0.f_87473_ != $$3.f_87473_) continue;
            this.f_86283_.m_6987_($$4);
        }
        this.m_86393_();
    }

    private void m_274411_(RealmSelectionList p_275392_, RealmsNotification p_275492_) {
        if (p_275492_ instanceof RealmsNotification.VisitUrl) {
            RealmsNotification.VisitUrl $$2 = (RealmsNotification.VisitUrl)p_275492_;
            Component $$3 = $$2.m_274603_();
            int $$4 = this.f_96547_.m_239133_($$3, 216);
            int $$5 = Mth.m_184652_($$4 + 7, 36) - 1;
            p_275392_.m_7085_(new NotificationMessageEntry($$3, $$5 + 2, $$2));
            for (int $$6 = 0; $$6 < $$5; ++$$6) {
                p_275392_.m_7085_(new EmptyEntry());
            }
            p_275392_.m_7085_(new ButtonEntry($$2.m_274431_(this)));
        }
    }

    private void m_86327_() {
        new Thread(() -> {
            List<RegionPingResult> $$0 = Ping.m_87125_();
            RealmsClient $$1 = RealmsClient.m_87169_();
            PingResult $$2 = new PingResult();
            $$2.f_87438_ = $$0;
            $$2.f_87439_ = this.m_86330_();
            try {
                $$1.m_87199_($$2);
            }
            catch (Throwable $$3) {
                f_86257_.warn("Could not send ping result to Realms: ", $$3);
            }
        }).start();
    }

    private List<Long> m_86330_() {
        ArrayList $$0 = Lists.newArrayList();
        for (RealmsServer $$1 : this.f_238533_) {
            if (!this.m_86688_($$1)) continue;
            $$0.add($$1.f_87473_);
        }
        return $$0;
    }

    private void m_193499_(@Nullable RealmsServer p_193500_) {
        if (p_193500_ != null) {
            String $$1 = CommonLinks.m_276218_(p_193500_.f_87474_, this.f_96541_.m_91094_().m_240411_(), p_193500_.f_87483_);
            this.f_96541_.f_91068_.m_90911_($$1);
            Util.m_137581_().m_137646_($$1);
        }
    }

    private void m_86656_(@Nullable RealmsServer p_86657_) {
        if (p_86657_ != null && this.f_96541_.m_292661_(p_86657_.f_87479_)) {
            this.f_96541_.m_91152_(new RealmsConfigureWorldScreen(this, p_86657_.f_87473_));
        }
    }

    private void m_86669_(@Nullable RealmsServer p_86670_) {
        if (p_86670_ != null && !this.f_96541_.m_292661_(p_86670_.f_87479_)) {
            MutableComponent $$1 = Component.m_237115_("mco.configure.world.leave.question.line1");
            MutableComponent $$2 = Component.m_237115_("mco.configure.world.leave.question.line2");
            this.f_96541_.m_91152_(new RealmsLongConfirmationScreen(p_231253_ -> this.m_193493_(p_231253_, p_86670_), RealmsLongConfirmationScreen.Type.INFO, $$1, $$2, true));
        }
    }

    @Nullable
    private RealmsServer m_193481_() {
        Entry $$0 = (Entry)this.f_86283_.m_93511_();
        return $$0 != null ? $$0.m_183377_() : null;
    }

    private void m_193493_(boolean p_193494_, final RealmsServer p_193495_) {
        if (p_193494_) {
            new Thread("Realms-leave-server"){

                @Override
                public void run() {
                    try {
                        RealmsClient $$0 = RealmsClient.m_87169_();
                        $$0.m_87222_(p_193495_.f_87473_);
                        RealmsMainScreen.this.f_96541_.execute(() -> RealmsMainScreen.this.m_86676_(p_193495_));
                    }
                    catch (RealmsServiceException $$1) {
                        f_86257_.error("Couldn't configure world", (Throwable)$$1);
                        RealmsMainScreen.this.f_96541_.execute(() -> RealmsMainScreen.this.f_96541_.m_91152_(new RealmsGenericErrorScreen($$1, (Screen)RealmsMainScreen.this)));
                    }
                }
            }.start();
        }
        this.f_96541_.m_91152_(this);
    }

    void m_86676_(RealmsServer p_86677_) {
        this.f_238533_.m_240076_(p_86677_);
        this.f_86283_.m_6702_().removeIf(p_231250_ -> {
            RealmsServer $$2 = p_231250_.m_183377_();
            return $$2 != null && $$2.f_87473_ == p_238844_.f_87473_;
        });
        this.f_86283_.m_6987_((Entry)null);
        this.m_86393_();
    }

    void m_274580_(UUID p_275349_) {
        RealmsMainScreen.m_274332_(p_274628_ -> {
            p_274628_.m_274401_(List.of(p_275349_));
            return null;
        }, p_274632_ -> {
            this.f_273903_.removeIf(p_274621_ -> p_274621_.m_274416_() && p_275349_.equals(p_274621_.m_274400_()));
            this.m_274604_();
        });
    }

    public void m_193498_() {
        this.f_86283_.m_6987_((Entry)null);
    }

    @Override
    public Component m_142562_() {
        return switch (this.f_291447_) {
            default -> throw new IncompatibleClassChangeError();
            case LayoutState.LOADING -> CommonComponents.m_267603_(super.m_142562_(), f_291739_);
            case LayoutState.NO_REALMS -> CommonComponents.m_267603_(super.m_142562_(), f_290707_);
            case LayoutState.LIST -> super.m_142562_();
        };
    }

    @Override
    public void m_88315_(GuiGraphics p_282736_, int p_283347_, int p_282480_, float p_283485_) {
        super.m_88315_(p_282736_, p_283347_, p_282480_, p_283485_);
        if (this.f_86297_ && this.f_291106_.f_93623_) {
            RealmsPopupScreen.m_293153_(p_282736_, this.f_291106_);
        }
        switch (RealmsClient.f_291356_) {
            case STAGE: {
                this.m_294361_(p_282736_, "STAGE!", -256);
                break;
            }
            case LOCAL: {
                this.m_294361_(p_282736_, "LOCAL!", 0x7FFF7F);
            }
        }
    }

    private void m_294891_() {
        this.f_96541_.m_91152_(new RealmsPopupScreen(this, this.f_86297_));
    }

    public static void m_86515_(@Nullable RealmsServer p_86516_, Screen p_86517_) {
        if (p_86516_ != null) {
            Minecraft.m_91087_().m_91152_(new RealmsLongRunningMcoTaskScreen(p_86517_, new GetServerDetailsTask(p_86517_, p_86516_)));
        }
    }

    boolean m_86683_(RealmsServer p_86684_) {
        return this.f_96541_.m_292661_(p_86684_.f_87479_);
    }

    private boolean m_86688_(RealmsServer p_86689_) {
        return this.m_86683_(p_86689_) && !p_86689_.f_87482_;
    }

    private void m_294361_(GuiGraphics p_298843_, String p_299597_, int p_300122_) {
        p_298843_.m_280168_().m_85836_();
        p_298843_.m_280168_().m_252880_(this.f_96543_ / 2 - 25, 20.0f, 0.0f);
        p_298843_.m_280168_().m_252781_(Axis.f_252403_.m_252977_(-20.0f));
        p_298843_.m_280168_().m_85841_(1.5f, 1.5f, 1.5f);
        p_298843_.m_280056_(this.f_96547_, p_299597_, 0, 0, p_300122_, false);
        p_298843_.m_280168_().m_85849_();
    }

    class RealmSelectionList
    extends RealmsObjectSelectionList<Entry> {
        public RealmSelectionList() {
            super(RealmsMainScreen.this.f_96543_, RealmsMainScreen.this.f_96544_, 0, RealmsMainScreen.this.f_96544_, 36);
        }

        @Override
        public void m_6987_(@Nullable Entry p_86849_) {
            super.m_6987_(p_86849_);
            RealmsMainScreen.this.m_86393_();
        }

        @Override
        public int m_5775_() {
            return this.m_5773_() * 36;
        }

        @Override
        public int m_5759_() {
            return 300;
        }
    }

    static class NotificationButton
    extends SpriteIconButton.CenteredIcon {
        private static final ResourceLocation[] f_291629_ = new ResourceLocation[]{new ResourceLocation("notification/1"), new ResourceLocation("notification/2"), new ResourceLocation("notification/3"), new ResourceLocation("notification/4"), new ResourceLocation("notification/5"), new ResourceLocation("notification/more")};
        private static final int f_291704_ = Integer.MAX_VALUE;
        private static final int f_290966_ = 20;
        private static final int f_291327_ = 14;
        private int f_290656_;

        public NotificationButton(Component p_299660_, ResourceLocation p_298832_, Button.OnPress p_297337_) {
            super(20, 20, p_299660_, 14, 14, p_298832_, p_297337_);
        }

        int m_294789_() {
            return this.f_290656_;
        }

        public void m_294712_(int p_300462_) {
            this.f_290656_ = p_300462_;
        }

        @Override
        public void m_87963_(GuiGraphics p_301337_, int p_300699_, int p_300272_, float p_300587_) {
            super.m_87963_(p_301337_, p_300699_, p_300272_, p_300587_);
            if (this.f_93623_ && this.f_290656_ != 0) {
                this.m_292651_(p_301337_);
            }
        }

        private void m_292651_(GuiGraphics p_301365_) {
            p_301365_.m_292816_(f_291629_[Math.min(this.f_290656_, 6) - 1], this.m_252754_() + this.m_5711_() - 5, this.m_252907_() - 3, 8, 8);
        }
    }

    static final class LayoutState
    extends Enum<LayoutState> {
        public static final /* enum */ LayoutState LOADING = new LayoutState();
        public static final /* enum */ LayoutState NO_REALMS = new LayoutState();
        public static final /* enum */ LayoutState LIST = new LayoutState();
        private static final /* synthetic */ LayoutState[] $VALUES;

        public static LayoutState[] values() {
            return (LayoutState[])$VALUES.clone();
        }

        public static LayoutState valueOf(String p_300745_) {
            return Enum.valueOf(LayoutState.class, p_300745_);
        }

        private static /* synthetic */ LayoutState[] m_294167_() {
            return new LayoutState[]{LOADING, NO_REALMS, LIST};
        }

        static {
            $VALUES = LayoutState.m_294167_();
        }
    }

    static interface RealmsCall<T> {
        public T m_274420_(RealmsClient var1) throws RealmsServiceException;
    }

    class ServerEntry
    extends Entry {
        private static final int f_167228_ = 36;
        private final RealmsServer f_86853_;

        public ServerEntry(RealmsServer p_86856_) {
            this.f_86853_ = p_86856_;
        }

        @Override
        public void m_6311_(GuiGraphics p_283093_, int p_281645_, int p_283047_, int p_283525_, int p_282321_, int p_282391_, int p_281913_, int p_282475_, boolean p_282378_, float p_282843_) {
            if (this.f_86853_.f_87477_ == RealmsServer.State.UNINITIALIZED) {
                p_283093_.m_292816_(f_290854_, p_283525_ + 36 + 10, p_283047_ + 6, 40, 20);
                int $$10 = p_283525_ + 36 + 10 + 40 + 10;
                p_283093_.m_280430_(RealmsMainScreen.this.f_96547_, f_86238_, $$10, p_283047_ + 12, -1);
                return;
            }
            int $$11 = 225;
            int $$12 = 2;
            this.m_271912_(this.f_86853_, p_283093_, p_283525_ + 36, p_283047_, p_281913_, p_282475_, 225, 2);
            if (RealmsMainScreen.this.m_86683_(this.f_86853_) && this.f_86853_.f_87482_) {
                Component $$13 = this.f_86853_.f_87483_ ? f_86241_ : f_86239_;
                int $$14 = p_283047_ + 11 + 5;
                p_283093_.m_280614_(RealmsMainScreen.this.f_96547_, $$13, p_283525_ + 36 + 2, $$14 + 1, 15553363, false);
            } else {
                if (this.f_86853_.f_87485_ == RealmsServer.WorldType.MINIGAME) {
                    int $$15 = 0xCCAC5C;
                    int $$16 = RealmsMainScreen.this.f_96547_.m_92852_(f_86243_);
                    p_283093_.m_280614_(RealmsMainScreen.this.f_96547_, f_86243_, p_283525_ + 36 + 2, p_283047_ + 12, 0xCCAC5C, false);
                    p_283093_.m_280056_(RealmsMainScreen.this.f_96547_, this.f_86853_.m_87517_(), p_283525_ + 36 + 2 + $$16, p_283047_ + 12, 0x6C6C6C, false);
                } else {
                    p_283093_.m_280056_(RealmsMainScreen.this.f_96547_, this.f_86853_.m_87494_(), p_283525_ + 36 + 2, p_283047_ + 12, 0x6C6C6C, false);
                }
                if (!RealmsMainScreen.this.m_86683_(this.f_86853_)) {
                    p_283093_.m_280056_(RealmsMainScreen.this.f_96547_, this.f_86853_.f_87478_, p_283525_ + 36 + 2, p_283047_ + 12 + 11, 0x4C4C4C, false);
                }
            }
            p_283093_.m_280056_(RealmsMainScreen.this.f_96547_, this.f_86853_.m_87512_(), p_283525_ + 36 + 2, p_283047_ + 1, -1, false);
            RealmsUtil.m_280319_(p_283093_, p_283525_ + 36 - 36, p_283047_, 32, this.f_86853_.f_87479_);
        }

        private void m_293680_() {
            RealmsMainScreen.this.f_96541_.m_91106_().m_120367_(SimpleSoundInstance.m_263171_(SoundEvents.f_12490_, 1.0f));
            RealmsMainScreen.m_86515_(this.f_86853_, RealmsMainScreen.this);
        }

        private void m_292976_() {
            RealmsMainScreen.this.f_96541_.m_91106_().m_120367_(SimpleSoundInstance.m_263171_(SoundEvents.f_12490_, 1.0f));
            RealmsCreateRealmScreen $$0 = new RealmsCreateRealmScreen(this.f_86853_, RealmsMainScreen.this);
            RealmsMainScreen.this.f_96541_.m_91152_($$0);
        }

        @Override
        public boolean m_6375_(double p_86858_, double p_86859_, int p_86860_) {
            if (this.f_86853_.f_87477_ == RealmsServer.State.UNINITIALIZED) {
                this.m_292976_();
            } else if (RealmsMainScreen.this.m_86562_(this.f_86853_)) {
                if (Util.m_137550_() - RealmsMainScreen.this.f_212359_ < 250L && this.m_93696_()) {
                    this.m_293680_();
                }
                RealmsMainScreen.this.f_212359_ = Util.m_137550_();
            }
            return true;
        }

        @Override
        public boolean m_7933_(int p_279120_, int p_279121_, int p_279296_) {
            if (CommonInputs.m_278691_(p_279120_)) {
                if (this.f_86853_.f_87477_ == RealmsServer.State.UNINITIALIZED) {
                    this.m_292976_();
                    return true;
                }
                if (RealmsMainScreen.this.m_86562_(this.f_86853_)) {
                    this.m_293680_();
                    return true;
                }
            }
            return super.m_7933_(p_279120_, p_279121_, p_279296_);
        }

        private void m_271912_(RealmsServer p_272798_, GuiGraphics p_283451_, int p_273706_, int p_272591_, int p_273561_, int p_273468_, int p_273073_, int p_273187_) {
            int $$8 = p_273706_ + p_273073_ + 22;
            if (p_272798_.f_87482_) {
                this.m_292679_(p_283451_, $$8, p_272591_ + p_273187_, p_273561_, p_273468_, f_290924_, () -> f_86245_);
            } else if (p_272798_.f_87477_ == RealmsServer.State.CLOSED) {
                this.m_292679_(p_283451_, $$8, p_272591_ + p_273187_, p_273561_, p_273468_, f_290414_, () -> f_86249_);
            } else if (RealmsMainScreen.this.m_86683_(p_272798_) && p_272798_.f_87484_ < 7) {
                this.m_292679_(p_283451_, $$8, p_272591_ + p_273187_, p_273561_, p_273468_, f_291137_, () -> {
                    if (p_299888_.f_87484_ <= 0) {
                        return f_86246_;
                    }
                    if (p_299888_.f_87484_ == 1) {
                        return f_86247_;
                    }
                    return Component.m_237110_("mco.selectServer.expires.days", p_299888_.f_87484_);
                });
            } else if (p_272798_.f_87477_ == RealmsServer.State.OPEN) {
                this.m_292679_(p_283451_, $$8, p_272591_ + p_273187_, p_273561_, p_273468_, f_290678_, () -> f_86248_);
            }
        }

        private void m_292679_(GuiGraphics p_299970_, int p_301102_, int p_298644_, int p_299797_, int p_301199_, ResourceLocation p_297808_, Supplier<Component> p_299343_) {
            p_299970_.m_292816_(p_297808_, p_301102_, p_298644_, 10, 28);
            if (p_299797_ >= p_301102_ && p_299797_ <= p_301102_ + 9 && p_301199_ >= p_298644_ && p_301199_ <= p_298644_ + 27 && p_301199_ < RealmsMainScreen.this.f_96544_ - 40 && p_301199_ > 32) {
                RealmsMainScreen.this.m_257404_(p_299343_.get());
            }
        }

        @Override
        public Component m_142172_() {
            if (this.f_86853_.f_87477_ == RealmsServer.State.UNINITIALIZED) {
                return f_167175_;
            }
            return Component.m_237110_("narrator.select", this.f_86853_.f_87475_);
        }

        @Override
        @Nullable
        public RealmsServer m_183377_() {
            return this.f_86853_;
        }
    }

    abstract class Entry
    extends ObjectSelectionList.Entry<Entry> {
        Entry() {
        }

        @Nullable
        public RealmsServer m_183377_() {
            return null;
        }
    }

    class NotificationMessageEntry
    extends Entry {
        private static final int f_273834_ = 40;
        private static final int f_273853_ = -12303292;
        private final Component f_273835_;
        private final int f_301850_;
        private final List<AbstractWidget> f_273924_ = new ArrayList<AbstractWidget>();
        @Nullable
        private final CrossButton f_273947_;
        private final MultiLineTextWidget f_273817_;
        private final GridLayout f_273902_;
        private final FrameLayout f_273811_;
        private int f_273937_ = -1;

        public NotificationMessageEntry(Component p_275215_, int p_301862_, RealmsNotification p_275494_) {
            this.f_273835_ = p_275215_;
            this.f_301850_ = p_301862_;
            this.f_273902_ = new GridLayout();
            int $$3 = 7;
            this.f_273902_.m_264075_(ImageWidget.m_294506_(20, 20, f_291684_), 0, 0, this.f_273902_.m_264626_().m_264129_(7, 7, 0, 0));
            this.f_273902_.m_264379_(SpacerElement.m_264527_(40), 0, 0);
            this.f_273811_ = this.f_273902_.m_264075_(new FrameLayout(0, ((RealmsMainScreen)RealmsMainScreen.this).f_96547_.f_92710_ * 3 * (p_301862_ - 1)), 0, 1, this.f_273902_.m_264626_().m_264311_(7));
            this.f_273817_ = this.f_273811_.m_264564_(new MultiLineTextWidget(p_275215_, RealmsMainScreen.this.f_96547_).m_269484_(true), this.f_273811_.m_264364_().m_264356_().m_264070_());
            this.f_273902_.m_264379_(SpacerElement.m_264527_(40), 0, 2);
            this.f_273947_ = p_275494_.m_274416_() ? this.f_273902_.m_264075_(new CrossButton(p_275478_ -> RealmsMainScreen.this.m_274580_(p_275494_.m_274400_()), Component.m_237115_("mco.notification.dismiss")), 0, 2, this.f_273902_.m_264626_().m_264443_().m_264129_(0, 7, 7, 0)) : null;
            this.f_273902_.m_264134_(this.f_273924_::add);
        }

        @Override
        public boolean m_7933_(int p_275646_, int p_275453_, int p_275621_) {
            if (this.f_273947_ != null && this.f_273947_.m_7933_(p_275646_, p_275453_, p_275621_)) {
                return true;
            }
            return super.m_7933_(p_275646_, p_275453_, p_275621_);
        }

        private void m_274357_(int p_275670_) {
            if (this.f_273937_ != p_275670_) {
                this.m_274589_(p_275670_);
                this.f_273937_ = p_275670_;
            }
        }

        private void m_274589_(int p_275267_) {
            int $$1 = p_275267_ - 80;
            this.f_273811_.m_264444_($$1);
            this.f_273817_.m_269098_($$1);
            this.f_273902_.m_264036_();
        }

        @Override
        public void m_274437_(GuiGraphics p_281374_, int p_282622_, int p_283656_, int p_281830_, int p_281651_, int p_283685_, int p_281784_, int p_282510_, boolean p_283146_, float p_283324_) {
            super.m_274437_(p_281374_, p_282622_, p_283656_, p_281830_, p_281651_, p_283685_, p_281784_, p_282510_, p_283146_, p_283324_);
            p_281374_.m_280637_(p_281830_ - 2, p_283656_ - 2, p_281651_, 36 * this.f_301850_ - 2, -12303292);
        }

        @Override
        public void m_6311_(GuiGraphics p_281768_, int p_275375_, int p_275358_, int p_275447_, int p_275694_, int p_275477_, int p_275710_, int p_275677_, boolean p_275542_, float p_275323_) {
            this.f_273902_.m_264152_(p_275447_, p_275358_);
            this.m_274357_(p_275694_ - 4);
            this.f_273924_.forEach(p_280688_ -> p_280688_.m_88315_(p_281768_, p_275710_, p_275677_, p_275323_));
        }

        @Override
        public boolean m_6375_(double p_275209_, double p_275338_, int p_275560_) {
            if (this.f_273947_ != null) {
                this.f_273947_.m_6375_(p_275209_, p_275338_, p_275560_);
            }
            return true;
        }

        @Override
        public Component m_142172_() {
            return this.f_273835_;
        }
    }

    class EmptyEntry
    extends Entry {
        EmptyEntry() {
        }

        @Override
        public void m_6311_(GuiGraphics p_301870_, int p_301858_, int p_301868_, int p_301866_, int p_301860_, int p_301859_, int p_301864_, int p_301865_, boolean p_301869_, float p_301861_) {
        }

        @Override
        public Component m_142172_() {
            return Component.m_237119_();
        }
    }

    class ButtonEntry
    extends Entry {
        private final Button f_273936_;

        public ButtonEntry(Button p_275726_) {
            this.f_273936_ = p_275726_;
        }

        @Override
        public boolean m_6375_(double p_275240_, double p_275616_, int p_275528_) {
            this.f_273936_.m_6375_(p_275240_, p_275616_, p_275528_);
            return true;
        }

        @Override
        public boolean m_7933_(int p_275630_, int p_275328_, int p_275519_) {
            if (this.f_273936_.m_7933_(p_275630_, p_275328_, p_275519_)) {
                return true;
            }
            return super.m_7933_(p_275630_, p_275328_, p_275519_);
        }

        @Override
        public void m_6311_(GuiGraphics p_283542_, int p_282029_, int p_281480_, int p_281377_, int p_283160_, int p_281920_, int p_283267_, int p_281282_, boolean p_281269_, float p_282372_) {
            this.f_273936_.m_264152_(RealmsMainScreen.this.f_96543_ / 2 - 75, p_281480_ + 4);
            this.f_273936_.m_88315_(p_283542_, p_283267_, p_281282_, p_282372_);
        }

        @Override
        public Component m_142172_() {
            return this.f_273936_.m_6035_();
        }
    }

    static class CrossButton
    extends ImageButton {
        private static final WidgetSprites f_290922_ = new WidgetSprites(new ResourceLocation("widget/cross_button"), new ResourceLocation("widget/cross_button_highlighted"));

        protected CrossButton(Button.OnPress p_275420_, Component p_275193_) {
            super(0, 0, 14, 14, f_290922_, p_275420_);
            this.m_257544_(Tooltip.m_257550_(p_275193_));
        }
    }
}

