/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient;

import com.mojang.logging.LogUtils;
import com.mojang.realmsclient.client.RealmsClient;
import com.mojang.realmsclient.exception.RealmsServiceException;
import com.mojang.realmsclient.gui.screens.RealmsClientOutdatedScreen;
import com.mojang.realmsclient.gui.screens.RealmsGenericErrorScreen;
import com.mojang.realmsclient.gui.screens.RealmsParentalConsentScreen;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.slf4j.Logger;

public class RealmsAvailability {
    private static final Logger f_291836_ = LogUtils.getLogger();
    @Nullable
    private static CompletableFuture<Result> f_290741_;

    public static CompletableFuture<Result> m_294859_() {
        if (f_290741_ == null || RealmsAvailability.m_295584_(f_290741_)) {
            f_290741_ = RealmsAvailability.m_295835_();
        }
        return f_290741_;
    }

    private static boolean m_295584_(CompletableFuture<Result> p_299038_) {
        Result $$1 = p_299038_.getNow(null);
        return $$1 != null && $$1.f_291734_() != null;
    }

    private static CompletableFuture<Result> m_295835_() {
        return CompletableFuture.supplyAsync(() -> {
            RealmsClient $$0 = RealmsClient.m_87169_();
            try {
                if ($$0.m_87259_() != RealmsClient.CompatibleVersionResponse.COMPATIBLE) {
                    return new Result(Type.INCOMPATIBLE_CLIENT);
                }
                if (!$$0.m_293015_()) {
                    return new Result(Type.NEEDS_PARENTAL_CONSENT);
                }
                return new Result(Type.SUCCESS);
            }
            catch (RealmsServiceException $$1) {
                f_291836_.error("Couldn't connect to realms", (Throwable)$$1);
                if ($$1.f_200941_.m_294199_() == 401) {
                    return new Result(Type.AUTHENTICATION_ERROR);
                }
                return new Result($$1);
            }
        }, Util.m_183992_());
    }

    public record Result(Type f_291799_, @Nullable RealmsServiceException f_291734_) {
        public Result(Type p_298726_) {
            this(p_298726_, null);
        }

        public Result(RealmsServiceException p_297806_) {
            this(Type.UNEXPECTED_ERROR, p_297806_);
        }

        @Nullable
        public Screen m_294247_(Screen p_299167_) {
            return switch (this.f_291799_) {
                default -> throw new IncompatibleClassChangeError();
                case Type.SUCCESS -> null;
                case Type.INCOMPATIBLE_CLIENT -> new RealmsClientOutdatedScreen(p_299167_);
                case Type.NEEDS_PARENTAL_CONSENT -> new RealmsParentalConsentScreen(p_299167_);
                case Type.AUTHENTICATION_ERROR -> new RealmsGenericErrorScreen(Component.m_237115_("mco.error.invalid.session.title"), Component.m_237115_("mco.error.invalid.session.message"), p_299167_);
                case Type.UNEXPECTED_ERROR -> new RealmsGenericErrorScreen(Objects.requireNonNull(this.f_291734_), p_299167_);
            };
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Result.class, "type;exception", "f_291799_", "f_291734_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Result.class, "type;exception", "f_291799_", "f_291734_"}, this);
        }

        @Override
        public final boolean equals(Object p_300749_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Result.class, "type;exception", "f_291799_", "f_291734_"}, this, p_300749_);
        }
    }

    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type SUCCESS = new Type();
        public static final /* enum */ Type INCOMPATIBLE_CLIENT = new Type();
        public static final /* enum */ Type NEEDS_PARENTAL_CONSENT = new Type();
        public static final /* enum */ Type AUTHENTICATION_ERROR = new Type();
        public static final /* enum */ Type UNEXPECTED_ERROR = new Type();
        private static final /* synthetic */ Type[] $VALUES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String p_299318_) {
            return Enum.valueOf(Type.class, p_299318_);
        }

        private static /* synthetic */ Type[] m_293711_() {
            return new Type[]{SUCCESS, INCOMPATIBLE_CLIENT, NEEDS_PARENTAL_CONSENT, AUTHENTICATION_ERROR, UNEXPECTED_ERROR};
        }

        static {
            $VALUES = Type.m_293711_();
        }
    }
}

