/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.horse;

import com.mojang.serialization.Codec;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.Container;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LlamaFollowCaravanGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.RunAroundLikeCrazyGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.LlamaSpit;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.WoolCarpetBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import org.joml.Vector3f;

public class Llama
extends AbstractChestedHorse
implements VariantHolder<Variant>,
RangedAttackMob {
    private static final int f_149535_ = 5;
    private static final Ingredient f_30744_ = Ingredient.m_43929_(Items.f_42405_, Blocks.f_50335_.m_5456_());
    private static final EntityDataAccessor<Integer> f_30745_ = SynchedEntityData.m_135353_(Llama.class, EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> f_30746_ = SynchedEntityData.m_135353_(Llama.class, EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> f_30747_ = SynchedEntityData.m_135353_(Llama.class, EntityDataSerializers.f_135028_);
    boolean f_30741_;
    @Nullable
    private Llama f_30742_;
    @Nullable
    private Llama f_30743_;

    public Llama(EntityType<? extends Llama> p_30750_, Level p_30751_) {
        super(p_30750_, p_30751_);
    }

    public boolean m_7565_() {
        return false;
    }

    private void m_30840_(int p_30841_) {
        this.f_19804_.m_135381_(f_30745_, Math.max(1, Math.min(5, p_30841_)));
    }

    private void m_218817_(RandomSource p_218818_) {
        int i = p_218818_.m_188501_() < 0.04f ? 5 : 3;
        this.m_30840_(1 + p_218818_.m_188503_(i));
    }

    public int m_30823_() {
        return this.f_19804_.m_135370_(f_30745_);
    }

    public void m_7380_(CompoundTag p_30793_) {
        super.m_7380_(p_30793_);
        p_30793_.m_128405_("Variant", this.m_28554_().f_262240_);
        p_30793_.m_128405_("Strength", this.m_30823_());
        if (!this.f_30520_.m_8020_(1).m_41619_()) {
            p_30793_.m_128365_("DecorItem", this.f_30520_.m_8020_(1).m_41739_(new CompoundTag()));
        }
    }

    public void m_7378_(CompoundTag p_30780_) {
        this.m_30840_(p_30780_.m_128451_("Strength"));
        super.m_7378_(p_30780_);
        this.m_28464_(Variant.m_262458_(p_30780_.m_128451_("Variant")));
        if (p_30780_.m_128425_("DecorItem", 10)) {
            this.f_30520_.m_6836_(1, ItemStack.m_41712_(p_30780_.m_128469_("DecorItem")));
        }
        this.m_7493_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)((Object)this)));
        this.f_21345_.m_25352_(1, (Goal)new RunAroundLikeCrazyGoal((AbstractHorse)((Object)this), 1.2));
        this.f_21345_.m_25352_(2, (Goal)new LlamaFollowCaravanGoal(this, (double)2.1f));
        this.f_21345_.m_25352_(3, (Goal)new RangedAttackGoal((RangedAttackMob)this, 1.25, 40, 20.0f));
        this.f_21345_.m_25352_(3, (Goal)new PanicGoal((PathfinderMob)this, 1.2));
        this.f_21345_.m_25352_(4, (Goal)new BreedGoal((Animal)((Object)this), 1.0));
        this.f_21345_.m_25352_(5, (Goal)new TemptGoal((PathfinderMob)this, 1.25, Ingredient.m_43929_(Items.f_42129_), false));
        this.f_21345_.m_25352_(6, (Goal)new FollowParentGoal((Animal)((Object)this), 1.0));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.7));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)((Object)this), Player.class, 6.0f));
        this.f_21345_.m_25352_(9, (Goal)new RandomLookAroundGoal((Mob)((Object)this)));
        this.f_21346_.m_25352_(1, (Goal)new LlamaHurtByTargetGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new LlamaAttackWolfGoal(this));
    }

    public static AttributeSupplier.Builder m_30824_() {
        return Llama.m_30501_().m_22268_(Attributes.f_22277_, 40.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(f_30745_, 0);
        this.f_19804_.m_135372_(f_30746_, -1);
        this.f_19804_.m_135372_(f_30747_, 0);
    }

    public Variant m_28554_() {
        return Variant.m_262458_(this.f_19804_.m_135370_(f_30747_));
    }

    public void m_28464_(Variant p_262628_) {
        this.f_19804_.m_135381_(f_30747_, p_262628_.f_262240_);
    }

    protected int m_7506_() {
        return this.m_30502_() ? 2 + 3 * this.m_7488_() : super.m_7506_();
    }

    public boolean m_6898_(ItemStack p_30832_) {
        return f_30744_.test(p_30832_);
    }

    protected boolean m_5994_(Player p_30796_, ItemStack p_30797_) {
        SoundEvent soundevent;
        int i = 0;
        int j = 0;
        float f = 0.0f;
        boolean flag = false;
        if (p_30797_.m_150930_(Items.f_42405_)) {
            i = 10;
            j = 3;
            f = 2.0f;
        } else if (p_30797_.m_150930_(Blocks.f_50335_.m_5456_())) {
            i = 90;
            j = 6;
            f = 10.0f;
            if (this.m_30614_() && this.m_146764_() == 0 && this.m_5957_()) {
                flag = true;
                this.m_27595_(p_30796_);
            }
        }
        if (this.m_21223_() < this.m_21233_() && f > 0.0f) {
            this.m_5634_(f);
            flag = true;
        }
        if (this.m_6162_() && i > 0) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123748_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0.0, 0.0, 0.0);
            if (!this.m_9236_().f_46443_) {
                this.m_146758_(i);
            }
            flag = true;
        }
        if (j > 0 && (flag || !this.m_30614_()) && this.m_30624_() < this.m_7555_()) {
            flag = true;
            if (!this.m_9236_().f_46443_) {
                this.m_30653_(j);
            }
        }
        if (flag && !this.m_20067_() && (soundevent = this.m_7872_()) != null) {
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_7872_(), this.m_5720_(), 1.0f, 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f);
        }
        return flag;
    }

    public boolean m_6107_() {
        return this.m_21224_() || this.m_30617_();
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_30774_, DifficultyInstance p_30775_, MobSpawnType p_30776_, @Nullable SpawnGroupData p_30777_, @Nullable CompoundTag p_30778_) {
        Variant llama$variant;
        RandomSource randomsource = p_30774_.m_213780_();
        this.m_218817_(randomsource);
        if (p_30777_ instanceof LlamaGroupData) {
            llama$variant = ((LlamaGroupData)((Object)p_30777_)).f_30847_;
        } else {
            llama$variant = Util.m_214670_(Variant.values(), randomsource);
            p_30777_ = new LlamaGroupData(llama$variant);
        }
        this.m_28464_(llama$variant);
        return super.m_6518_(p_30774_, p_30775_, p_30776_, p_30777_, p_30778_);
    }

    protected boolean m_245259_() {
        return false;
    }

    protected SoundEvent m_7871_() {
        return SoundEvents.f_12093_;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12092_;
    }

    protected SoundEvent m_7975_(DamageSource p_30803_) {
        return SoundEvents.f_12097_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12095_;
    }

    @Nullable
    protected SoundEvent m_7872_() {
        return SoundEvents.f_12096_;
    }

    protected void m_7355_(BlockPos p_30790_, BlockState p_30791_) {
        this.m_5496_(SoundEvents.f_12099_, 0.15f, 1.0f);
    }

    protected void m_7609_() {
        this.m_5496_(SoundEvents.f_12094_, 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
    }

    public int m_7488_() {
        return this.m_30823_();
    }

    public boolean m_7482_() {
        return true;
    }

    public boolean m_7481_() {
        return !this.f_30520_.m_8020_(1).m_41619_();
    }

    public boolean m_6010_(ItemStack p_30834_) {
        return p_30834_.m_204117_(ItemTags.f_215867_);
    }

    public boolean m_6741_() {
        return false;
    }

    public void m_5757_(Container p_30760_) {
        DyeColor dyecolor = this.m_30826_();
        super.m_5757_(p_30760_);
        DyeColor dyecolor1 = this.m_30826_();
        if (this.f_19797_ > 20 && dyecolor1 != null && dyecolor1 != dyecolor) {
            this.m_5496_(SoundEvents.f_12100_, 0.5f, 1.0f);
        }
    }

    protected void m_7493_() {
        if (!this.m_9236_().f_46443_) {
            super.m_7493_();
            this.m_30771_(Llama.m_30835_(this.f_30520_.m_8020_(1)));
        }
    }

    private void m_30771_(@Nullable DyeColor p_30772_) {
        this.f_19804_.m_135381_(f_30746_, p_30772_ == null ? -1 : p_30772_.m_41060_());
    }

    @Nullable
    private static DyeColor m_30835_(ItemStack p_30836_) {
        Block block = Block.m_49814_(p_30836_.m_41720_());
        return block instanceof WoolCarpetBlock ? ((WoolCarpetBlock)block).m_58309_() : null;
    }

    @Nullable
    public DyeColor m_30826_() {
        int i = this.f_19804_.m_135370_(f_30746_);
        return i == -1 ? null : DyeColor.m_41053_(i);
    }

    public int m_7555_() {
        return 30;
    }

    public boolean m_7848_(Animal p_30765_) {
        return p_30765_ != this && p_30765_ instanceof Llama && this.m_30628_() && ((Llama)((Object)p_30765_)).m_30628_();
    }

    @Nullable
    public Llama m_142606_(ServerLevel p_149545_, AgeableMob p_149546_) {
        Llama llama = this.m_7127_();
        if (llama != null) {
            this.m_149508_(p_149546_, (AbstractHorse)((Object)llama));
            Llama llama1 = (Llama)p_149546_;
            int i = this.f_19796_.m_188503_(Math.max(this.m_30823_(), llama1.m_30823_())) + 1;
            if (this.f_19796_.m_188501_() < 0.03f) {
                ++i;
            }
            llama.m_30840_(i);
            llama.m_28464_(this.f_19796_.m_188499_() ? this.m_28554_() : llama1.m_28554_());
        }
        return llama;
    }

    @Nullable
    protected Llama m_7127_() {
        return EntityType.f_20466_.m_20615_(this.m_9236_());
    }

    private void m_30827_(LivingEntity p_30828_) {
        LlamaSpit llamaspit = new LlamaSpit(this.m_9236_(), this);
        double d0 = p_30828_.m_20185_() - this.m_20185_();
        double d1 = p_30828_.m_20227_(0.3333333333333333) - llamaspit.m_20186_();
        double d2 = p_30828_.m_20189_() - this.m_20189_();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2) * (double)0.2f;
        llamaspit.m_6686_(d0, d1 + d3, d2, 1.5f, 10.0f);
        if (!this.m_20067_()) {
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12098_, this.m_5720_(), 1.0f, 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f);
        }
        this.m_9236_().m_7967_(llamaspit);
        this.f_30741_ = true;
    }

    void m_30752_(boolean p_30753_) {
        this.f_30741_ = p_30753_;
    }

    public boolean m_142535_(float p_149538_, float p_149539_, DamageSource p_149540_) {
        LivingFallEvent event = ForgeEventFactory.onLivingFall((LivingEntity)((Object)this), (float)p_149538_, (float)p_149539_);
        if (event.isCanceled()) {
            return false;
        }
        p_149538_ = event.getDistance();
        int i = this.m_5639_(p_149538_, p_149539_ = event.getDamageMultiplier());
        if (i <= 0) {
            return false;
        }
        if (p_149538_ >= 6.0f) {
            this.m_6469_(p_149540_, i);
            if (this.m_20160_()) {
                for (Entity entity : this.m_146897_()) {
                    entity.m_6469_(p_149540_, i);
                }
            }
        }
        this.m_21229_();
        return true;
    }

    public void m_30809_() {
        if (this.f_30742_ != null) {
            this.f_30742_.f_30743_ = null;
        }
        this.f_30742_ = null;
    }

    public void m_30766_(Llama p_30767_) {
        this.f_30742_ = p_30767_;
        this.f_30742_.f_30743_ = this;
    }

    public boolean m_30810_() {
        return this.f_30743_ != null;
    }

    public boolean m_30811_() {
        return this.f_30742_ != null;
    }

    @Nullable
    public Llama m_30812_() {
        return this.f_30742_;
    }

    protected double m_5823_() {
        return 2.0;
    }

    protected void m_7567_() {
        if (!this.m_30811_() && this.m_6162_()) {
            super.m_7567_();
        }
    }

    public boolean m_7559_() {
        return false;
    }

    public void m_6504_(LivingEntity p_30762_, float p_30763_) {
        this.m_30827_(p_30762_);
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, 0.75 * (double)this.m_20192_(), (double)this.m_20205_() * 0.5);
    }

    protected Vector3f m_292594_(Entity p_298288_, EntityDimensions p_300390_, float p_300878_) {
        return new Vector3f(0.0f, p_300390_.f_20378_ - (this.m_6162_() ? 0.8125f : 0.5f) * p_300878_, -0.3f * p_300878_);
    }

    public static final class Variant
    extends Enum<Variant>
    implements StringRepresentable {
        public static final /* enum */ Variant CREAMY = new Variant(0, "creamy");
        public static final /* enum */ Variant WHITE = new Variant(1, "white");
        public static final /* enum */ Variant BROWN = new Variant(2, "brown");
        public static final /* enum */ Variant GRAY = new Variant(3, "gray");
        public static final Codec<Variant> f_262288_;
        private static final IntFunction<Variant> f_262208_;
        final int f_262240_;
        private final String f_262253_;
        private static final /* synthetic */ Variant[] $VALUES;

        public static Variant[] values() {
            return (Variant[])$VALUES.clone();
        }

        public static Variant valueOf(String p_262633_) {
            return Enum.valueOf(Variant.class, p_262633_);
        }

        private Variant(int p_262677_, String p_262641_) {
            this.f_262240_ = p_262677_;
            this.f_262253_ = p_262641_;
        }

        public int m_262452_() {
            return this.f_262240_;
        }

        public static Variant m_262458_(int p_262608_) {
            return f_262208_.apply(p_262608_);
        }

        public String m_7912_() {
            return this.f_262253_;
        }

        private static /* synthetic */ Variant[] m_262370_() {
            return new Variant[]{CREAMY, WHITE, BROWN, GRAY};
        }

        static {
            $VALUES = Variant.m_262370_();
            f_262288_ = StringRepresentable.m_216439_(Variant::values);
            f_262208_ = ByIdMap.m_262839_(Variant::m_262452_, (Object[])Variant.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.CLAMP);
        }
    }

    static class LlamaHurtByTargetGoal
    extends HurtByTargetGoal {
        public LlamaHurtByTargetGoal(Llama p_30854_) {
            super((PathfinderMob)p_30854_, new Class[0]);
        }

        public boolean m_8045_() {
            Mob mob = this.f_26135_;
            if (mob instanceof Llama) {
                Llama llama = (Llama)((Object)mob);
                if (llama.f_30741_) {
                    llama.m_30752_(false);
                    return false;
                }
            }
            return super.m_8045_();
        }
    }

    static class LlamaAttackWolfGoal
    extends NearestAttackableTargetGoal<Wolf> {
        public LlamaAttackWolfGoal(Llama p_30843_) {
            super((Mob)((Object)p_30843_), Wolf.class, 16, false, true, p_296813_ -> !((Wolf)((Object)((Object)p_296813_))).m_21824_());
        }

        protected double m_7623_() {
            return super.m_7623_() * 0.25;
        }
    }

    static class LlamaGroupData
    extends AgeableMob.AgeableMobGroupData {
        public final Variant f_30847_;

        LlamaGroupData(Variant p_262658_) {
            super(true);
            this.f_30847_ = p_262658_;
        }
    }
}

