/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import com.mojang.serialization.Codec;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.JumpControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.ClimbOnTopOfPowderSnowGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarrotBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class Rabbit
extends Animal
implements VariantHolder<Variant> {
    public static final double f_149016_ = 0.6;
    public static final double f_149017_ = 0.8;
    public static final double f_149018_ = 1.0;
    public static final double f_149019_ = 2.2;
    public static final double f_149020_ = 1.4;
    private static final EntityDataAccessor<Integer> f_29647_ = SynchedEntityData.m_135353_(Rabbit.class, EntityDataSerializers.f_135028_);
    private static final ResourceLocation f_29648_ = new ResourceLocation("killer_bunny");
    public static final int f_149028_ = 8;
    public static final int f_149029_ = 8;
    private static final int f_149030_ = 40;
    private int f_29649_;
    private int f_29650_;
    private boolean f_29651_;
    private int f_29652_;
    int f_29653_;

    public Rabbit(EntityType<? extends Rabbit> p_29656_, Level p_29657_) {
        super(p_29656_, p_29657_);
        this.f_21343_ = new RabbitJumpControl(this);
        this.f_21342_ = new RabbitMoveControl(this);
        this.m_29725_(0.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)((Object)this)));
        this.f_21345_.m_25352_(1, (Goal)new ClimbOnTopOfPowderSnowGoal((Mob)((Object)this), this.m_9236_()));
        this.f_21345_.m_25352_(1, (Goal)new RabbitPanicGoal(this, 2.2));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 0.8));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_43929_(Items.f_42619_, Items.f_42677_, Blocks.f_50111_), false));
        this.f_21345_.m_25352_(4, new RabbitAvoidEntityGoal<Player>(this, Player.class, 8.0f, 2.2, 2.2));
        this.f_21345_.m_25352_(4, new RabbitAvoidEntityGoal<Wolf>(this, Wolf.class, 10.0f, 2.2, 2.2));
        this.f_21345_.m_25352_(4, new RabbitAvoidEntityGoal<Monster>(this, Monster.class, 4.0f, 2.2, 2.2));
        this.f_21345_.m_25352_(5, (Goal)new RaidGardenGoal(this));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(11, (Goal)new LookAtPlayerGoal((Mob)((Object)this), Player.class, 10.0f));
    }

    protected float m_6118_() {
        Path path;
        float f = 0.3f;
        if (this.f_19862_ || this.f_21342_.m_24995_() && this.f_21342_.m_25001_() > this.m_20186_() + 0.5) {
            f = 0.5f;
        }
        if ((path = this.f_21344_.m_26570_()) != null && !path.m_77392_()) {
            Vec3 vec3 = path.m_77380_((Entity)((Object)this));
            if (vec3.f_82480_ > this.m_20186_() + 0.5) {
                f = 0.5f;
            }
        }
        if (this.f_21342_.m_24999_() <= 0.6) {
            f = 0.2f;
        }
        return f + this.m_285755_();
    }

    protected void m_6135_() {
        double d1;
        super.m_6135_();
        double d0 = this.f_21342_.m_24999_();
        if (d0 > 0.0 && (d1 = this.m_20184_().m_165925_()) < 0.01) {
            this.m_19920_(0.1f, new Vec3(0.0, 0.0, 1.0));
        }
        if (!this.m_9236_().f_46443_) {
            this.m_9236_().m_7605_((Entity)((Object)this), (byte)1);
        }
    }

    public float m_29735_(float p_29736_) {
        return this.f_29650_ == 0 ? 0.0f : ((float)this.f_29649_ + p_29736_) / (float)this.f_29650_;
    }

    public void m_29725_(double p_29726_) {
        this.m_21573_().m_26517_(p_29726_);
        this.f_21342_.m_6849_(this.f_21342_.m_25000_(), this.f_21342_.m_25001_(), this.f_21342_.m_25002_(), p_29726_);
    }

    public void m_6862_(boolean p_29732_) {
        super.m_6862_(p_29732_);
        if (p_29732_) {
            this.m_5496_(this.m_29718_(), this.m_6121_(), ((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f) * 0.8f);
        }
    }

    public void m_29716_() {
        this.m_6862_(true);
        this.f_29650_ = 10;
        this.f_29649_ = 0;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(f_29647_, Variant.BROWN.f_262203_);
    }

    @Override
    public void m_8024_() {
        if (this.f_29652_ > 0) {
            --this.f_29652_;
        }
        if (this.f_29653_ > 0) {
            this.f_29653_ -= this.f_19796_.m_188503_(3);
            if (this.f_29653_ < 0) {
                this.f_29653_ = 0;
            }
        }
        if (this.m_20096_()) {
            RabbitJumpControl rabbit$rabbitjumpcontrol;
            LivingEntity livingentity;
            if (!this.f_29651_) {
                this.m_6862_(false);
                this.m_29723_();
            }
            if (this.m_28554_() == Variant.EVIL && this.f_29652_ == 0 && (livingentity = this.m_5448_()) != null && this.m_20280_(livingentity) < 16.0) {
                this.m_29686_(livingentity.m_20185_(), livingentity.m_20189_());
                this.f_21342_.m_6849_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_(), this.f_21342_.m_24999_());
                this.m_29716_();
                this.f_29651_ = true;
            }
            if (!(rabbit$rabbitjumpcontrol = (RabbitJumpControl)this.f_21343_).m_29761_()) {
                if (this.f_21342_.m_24995_() && this.f_29652_ == 0) {
                    Path path = this.f_21344_.m_26570_();
                    Vec3 vec3 = new Vec3(this.f_21342_.m_25000_(), this.f_21342_.m_25001_(), this.f_21342_.m_25002_());
                    if (path != null && !path.m_77392_()) {
                        vec3 = path.m_77380_((Entity)((Object)this));
                    }
                    this.m_29686_(vec3.f_82479_, vec3.f_82481_);
                    this.m_29716_();
                }
            } else if (!rabbit$rabbitjumpcontrol.m_29762_()) {
                this.m_29720_();
            }
        }
        this.f_29651_ = this.m_20096_();
    }

    public boolean m_5843_() {
        return false;
    }

    private void m_29686_(double p_29687_, double p_29688_) {
        this.m_146922_((float)(Mth.m_14136_((double)(p_29688_ - this.m_20189_()), (double)(p_29687_ - this.m_20185_())) * 57.2957763671875) - 90.0f);
    }

    private void m_29720_() {
        ((RabbitJumpControl)this.f_21343_).m_29758_(true);
    }

    private void m_29721_() {
        ((RabbitJumpControl)this.f_21343_).m_29758_(false);
    }

    private void m_29722_() {
        this.f_29652_ = this.f_21342_.m_24999_() < 2.2 ? 10 : 1;
    }

    private void m_29723_() {
        this.m_29722_();
        this.m_29721_();
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.f_29649_ != this.f_29650_) {
            ++this.f_29649_;
        } else if (this.f_29650_ != 0) {
            this.f_29649_ = 0;
            this.f_29650_ = 0;
            this.m_6862_(false);
        }
    }

    public static AttributeSupplier.Builder m_29717_() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 3.0).m_22268_(Attributes.f_22279_, 0.3f);
    }

    @Override
    public void m_7380_(CompoundTag p_29697_) {
        super.m_7380_(p_29697_);
        p_29697_.m_128405_("RabbitType", this.m_28554_().f_262203_);
        p_29697_.m_128405_("MoreCarrotTicks", this.f_29653_);
    }

    @Override
    public void m_7378_(CompoundTag p_29684_) {
        super.m_7378_(p_29684_);
        this.m_28464_(Variant.m_262367_(p_29684_.m_128451_("RabbitType")));
        this.f_29653_ = p_29684_.m_128451_("MoreCarrotTicks");
    }

    protected SoundEvent m_29718_() {
        return SoundEvents.f_12354_;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12297_;
    }

    protected SoundEvent m_7975_(DamageSource p_29715_) {
        return SoundEvents.f_12353_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12352_;
    }

    public boolean m_7327_(Entity p_29659_) {
        if (this.m_28554_() == Variant.EVIL) {
            this.m_5496_(SoundEvents.f_12298_, 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
            return p_29659_.m_6469_(this.m_269291_().m_269333_((LivingEntity)((Object)this)), 8.0f);
        }
        return p_29659_.m_6469_(this.m_269291_().m_269333_((LivingEntity)((Object)this)), 3.0f);
    }

    public SoundSource m_5720_() {
        return this.m_28554_() == Variant.EVIL ? SoundSource.HOSTILE : SoundSource.NEUTRAL;
    }

    private static boolean m_149037_(ItemStack p_149038_) {
        return p_149038_.m_150930_(Items.f_42619_) || p_149038_.m_150930_(Items.f_42677_) || p_149038_.m_150930_(Blocks.f_50111_.m_5456_());
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public Rabbit m_142606_(ServerLevel p_149035_, AgeableMob p_149036_) {
        block2: {
            block3: {
                rabbit = EntityType.f_20517_.m_20615_(p_149035_);
                if (rabbit == null) break block2;
                rabbit$variant = Rabbit.m_262482_(p_149035_, this.m_20183_());
                if (this.f_19796_.m_188503_(20) == 0) break block3;
                if (!(p_149036_ instanceof Rabbit)) ** GOTO lbl-1000
                rabbit1 = (Rabbit)p_149036_;
                if (this.f_19796_.m_188499_()) {
                    rabbit$variant = rabbit1.m_28554_();
                } else lbl-1000:
                // 2 sources

                {
                    rabbit$variant = this.m_28554_();
                }
            }
            rabbit.m_28464_(rabbit$variant);
        }
        return rabbit;
    }

    @Override
    public boolean m_6898_(ItemStack p_29729_) {
        return Rabbit.m_149037_(p_29729_);
    }

    public Variant m_28554_() {
        return Variant.m_262367_(this.f_19804_.m_135370_(f_29647_));
    }

    public void m_28464_(Variant p_262578_) {
        if (p_262578_ == Variant.EVIL) {
            this.m_21051_(Attributes.f_22284_).m_22100_(8.0);
            this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.4, true));
            this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
            this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)((Object)this), Player.class, true));
            this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)((Object)this), Wolf.class, true));
            if (!this.m_8077_()) {
                this.m_6593_((Component)Component.m_237115_((String)Util.m_137492_("entity", f_29648_)));
            }
        }
        this.f_19804_.m_135381_(f_29647_, p_262578_.f_262203_);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_29678_, DifficultyInstance p_29679_, MobSpawnType p_29680_, @Nullable SpawnGroupData p_29681_, @Nullable CompoundTag p_29682_) {
        Variant rabbit$variant = Rabbit.m_262482_((LevelAccessor)p_29678_, this.m_20183_());
        if (p_29681_ instanceof RabbitGroupData) {
            rabbit$variant = ((RabbitGroupData)((Object)p_29681_)).f_262235_;
        } else {
            p_29681_ = new RabbitGroupData(rabbit$variant);
        }
        this.m_28464_(rabbit$variant);
        return super.m_6518_(p_29678_, p_29679_, p_29680_, p_29681_, p_29682_);
    }

    private static Variant m_262482_(LevelAccessor p_262699_, BlockPos p_262700_) {
        Holder holder = p_262699_.m_204166_(p_262700_);
        int i = p_262699_.m_213780_().m_188503_(100);
        if (holder.m_203656_(BiomeTags.f_263794_)) {
            return i < 80 ? Variant.WHITE : Variant.WHITE_SPLOTCHED;
        }
        if (holder.m_203656_(BiomeTags.f_263796_)) {
            return Variant.GOLD;
        }
        return i < 50 ? Variant.BROWN : (i < 90 ? Variant.SALT : Variant.BLACK);
    }

    public static boolean m_218255_(EntityType<Rabbit> p_218256_, LevelAccessor p_218257_, MobSpawnType p_218258_, BlockPos p_218259_, RandomSource p_218260_) {
        return p_218257_.m_8055_(p_218259_.m_7495_()).m_204336_(BlockTags.f_184234_) && Rabbit.m_186209_((BlockAndTintGetter)p_218257_, p_218259_);
    }

    boolean m_29724_() {
        return this.f_29653_ <= 0;
    }

    @Override
    public void m_7822_(byte p_29663_) {
        if (p_29663_ == 1) {
            this.m_20076_();
            this.f_29650_ = 10;
            this.f_29649_ = 0;
        } else {
            super.m_7822_(p_29663_);
        }
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)(0.6f * this.m_20192_()), (double)(this.m_20205_() * 0.4f));
    }

    public static class RabbitJumpControl
    extends JumpControl {
        private final Rabbit f_29753_;
        private boolean f_29754_;

        public RabbitJumpControl(Rabbit p_186229_) {
            super((Mob)((Object)p_186229_));
            this.f_29753_ = p_186229_;
        }

        public boolean m_29761_() {
            return this.f_24897_;
        }

        public boolean m_29762_() {
            return this.f_29754_;
        }

        public void m_29758_(boolean p_29759_) {
            this.f_29754_ = p_29759_;
        }

        public void m_8124_() {
            if (this.f_24897_) {
                this.f_29753_.m_29716_();
                this.f_24897_ = false;
            }
        }
    }

    static class RabbitMoveControl
    extends MoveControl {
        private final Rabbit f_29763_;
        private double f_29764_;

        public RabbitMoveControl(Rabbit p_29766_) {
            super((Mob)((Object)p_29766_));
            this.f_29763_ = p_29766_;
        }

        @Override
        public void m_8126_() {
            if (this.f_29763_.m_20096_() && !this.f_29763_.f_20899_ && !((RabbitJumpControl)this.f_29763_.f_21343_).m_29761_()) {
                this.f_29763_.m_29725_(0.0);
            } else if (this.m_24995_()) {
                this.f_29763_.m_29725_(this.f_29764_);
            }
            super.m_8126_();
        }

        @Override
        public void m_6849_(double p_29769_, double p_29770_, double p_29771_, double p_29772_) {
            if (this.f_29763_.m_20069_()) {
                p_29772_ = 1.5;
            }
            super.m_6849_(p_29769_, p_29770_, p_29771_, p_29772_);
            if (p_29772_ > 0.0) {
                this.f_29764_ = p_29772_;
            }
        }
    }

    static class RabbitPanicGoal
    extends PanicGoal {
        private final Rabbit f_29773_;

        public RabbitPanicGoal(Rabbit p_29775_, double p_29776_) {
            super((PathfinderMob)p_29775_, p_29776_);
            this.f_29773_ = p_29775_;
        }

        public void m_8037_() {
            super.m_8037_();
            this.f_29773_.m_29725_(this.f_25685_);
        }
    }

    static class RabbitAvoidEntityGoal<T extends LivingEntity>
    extends AvoidEntityGoal<T> {
        private final Rabbit f_29741_;

        public RabbitAvoidEntityGoal(Rabbit p_29743_, Class<T> p_29744_, float p_29745_, double p_29746_, double p_29747_) {
            super((PathfinderMob)p_29743_, p_29744_, p_29745_, p_29746_, p_29747_);
            this.f_29741_ = p_29743_;
        }

        public boolean m_8036_() {
            return this.f_29741_.m_28554_() != Variant.EVIL && super.m_8036_();
        }
    }

    static class RaidGardenGoal
    extends MoveToBlockGoal {
        private final Rabbit f_29778_;
        private boolean f_29779_;
        private boolean f_29780_;

        public RaidGardenGoal(Rabbit p_29782_) {
            super((PathfinderMob)p_29782_, (double)0.7f, 16);
            this.f_29778_ = p_29782_;
        }

        public boolean m_8036_() {
            if (this.f_25600_ <= 0) {
                if (!ForgeEventFactory.getMobGriefingEvent((Level)this.f_29778_.m_9236_(), (Entity)((Object)this.f_29778_))) {
                    return false;
                }
                this.f_29780_ = false;
                this.f_29779_ = this.f_29778_.m_29724_();
            }
            return super.m_8036_();
        }

        public boolean m_8045_() {
            return this.f_29780_ && super.m_8045_();
        }

        public void m_8037_() {
            super.m_8037_();
            this.f_29778_.m_21563_().m_24950_((double)this.f_25602_.m_123341_() + 0.5, (double)(this.f_25602_.m_123342_() + 1), (double)this.f_25602_.m_123343_() + 0.5, 10.0f, (float)this.f_29778_.m_8132_());
            if (this.m_25625_()) {
                Level level = this.f_29778_.m_9236_();
                BlockPos blockpos = this.f_25602_.m_7494_();
                BlockState blockstate = level.m_8055_(blockpos);
                Block block = blockstate.m_60734_();
                if (this.f_29780_ && block instanceof CarrotBlock) {
                    int i = (Integer)blockstate.m_61143_((Property)CarrotBlock.f_52244_);
                    if (i == 0) {
                        level.m_7731_(blockpos, Blocks.f_50016_.m_49966_(), 2);
                        level.m_46953_(blockpos, true, (Entity)((Object)this.f_29778_));
                    } else {
                        level.m_7731_(blockpos, (BlockState)((Object)blockstate.m_61124_((Property)CarrotBlock.f_52244_, Integer.valueOf(i - 1))), 2);
                        level.m_220407_(GameEvent.f_157792_, blockpos, GameEvent.Context.m_223717_((Entity)((Object)this.f_29778_)));
                        level.m_46796_(2001, blockpos, Block.m_49956_(blockstate));
                    }
                    this.f_29778_.f_29653_ = 40;
                }
                this.f_29780_ = false;
                this.f_25600_ = 10;
            }
        }

        protected boolean m_6465_(LevelReader p_29785_, BlockPos p_29786_) {
            BlockState blockstate = p_29785_.m_8055_(p_29786_);
            if (blockstate.m_60713_(Blocks.f_50093_) && this.f_29779_ && !this.f_29780_ && (blockstate = p_29785_.m_8055_(p_29786_.m_7494_())).m_60734_() instanceof CarrotBlock && ((CarrotBlock)blockstate.m_60734_()).m_52307_(blockstate)) {
                this.f_29780_ = true;
                return true;
            }
            return false;
        }
    }

    public static final class Variant
    extends Enum<Variant>
    implements StringRepresentable {
        public static final /* enum */ Variant BROWN = new Variant(0, "brown");
        public static final /* enum */ Variant WHITE = new Variant(1, "white");
        public static final /* enum */ Variant BLACK = new Variant(2, "black");
        public static final /* enum */ Variant WHITE_SPLOTCHED = new Variant(3, "white_splotched");
        public static final /* enum */ Variant GOLD = new Variant(4, "gold");
        public static final /* enum */ Variant SALT = new Variant(5, "salt");
        public static final /* enum */ Variant EVIL = new Variant(99, "evil");
        private static final IntFunction<Variant> f_262319_;
        public static final Codec<Variant> f_262245_;
        final int f_262203_;
        private final String f_262279_;
        private static final /* synthetic */ Variant[] $VALUES;

        public static Variant[] values() {
            return (Variant[])$VALUES.clone();
        }

        public static Variant valueOf(String p_262706_) {
            return Enum.valueOf(Variant.class, p_262706_);
        }

        private Variant(int p_262657_, String p_262679_) {
            this.f_262203_ = p_262657_;
            this.f_262279_ = p_262679_;
        }

        public String m_7912_() {
            return this.f_262279_;
        }

        public int m_262377_() {
            return this.f_262203_;
        }

        public static Variant m_262367_(int p_262665_) {
            return f_262319_.apply(p_262665_);
        }

        private static /* synthetic */ Variant[] m_262433_() {
            return new Variant[]{BROWN, WHITE, BLACK, WHITE_SPLOTCHED, GOLD, SALT, EVIL};
        }

        static {
            $VALUES = Variant.m_262433_();
            f_262319_ = ByIdMap.m_262845_(Variant::m_262377_, (Object[])Variant.values(), (Object)((Object)BROWN));
            f_262245_ = StringRepresentable.m_216439_(Variant::values);
        }
    }

    public static class RabbitGroupData
    extends AgeableMob.AgeableMobGroupData {
        public final Variant f_262235_;

        public RabbitGroupData(Variant p_262662_) {
            super(1.0f);
            this.f_262235_ = p_262662_;
        }
    }
}

