/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.effect;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.AttributeModifierTemplate;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.extensions.common.IClientMobEffectExtensions;
import net.minecraftforge.common.extensions.IForgeMobEffect;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLLoader;

public class MobEffect
implements IForgeMobEffect {
    private final Map<Attribute, AttributeModifierTemplate> f_19446_ = Maps.newHashMap();
    private final MobEffectCategory f_19447_;
    private final int f_19448_;
    @Nullable
    private String f_19449_;
    private Supplier<MobEffectInstance.FactorData> f_216878_ = () -> null;
    private final Holder.Reference<MobEffect> f_290719_ = BuiltInRegistries.f_256974_.m_203693_((Object)this);
    private Object effectRenderer;

    protected MobEffect(MobEffectCategory p_19451_, int p_19452_) {
        this.f_19447_ = p_19451_;
        this.f_19448_ = p_19452_;
        this.initClient();
    }

    public Optional<MobEffectInstance.FactorData> m_216881_() {
        return Optional.ofNullable(this.f_216878_.get());
    }

    public void m_6742_(LivingEntity p_19467_, int p_19468_) {
    }

    public void m_19461_(@Nullable Entity p_19462_, @Nullable Entity p_19463_, LivingEntity p_19464_, int p_19465_, double p_19466_) {
        this.m_6742_(p_19464_, p_19465_);
    }

    public boolean m_19443_(int p_297908_, int p_301085_) {
        return false;
    }

    public void m_292868_(LivingEntity p_299085_, int p_297449_) {
    }

    public boolean m_8093_() {
        return false;
    }

    protected String m_19477_() {
        if (this.f_19449_ == null) {
            this.f_19449_ = Util.m_137492_("effect", BuiltInRegistries.f_256974_.m_7981_((Object)this));
        }
        return this.f_19449_;
    }

    public String m_19481_() {
        return this.m_19477_();
    }

    public Component m_19482_() {
        return Component.m_237115_((String)this.m_19481_());
    }

    public MobEffectCategory m_19483_() {
        return this.f_19447_;
    }

    public int m_19484_() {
        return this.f_19448_;
    }

    public MobEffect m_19472_(Attribute p_19473_, String p_19474_, double p_19475_, AttributeModifier.Operation p_19476_) {
        this.f_19446_.put(p_19473_, new MobEffectAttributeModifierTemplate(UUID.fromString(p_19474_), p_19475_, p_19476_));
        return this;
    }

    public MobEffect m_216879_(Supplier<MobEffectInstance.FactorData> p_216880_) {
        this.f_216878_ = p_216880_;
        return this;
    }

    public Map<Attribute, AttributeModifierTemplate> m_19485_() {
        return this.f_19446_;
    }

    public void m_6386_(AttributeMap p_19470_) {
        for (Map.Entry<Attribute, AttributeModifierTemplate> entry : this.f_19446_.entrySet()) {
            AttributeInstance attributeinstance = p_19470_.m_22146_(entry.getKey());
            if (attributeinstance == null) continue;
            attributeinstance.m_22120_(entry.getValue().m_295940_());
        }
    }

    public void m_6385_(AttributeMap p_19479_, int p_19480_) {
        for (Map.Entry<Attribute, AttributeModifierTemplate> entry : this.f_19446_.entrySet()) {
            AttributeInstance attributeinstance = p_19479_.m_22146_(entry.getKey());
            if (attributeinstance == null) continue;
            attributeinstance.m_22120_(entry.getValue().m_295940_());
            attributeinstance.m_22125_(entry.getValue().m_293134_(p_19480_));
        }
    }

    public boolean m_19486_() {
        return this.f_19447_ == MobEffectCategory.BENEFICIAL;
    }

    public Object getEffectRendererInternal() {
        return this.effectRenderer;
    }

    private void initClient() {
        if (FMLEnvironment.dist == Dist.CLIENT && !FMLLoader.getLaunchHandler().isData()) {
            this.initializeClient(properties -> {
                this.effectRenderer = properties;
            });
        }
    }

    public void initializeClient(Consumer<IClientMobEffectExtensions> consumer) {
    }

    @Deprecated
    public Holder.Reference<MobEffect> m_295099_() {
        return this.f_290719_;
    }

    class MobEffectAttributeModifierTemplate
    implements AttributeModifierTemplate {
        private final UUID f_291336_;
        private final double f_290322_;
        private final AttributeModifier.Operation f_290509_;

        public MobEffectAttributeModifierTemplate(UUID p_298460_, double p_301163_, AttributeModifier.Operation p_297302_) {
            this.f_291336_ = p_298460_;
            this.f_290322_ = p_301163_;
            this.f_290509_ = p_297302_;
        }

        public UUID m_295940_() {
            return this.f_291336_;
        }

        public AttributeModifier m_293134_(int p_299158_) {
            return new AttributeModifier(this.f_291336_, MobEffect.this.m_19481_() + " " + p_299158_, this.f_290322_ * (double)(p_299158_ + 1), this.f_290509_);
        }
    }
}

