/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementNode;
import net.minecraft.advancements.AdvancementTree;
import net.minecraft.advancements.TreeNodePosition;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.storage.loot.LootDataManager;
import net.minecraftforge.common.crafting.conditions.ICondition;
import org.slf4j.Logger;

public class ServerAdvancementManager
extends SimpleJsonResourceReloadListener {
    private static final Logger f_136021_ = LogUtils.getLogger();
    private static final Gson f_136022_ = new GsonBuilder().create();
    private Map<ResourceLocation, AdvancementHolder> f_136023_ = Map.of();
    private AdvancementTree f_290842_ = new AdvancementTree();
    private final LootDataManager f_278379_;
    private final ICondition.IContext context;

    @Deprecated
    public ServerAdvancementManager(LootDataManager p_279237_) {
        this(p_279237_, ICondition.IContext.EMPTY);
    }

    public ServerAdvancementManager(LootDataManager p_279237_, ICondition.IContext context) {
        super(f_136022_, "advancements");
        this.f_278379_ = p_279237_;
        this.context = context;
    }

    protected void m_5787_(Map<ResourceLocation, JsonElement> p_136034_, ResourceManager p_136035_, ProfilerFiller p_136036_) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        p_136034_.forEach((p_296449_, p_296450_) -> {
            try {
                JsonObject jsonobject = GsonHelper.m_13918_((JsonElement)p_296450_, (String)"advancement");
                Advancement advancement = Advancement.fromJson(jsonobject, new DeserializationContext(p_296449_, this.f_278379_), this.context);
                if (advancement == null) {
                    f_136021_.debug("Skipping loading advancement {} as its conditions were not met", p_296449_);
                    return;
                }
                builder.put(p_296449_, (Object)new AdvancementHolder(p_296449_, advancement));
            }
            catch (Exception exception) {
                f_136021_.error("Parsing error loading custom advancement {}: {}", p_296449_, (Object)exception.getMessage());
            }
        });
        this.f_136023_ = builder.buildOrThrow();
        AdvancementTree advancementtree = new AdvancementTree();
        advancementtree.m_293567_(this.f_136023_.values());
        for (AdvancementNode advancementnode : advancementtree.m_295865_()) {
            if (!advancementnode.m_295246_().f_290952_().f_138299_().isPresent()) continue;
            TreeNodePosition.m_16587_((AdvancementNode)advancementnode);
        }
        this.f_290842_ = advancementtree;
    }

    @Nullable
    public AdvancementHolder m_294099_(ResourceLocation p_299615_) {
        return this.f_136023_.get(p_299615_);
    }

    public AdvancementTree m_294482_() {
        return this.f_290842_;
    }

    public Collection<AdvancementHolder> m_136028_() {
        return this.f_136023_.values();
    }
}

