/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.WorldVersion;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.advancements.packs.VanillaAdvancementProvider;
import net.minecraft.data.info.BiomeParametersDumpReport;
import net.minecraft.data.info.BlockListReport;
import net.minecraft.data.info.CommandsReport;
import net.minecraft.data.info.RegistryDumpReport;
import net.minecraft.data.loot.packs.TradeRebalanceLootTableProvider;
import net.minecraft.data.loot.packs.VanillaLootTableProvider;
import net.minecraft.data.metadata.PackMetadataGenerator;
import net.minecraft.data.models.ModelProvider;
import net.minecraft.data.recipes.packs.BundleRecipeProvider;
import net.minecraft.data.recipes.packs.VanillaRecipeProvider;
import net.minecraft.data.registries.RegistriesDatapackGenerator;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.data.structures.NbtToSnbt;
import net.minecraft.data.structures.SnbtToNbt;
import net.minecraft.data.structures.StructureUpdater;
import net.minecraft.data.tags.BannerPatternTagsProvider;
import net.minecraft.data.tags.BiomeTagsProvider;
import net.minecraft.data.tags.CatVariantTagsProvider;
import net.minecraft.data.tags.DamageTypeTagsProvider;
import net.minecraft.data.tags.EntityTypeTagsProvider;
import net.minecraft.data.tags.FlatLevelGeneratorPresetTagsProvider;
import net.minecraft.data.tags.FluidTagsProvider;
import net.minecraft.data.tags.GameEventTagsProvider;
import net.minecraft.data.tags.InstrumentTagsProvider;
import net.minecraft.data.tags.PaintingVariantTagsProvider;
import net.minecraft.data.tags.PoiTypeTagsProvider;
import net.minecraft.data.tags.StructureTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.data.tags.TradeRebalanceStructureTagsProvider;
import net.minecraft.data.tags.VanillaBlockTagsProvider;
import net.minecraft.data.tags.VanillaItemTagsProvider;
import net.minecraft.data.tags.WorldPresetTagsProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.obfuscate.DontObfuscate;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraftforge.data.loading.DatagenModLoader;

public class Main {
    @DontObfuscate
    public static void main(String[] p_129669_) throws IOException {
        SharedConstants.m_142977_();
        OptionParser optionparser = new OptionParser();
        AbstractOptionSpec optionspec = optionparser.accepts("help", "Show the help menu").forHelp();
        OptionSpecBuilder optionspec1 = optionparser.accepts("server", "Include server generators");
        OptionSpecBuilder optionspec2 = optionparser.accepts("client", "Include client generators");
        OptionSpecBuilder optionspec3 = optionparser.accepts("dev", "Include development tools");
        OptionSpecBuilder optionspec4 = optionparser.accepts("reports", "Include data reports");
        OptionSpecBuilder optionspec5 = optionparser.accepts("validate", "Validate inputs");
        OptionSpecBuilder optionspec6 = optionparser.accepts("all", "Include all generators");
        ArgumentAcceptingOptionSpec optionspec7 = optionparser.accepts("output", "Output folder").withRequiredArg().defaultsTo((Object)"generated", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec optionspec8 = optionparser.accepts("input", "Input folder").withRequiredArg();
        ArgumentAcceptingOptionSpec existing = optionparser.accepts("existing", "Existing resource packs that generated resources can reference").withRequiredArg();
        ArgumentAcceptingOptionSpec existingMod = optionparser.accepts("existing-mod", "Existing mods that generated resources can reference the resource packs of").withRequiredArg();
        ArgumentAcceptingOptionSpec gameDir = optionparser.accepts("gameDir").withRequiredArg().ofType(File.class).defaultsTo((Object)new File("."), (Object[])new File[0]).required();
        ArgumentAcceptingOptionSpec mod = optionparser.accepts("mod", "A modid to dump").withRequiredArg().withValuesSeparatedBy(",");
        OptionSpecBuilder flat = optionparser.accepts("flat", "Do not append modid prefix to output directory when generating for multiple mods");
        ArgumentAcceptingOptionSpec assetIndex = optionparser.accepts("assetIndex").withRequiredArg();
        ArgumentAcceptingOptionSpec assetsDir = optionparser.accepts("assetsDir").withRequiredArg().ofType(File.class);
        OptionSet optionset = optionparser.parse(p_129669_);
        if (!(optionset.has((OptionSpec)optionspec) || !optionset.hasOptions() || optionset.specs().size() == 1 && optionset.has((OptionSpec)gameDir))) {
            Path path = Paths.get((String)optionspec7.value(optionset), new String[0]);
            boolean flag = optionset.has((OptionSpec)optionspec6);
            boolean flag1 = flag || optionset.has((OptionSpec)optionspec2);
            boolean flag2 = flag || optionset.has((OptionSpec)optionspec1);
            boolean flag3 = flag || optionset.has((OptionSpec)optionspec3);
            boolean flag4 = flag || optionset.has((OptionSpec)optionspec4);
            boolean flag5 = flag || optionset.has((OptionSpec)optionspec5);
            Collection inputs = optionset.valuesOf((OptionSpec)optionspec8).stream().map(p_129659_ -> Paths.get(p_129659_, new String[0])).collect(Collectors.toList());
            Collection existingPacks = optionset.valuesOf((OptionSpec)existing).stream().map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList());
            HashSet existingMods = new HashSet(optionset.valuesOf((OptionSpec)existingMod));
            HashSet mods = new HashSet(optionset.valuesOf((OptionSpec)mod));
            boolean isFlat = mods.isEmpty() || optionset.has((OptionSpec)flat);
            DatagenModLoader.begin(mods, (Path)path, (Collection)inputs, (Collection)existingPacks, existingMods, (boolean)flag2, (boolean)flag1, (boolean)flag3, (boolean)flag4, (boolean)flag5, (boolean)isFlat, (String)((String)optionset.valueOf((OptionSpec)assetIndex)), (File)((File)optionset.valueOf((OptionSpec)assetsDir)));
            if (mods.contains("minecraft") || mods.isEmpty()) {
                Main.m_236679_(isFlat ? path : path.resolve("minecraft"), inputs, flag1, flag2, flag3, flag4, flag5, SharedConstants.m_183709_(), true).m_123917_();
            }
        } else {
            optionparser.printHelpOn((OutputStream)System.out);
        }
    }

    private static <T extends DataProvider> DataProvider.Factory<T> m_255400_(BiFunction<PackOutput, CompletableFuture<HolderLookup.Provider>, T> p_256618_, CompletableFuture<HolderLookup.Provider> p_256515_) {
        return p_255476_ -> (DataProvider)p_256618_.apply(p_255476_, p_256515_);
    }

    public static DataGenerator m_236679_(Path p_236680_, Collection<Path> p_236681_, boolean p_236682_, boolean p_236683_, boolean p_236684_, boolean p_236685_, boolean p_236686_, WorldVersion p_236687_, boolean p_236688_) {
        DataGenerator datagenerator = new DataGenerator(p_236680_, p_236687_, p_236688_);
        DataGenerator.PackGenerator datagenerator$packgenerator = datagenerator.m_253147_(p_236682_ || p_236683_);
        datagenerator$packgenerator.m_253108_(p_253388_ -> new SnbtToNbt(p_253388_, (Iterable)p_236681_).m_126475_((SnbtToNbt.Filter)new StructureUpdater()));
        CompletableFuture<HolderLookup.Provider> completablefuture = CompletableFuture.supplyAsync(VanillaRegistries::m_255371_, Util.m_183991_());
        DataGenerator.PackGenerator datagenerator$packgenerator1 = datagenerator.m_253147_(p_236682_);
        datagenerator$packgenerator1.m_253108_(ModelProvider::new);
        DataGenerator.PackGenerator datagenerator$packgenerator2 = datagenerator.m_253147_(p_236683_);
        datagenerator$packgenerator2.m_253108_(Main.m_255400_(RegistriesDatapackGenerator::new, completablefuture));
        datagenerator$packgenerator2.m_253108_(Main.m_255400_(VanillaAdvancementProvider::m_255090_, completablefuture));
        datagenerator$packgenerator2.m_253108_(VanillaLootTableProvider::m_247452_);
        datagenerator$packgenerator2.m_253108_(VanillaRecipeProvider::new);
        TagsProvider tagsprovider1 = (TagsProvider)datagenerator$packgenerator2.m_253108_(Main.m_255400_(VanillaBlockTagsProvider::new, completablefuture));
        TagsProvider tagsprovider = (TagsProvider)datagenerator$packgenerator2.m_253108_(p_274753_ -> new VanillaItemTagsProvider(p_274753_, completablefuture, tagsprovider1.m_274426_()));
        datagenerator$packgenerator2.m_253108_(Main.m_255400_(BannerPatternTagsProvider::new, completablefuture));
        datagenerator$packgenerator2.m_253108_(Main.m_255400_(BiomeTagsProvider::new, completablefuture));
        datagenerator$packgenerator2.m_253108_(Main.m_255400_(CatVariantTagsProvider::new, completablefuture));
        datagenerator$packgenerator2.m_253108_(Main.m_255400_(DamageTypeTagsProvider::new, completablefuture));
        datagenerator$packgenerator2.m_253108_(Main.m_255400_(EntityTypeTagsProvider::new, completablefuture));
        datagenerator$packgenerator2.m_253108_(Main.m_255400_(FlatLevelGeneratorPresetTagsProvider::new, completablefuture));
        datagenerator$packgenerator2.m_253108_(Main.m_255400_(FluidTagsProvider::new, completablefuture));
        datagenerator$packgenerator2.m_253108_(Main.m_255400_(GameEventTagsProvider::new, completablefuture));
        datagenerator$packgenerator2.m_253108_(Main.m_255400_(InstrumentTagsProvider::new, completablefuture));
        datagenerator$packgenerator2.m_253108_(Main.m_255400_(PaintingVariantTagsProvider::new, completablefuture));
        datagenerator$packgenerator2.m_253108_(Main.m_255400_(PoiTypeTagsProvider::new, completablefuture));
        datagenerator$packgenerator2.m_253108_(Main.m_255400_(StructureTagsProvider::new, completablefuture));
        datagenerator$packgenerator2.m_253108_(Main.m_255400_(WorldPresetTagsProvider::new, completablefuture));
        datagenerator$packgenerator2 = datagenerator.m_253147_(p_236684_);
        datagenerator$packgenerator2.m_253108_(p_253386_ -> new NbtToSnbt(p_253386_, p_236681_));
        datagenerator$packgenerator2 = datagenerator.m_253147_(p_236685_);
        datagenerator$packgenerator2.m_253108_(Main.m_255400_(BiomeParametersDumpReport::new, completablefuture));
        datagenerator$packgenerator2.m_253108_(BlockListReport::new);
        datagenerator$packgenerator2.m_253108_(Main.m_255400_(CommandsReport::new, completablefuture));
        datagenerator$packgenerator2.m_253108_(RegistryDumpReport::new);
        datagenerator$packgenerator2 = datagenerator.m_253030_(p_236683_, "bundle");
        datagenerator$packgenerator2.m_253108_(BundleRecipeProvider::new);
        datagenerator$packgenerator2.m_253108_(p_296336_ -> PackMetadataGenerator.m_252835_((PackOutput)p_296336_, (Component)Component.m_237115_((String)"dataPack.bundle.description"), (FeatureFlagSet)FeatureFlagSet.m_247091_((FeatureFlag)FeatureFlags.f_244112_)));
        datagenerator$packgenerator2 = datagenerator.m_253030_(p_236683_, "trade_rebalance");
        datagenerator$packgenerator2.m_253108_(p_296336_ -> PackMetadataGenerator.m_252835_((PackOutput)p_296336_, (Component)Component.m_237115_((String)"dataPack.trade_rebalance.description"), (FeatureFlagSet)FeatureFlagSet.m_247091_((FeatureFlag)FeatureFlags.f_291580_)));
        datagenerator$packgenerator2.m_253108_(TradeRebalanceLootTableProvider::m_292928_);
        datagenerator$packgenerator2.m_253108_(Main.m_255400_(TradeRebalanceStructureTagsProvider::new, completablefuture));
        return datagenerator;
    }
}

