/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderOwner;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraftforge.common.extensions.IForgeHolderSet;
import org.jetbrains.annotations.VisibleForTesting;

public interface HolderSet<T>
extends Iterable<Holder<T>>,
IForgeHolderSet<T> {
    public Stream<Holder<T>> m_203614_();

    public int m_203632_();

    public Either<TagKey<T>, List<Holder<T>>> m_203440_();

    public Optional<Holder<T>> m_213653_(RandomSource var1);

    public Holder<T> m_203662_(int var1);

    public boolean m_203333_(Holder<T> var1);

    public boolean m_207277_(HolderOwner<T> var1);

    public Optional<TagKey<T>> m_245234_();

    @Deprecated
    @VisibleForTesting
    public static <T> Named<T> m_255229_(HolderOwner<T> p_255858_, TagKey<T> p_256459_) {
        return new Named<T>(p_255858_, p_256459_);
    }

    @SafeVarargs
    public static <T> Direct<T> m_205809_(Holder<T> ... p_205810_) {
        return new Direct<T>(List.of(p_205810_));
    }

    public static <T> Direct<T> m_205800_(List<? extends Holder<T>> p_205801_) {
        return new Direct(List.copyOf(p_205801_));
    }

    @SafeVarargs
    public static <E, T> Direct<T> m_205806_(Function<E, Holder<T>> p_205807_, E ... p_205808_) {
        return HolderSet.m_205800_(Stream.of(p_205808_).map(p_205807_).toList());
    }

    public static <E, T> Direct<T> m_205803_(Function<E, Holder<T>> p_205804_, Collection<E> p_298882_) {
        return HolderSet.m_205800_(p_298882_.stream().map(p_205804_).toList());
    }

    public static class Named<T>
    extends ListBacked<T> {
        private final HolderOwner<T> f_254711_;
        private final TagKey<T> f_205829_;
        private List<Holder<T>> f_205830_ = List.of();
        private List<Runnable> invalidationCallbacks = new ArrayList<Runnable>();

        Named(HolderOwner<T> p_256118_, TagKey<T> p_256597_) {
            this.f_254711_ = p_256118_;
            this.f_205829_ = p_256597_;
        }

        public void m_205835_(List<Holder<T>> p_205836_) {
            this.f_205830_ = List.copyOf(p_205836_);
            for (Runnable runnable : this.invalidationCallbacks) {
                runnable.run();
            }
        }

        public TagKey<T> m_205839_() {
            return this.f_205829_;
        }

        @Override
        protected List<Holder<T>> m_203661_() {
            return this.f_205830_;
        }

        @Override
        public Either<TagKey<T>, List<Holder<T>>> m_203440_() {
            return Either.left(this.f_205829_);
        }

        @Override
        public Optional<TagKey<T>> m_245234_() {
            return Optional.of(this.f_205829_);
        }

        @Override
        public boolean m_203333_(Holder<T> p_205834_) {
            return p_205834_.m_203656_(this.f_205829_);
        }

        public String toString() {
            return "NamedSet(" + this.f_205829_ + ")[" + this.f_205830_ + "]";
        }

        @Override
        public boolean m_207277_(HolderOwner<T> p_256542_) {
            return this.f_254711_.m_254921_(p_256542_);
        }

        public void addInvalidationListener(Runnable runnable) {
            this.invalidationCallbacks.add(runnable);
        }
    }

    public static class Direct<T>
    extends ListBacked<T> {
        private final List<Holder<T>> f_205811_;
        @Nullable
        private Set<Holder<T>> f_205812_;

        Direct(List<Holder<T>> p_205814_) {
            this.f_205811_ = p_205814_;
        }

        @Override
        protected List<Holder<T>> m_203661_() {
            return this.f_205811_;
        }

        @Override
        public Either<TagKey<T>, List<Holder<T>>> m_203440_() {
            return Either.right(this.f_205811_);
        }

        @Override
        public Optional<TagKey<T>> m_245234_() {
            return Optional.empty();
        }

        @Override
        public boolean m_203333_(Holder<T> p_205816_) {
            if (this.f_205812_ == null) {
                this.f_205812_ = Set.copyOf(this.f_205811_);
            }
            return this.f_205812_.contains(p_205816_);
        }

        public String toString() {
            return "DirectSet[" + this.f_205811_ + "]";
        }
    }

    public static abstract class ListBacked<T>
    implements HolderSet<T> {
        protected abstract List<Holder<T>> m_203661_();

        @Override
        public int m_203632_() {
            return this.m_203661_().size();
        }

        @Override
        public Spliterator<Holder<T>> spliterator() {
            return this.m_203661_().spliterator();
        }

        @Override
        public Iterator<Holder<T>> iterator() {
            return this.m_203661_().iterator();
        }

        @Override
        public Stream<Holder<T>> m_203614_() {
            return this.m_203661_().stream();
        }

        @Override
        public Optional<Holder<T>> m_213653_(RandomSource p_235714_) {
            return Util.m_214676_(this.m_203661_(), p_235714_);
        }

        @Override
        public Holder<T> m_203662_(int p_205823_) {
            return this.m_203661_().get(p_205823_);
        }

        @Override
        public boolean m_207277_(HolderOwner<T> p_255876_) {
            return true;
        }
    }
}

