/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture.atlas;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.client.resources.metadata.animation.FrameSize;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceMetadata;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import org.slf4j.Logger;

@FunctionalInterface
@OnlyIn(value=Dist.CLIENT)
public interface SpriteResourceLoader {
    public static final Logger f_260482_ = LogUtils.getLogger();

    public static SpriteResourceLoader m_292996_(Collection<MetadataSectionSerializer<?>> p_299052_) {
        return (p_296303_, p_296304_) -> {
            NativeImage nativeimage;
            ResourceMetadata resourcemetadata;
            try {
                resourcemetadata = p_296304_.m_215509_().m_293991_(p_299052_);
            }
            catch (Exception exception) {
                f_260482_.error("Unable to parse metadata from {}", (Object)p_296303_, (Object)exception);
                return null;
            }
            try (InputStream inputstream = p_296304_.m_215507_();){
                nativeimage = NativeImage.m_85058_((InputStream)inputstream);
            }
            catch (IOException ioexception) {
                f_260482_.error("Using missing texture, unable to load {}", (Object)p_296303_, (Object)ioexception);
                return null;
            }
            AnimationMetadataSection animationmetadatasection = resourcemetadata.m_214059_((MetadataSectionSerializer)AnimationMetadataSection.f_119011_).orElse(AnimationMetadataSection.f_119012_);
            FrameSize framesize = animationmetadatasection.m_245821_(nativeimage.m_84982_(), nativeimage.m_85084_());
            if (Mth.m_264612_((int)nativeimage.m_84982_(), (int)framesize.f_244129_()) && Mth.m_264612_((int)nativeimage.m_85084_(), (int)framesize.f_244503_())) {
                SpriteContents contents = ForgeHooksClient.loadSpriteContents((ResourceLocation)p_296303_, (Resource)p_296304_, (FrameSize)framesize, (NativeImage)nativeimage, (ResourceMetadata)resourcemetadata);
                if (contents != null) {
                    return contents;
                }
                return new SpriteContents(p_296303_, framesize, nativeimage, resourcemetadata);
            }
            f_260482_.error("Image {} size {},{} is not multiple of frame size {},{}", new Object[]{p_296303_, nativeimage.m_84982_(), nativeimage.m_85084_(), framesize.f_244129_(), framesize.f_244503_()});
            nativeimage.close();
            return null;
        };
    }

    @Nullable
    public SpriteContents m_294584_(ResourceLocation var1, Resource var2);
}

