/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.multiplayer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.DisconnectedScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.multiplayer.CommonListenerCookie;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.ServerList;
import net.minecraft.client.telemetry.WorldSessionTelemetryManager;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.Connection;
import net.minecraft.network.PacketListener;
import net.minecraft.network.ServerboundPacketListener;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketUtils;
import net.minecraft.network.protocol.common.ClientCommonPacketListener;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.ClientboundDisconnectPacket;
import net.minecraft.network.protocol.common.ClientboundKeepAlivePacket;
import net.minecraft.network.protocol.common.ClientboundPingPacket;
import net.minecraft.network.protocol.common.ClientboundResourcePackPacket;
import net.minecraft.network.protocol.common.ClientboundUpdateTagsPacket;
import net.minecraft.network.protocol.common.ServerboundKeepAlivePacket;
import net.minecraft.network.protocol.common.ServerboundPongPacket;
import net.minecraft.network.protocol.common.ServerboundResourcePackPacket;
import net.minecraft.network.protocol.common.custom.BrandPayload;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.common.custom.DiscardedPayload;
import net.minecraft.realms.DisconnectedRealmsScreen;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagNetworkSerialization;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.network.ICustomPacket;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public abstract class ClientCommonPacketListenerImpl
implements ClientCommonPacketListener {
    private static final Component f_291297_ = Component.m_237115_((String)"disconnect.lost");
    private static final Logger f_290426_ = LogUtils.getLogger();
    protected final Minecraft f_291812_;
    protected final Connection f_290549_;
    @Nullable
    protected final ServerData f_291024_;
    @Nullable
    protected String f_291180_;
    protected final WorldSessionTelemetryManager f_291019_;
    @Nullable
    protected final Screen f_291028_;
    private final List<DeferredPacket> f_291530_ = new ArrayList<DeferredPacket>();

    protected ClientCommonPacketListenerImpl(Minecraft p_300051_, Connection p_300688_, CommonListenerCookie p_300429_) {
        this.f_291812_ = p_300051_;
        this.f_290549_ = p_300688_;
        this.f_291024_ = p_300429_.f_290465_();
        this.f_291180_ = p_300429_.f_291604_();
        this.f_291019_ = p_300429_.f_290317_();
        this.f_291028_ = p_300429_.f_291050_();
    }

    public void m_292764_(ClientboundKeepAlivePacket p_301155_) {
        this.m_292916_((Packet<? extends ServerboundPacketListener>)new ServerboundKeepAlivePacket(p_301155_.m_295012_()), () -> !RenderSystem.isFrozenAtPollEvents(), Duration.ofMinutes(1L));
    }

    public void m_293992_(ClientboundPingPacket p_300922_) {
        PacketUtils.m_131363_((Packet)p_300922_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        this.m_295327_((Packet<?>)new ServerboundPongPacket(p_300922_.m_293261_()));
    }

    public void m_293213_(ClientboundCustomPayloadPacket p_298103_) {
        if (ForgeHooks.onCustomPayload((ICustomPacket)p_298103_, (Connection)this.f_290549_)) {
            return;
        }
        CustomPacketPayload custompacketpayload = p_298103_.f_291001_();
        if (!(custompacketpayload instanceof DiscardedPayload)) {
            PacketUtils.m_131363_((Packet)p_298103_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
            if (custompacketpayload instanceof BrandPayload) {
                BrandPayload brandpayload = (BrandPayload)custompacketpayload;
                this.f_291180_ = brandpayload.f_291526_();
                this.f_291019_.m_260918_(brandpayload.f_291526_());
            } else {
                this.m_105003_(custompacketpayload);
            }
        }
    }

    protected abstract void m_105003_(CustomPacketPayload var1);

    protected abstract RegistryAccess.Frozen m_105152_();

    public void m_292941_(ClientboundResourcePackPacket p_300555_) {
        URL url = ClientCommonPacketListenerImpl.m_295112_(p_300555_.m_293033_());
        if (url == null) {
            this.m_294472_(ServerboundResourcePackPacket.Action.FAILED_DOWNLOAD);
        } else {
            String s = p_300555_.m_295050_();
            boolean flag = p_300555_.m_294040_();
            if (this.f_291024_ != null && this.f_291024_.m_105387_() == ServerData.ServerPackStatus.ENABLED) {
                this.m_294472_(ServerboundResourcePackPacket.Action.ACCEPTED);
                this.m_294017_(this.f_291812_.m_247489_().m_246254_(url, s, true));
            } else if (!(this.f_291024_ == null || this.f_291024_.m_105387_() == ServerData.ServerPackStatus.PROMPT || flag && this.f_291024_.m_105387_() == ServerData.ServerPackStatus.DISABLED)) {
                this.m_294472_(ServerboundResourcePackPacket.Action.DECLINED);
                if (flag) {
                    this.f_290549_.m_129507_((Component)Component.m_237115_((String)"multiplayer.requiredTexturePrompt.disconnect"));
                }
            } else {
                this.f_291812_.execute(() -> this.m_295892_(url, s, flag, p_300555_.m_292957_()));
            }
        }
    }

    private void m_295892_(URL p_299293_, String p_297795_, boolean p_297484_, @Nullable Component p_300186_) {
        Screen screen = this.f_291812_.f_91080_;
        this.f_291812_.m_91152_((Screen)new ConfirmScreen(p_298595_ -> {
            this.f_291812_.m_91152_(screen);
            if (p_298595_) {
                if (this.f_291024_ != null) {
                    this.f_291024_.m_105379_(ServerData.ServerPackStatus.ENABLED);
                }
                this.m_294472_(ServerboundResourcePackPacket.Action.ACCEPTED);
                this.m_294017_(this.f_291812_.m_247489_().m_246254_(p_299293_, p_297795_, true));
            } else {
                this.m_294472_(ServerboundResourcePackPacket.Action.DECLINED);
                if (p_297484_) {
                    this.f_290549_.m_129507_((Component)Component.m_237115_((String)"multiplayer.requiredTexturePrompt.disconnect"));
                } else if (this.f_291024_ != null) {
                    this.f_291024_.m_105379_(ServerData.ServerPackStatus.DISABLED);
                }
            }
            if (this.f_291024_ != null) {
                ServerList.m_105446_((ServerData)this.f_291024_);
            }
        }, (Component)(p_297484_ ? Component.m_237115_((String)"multiplayer.requiredTexturePrompt.line1") : Component.m_237115_((String)"multiplayer.texturePrompt.line1")), ClientCommonPacketListenerImpl.m_294992_((Component)(p_297484_ ? Component.m_237115_((String)"multiplayer.requiredTexturePrompt.line2").m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD}) : Component.m_237115_((String)"multiplayer.texturePrompt.line2")), p_300186_), p_297484_ ? CommonComponents.f_130659_ : CommonComponents.f_130657_, (Component)(p_297484_ ? Component.m_237115_((String)"menu.disconnect") : CommonComponents.f_130658_)));
    }

    private static Component m_294992_(Component p_299226_, @Nullable Component p_298885_) {
        return p_298885_ == null ? p_299226_ : Component.m_237110_((String)"multiplayer.texturePrompt.serverPrompt", (Object[])new Object[]{p_299226_, p_298885_});
    }

    @Nullable
    private static URL m_295112_(String p_298850_) {
        try {
            URL url = new URL(p_298850_);
            String s = url.getProtocol();
            return !"http".equals(s) && !"https".equals(s) ? null : url;
        }
        catch (MalformedURLException malformedurlexception) {
            return null;
        }
    }

    private void m_294017_(CompletableFuture<?> p_297539_) {
        ((CompletableFuture)p_297539_.thenRun(() -> this.m_294472_(ServerboundResourcePackPacket.Action.SUCCESSFULLY_LOADED))).exceptionally(p_299077_ -> {
            this.m_294472_(ServerboundResourcePackPacket.Action.FAILED_DOWNLOAD);
            return null;
        });
    }

    public void m_105133_(ClientboundUpdateTagsPacket p_299537_) {
        PacketUtils.m_131363_((Packet)p_299537_, (PacketListener)this, (BlockableEventLoop)this.f_291812_);
        p_299537_.m_294928_().forEach(this::m_294832_);
    }

    private <T> void m_294832_(ResourceKey<? extends Registry<? extends T>> p_301094_, TagNetworkSerialization.NetworkPayload p_297701_) {
        if (!p_297701_.m_203966_()) {
            Registry registry = (Registry)this.m_105152_().m_6632_(p_301094_).orElseThrow(() -> new IllegalStateException("Unknown registry " + p_301094_));
            HashMap map = new HashMap();
            TagNetworkSerialization.m_203952_(p_301094_, (Registry)registry, (TagNetworkSerialization.NetworkPayload)p_297701_, map::put);
            registry.m_203652_(map);
        }
    }

    private void m_294472_(ServerboundResourcePackPacket.Action p_299758_) {
        this.f_290549_.m_129512_((Packet<?>)new ServerboundResourcePackPacket(p_299758_));
    }

    public void m_293975_(ClientboundDisconnectPacket p_298016_) {
        this.f_290549_.m_129507_(p_298016_.m_295854_());
    }

    protected void m_295826_() {
        Iterator<DeferredPacket> iterator = this.f_291530_.iterator();
        while (iterator.hasNext()) {
            DeferredPacket clientcommonpacketlistenerimpl$deferredpacket = iterator.next();
            if (clientcommonpacketlistenerimpl$deferredpacket.f_291727_().getAsBoolean()) {
                this.m_295327_(clientcommonpacketlistenerimpl$deferredpacket.f_291164_);
                iterator.remove();
                continue;
            }
            if (clientcommonpacketlistenerimpl$deferredpacket.f_291012_() > Util.m_137550_()) continue;
            iterator.remove();
        }
    }

    public void m_295327_(Packet<?> p_300175_) {
        this.f_290549_.m_129512_(p_300175_);
    }

    public void m_7026_(Component p_298766_) {
        this.f_291019_.m_261027_();
        this.f_291812_.m_91320_(this.m_295606_(p_298766_));
        f_290426_.warn("Client disconnected with reason: {}", (Object)p_298766_.getString());
    }

    protected Screen m_295606_(Component p_299787_) {
        Screen screen = Objects.requireNonNullElseGet(this.f_291028_, () -> new JoinMultiplayerScreen(new TitleScreen()));
        return this.f_291024_ != null && this.f_291024_.m_295074_() ? new DisconnectedRealmsScreen(screen, f_291297_, p_299787_) : new DisconnectedScreen(screen, f_291297_, p_299787_);
    }

    @Nullable
    public String m_295034_() {
        return this.f_291180_;
    }

    private void m_292916_(Packet<? extends ServerboundPacketListener> p_300852_, BooleanSupplier p_299754_, Duration p_299011_) {
        if (p_299754_.getAsBoolean()) {
            this.m_295327_(p_300852_);
        } else {
            this.f_291530_.add(new DeferredPacket(p_300852_, p_299754_, Util.m_137550_() + p_299011_.toMillis()));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    record DeferredPacket(Packet<? extends ServerboundPacketListener> f_291164_, BooleanSupplier f_291727_, long f_291012_) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{DeferredPacket.class, "packet;sendCondition;expirationTime", "f_291164_", "f_291727_", "f_291012_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{DeferredPacket.class, "packet;sendCondition;expirationTime", "f_291164_", "f_291727_", "f_291012_"}, this);
        }

        @Override
        public final boolean equals(Object p_297419_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{DeferredPacket.class, "packet;sendCondition;expirationTime", "f_291164_", "f_291727_", "f_291012_"}, this, p_297419_);
        }
    }
}

