/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens;

import com.mojang.logging.LogUtils;
import io.netty.channel.ChannelFuture;
import java.net.InetSocketAddress;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.Util;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.DisconnectedScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientHandshakePacketListenerImpl;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.chat.report.ReportEnvironment;
import net.minecraft.client.multiplayer.resolver.ResolvedServerAddress;
import net.minecraft.client.multiplayer.resolver.ServerAddress;
import net.minecraft.client.multiplayer.resolver.ServerNameResolver;
import net.minecraft.client.quickplay.QuickPlay;
import net.minecraft.client.quickplay.QuickPlayLog;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.login.ServerboundHelloPacket;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.DualStackUtils;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ConnectScreen
extends Screen {
    private static final AtomicInteger f_95682_ = new AtomicInteger(0);
    static final Logger f_95683_ = LogUtils.getLogger();
    private static final long f_169261_ = 2000L;
    public static final Component f_290019_ = Component.m_237115_((String)"connect.aborted");
    public static final Component f_169260_ = Component.m_237110_((String)"disconnect.genericReason", (Object[])new Object[]{Component.m_237115_((String)"disconnect.unknownHost")});
    @Nullable
    volatile Connection f_95684_;
    @Nullable
    ChannelFuture f_290020_;
    volatile boolean f_95685_;
    final Screen f_95686_;
    private Component f_95687_ = Component.m_237115_((String)"connect.connecting");
    private long f_95688_ = -1L;
    final Component f_278471_;

    private ConnectScreen(Screen p_279215_, Component p_279228_) {
        super(GameNarrator.f_93310_);
        this.f_95686_ = p_279215_;
        this.f_278471_ = p_279228_;
    }

    public static void m_278792_(Screen p_279473_, Minecraft p_279200_, ServerAddress p_279150_, ServerData p_279481_, boolean p_279117_) {
        if (p_279200_.f_91080_ instanceof ConnectScreen) {
            f_95683_.error("Attempt to connect while already connecting");
        } else {
            ConnectScreen connectscreen = new ConnectScreen(p_279473_, p_279117_ ? QuickPlay.f_278484_ : CommonComponents.f_130661_);
            p_279200_.m_293444_();
            p_279200_.m_193588_();
            p_279200_.m_239476_(ReportEnvironment.m_238998_((String)(p_279481_ != null ? p_279481_.f_105363_ : p_279150_.m_171863_())));
            p_279200_.m_278644_().m_278642_(QuickPlayLog.Type.MULTIPLAYER, p_279481_.f_105363_, p_279481_.f_105362_);
            p_279200_.m_91152_(connectscreen);
            connectscreen.m_247688_(p_279200_, p_279150_, p_279481_);
        }
    }

    private void m_247688_(final Minecraft p_251955_, final ServerAddress p_249536_, final @Nullable ServerData p_252078_) {
        f_95683_.info("Connecting to {}, {}", (Object)p_249536_.m_171863_(), (Object)p_249536_.m_171866_());
        Thread thread = new Thread("Server Connector #" + f_95682_.incrementAndGet()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                InetSocketAddress inetsocketaddress = null;
                try {
                    Connection connection;
                    if (ConnectScreen.this.f_95685_) {
                        return;
                    }
                    Optional<InetSocketAddress> optional = ServerNameResolver.f_171881_.m_171890_(p_249536_).map(ResolvedServerAddress::m_142641_);
                    if (ConnectScreen.this.f_95685_) {
                        return;
                    }
                    if (optional.isEmpty()) {
                        f_95683_.error("Couldn't connect to server: Unknown host \"{}\"", (Object)p_249536_.m_171863_());
                        DualStackUtils.logInitialPreferences();
                        p_251955_.execute(() -> p_251955_.m_91152_((Screen)new DisconnectedScreen(ConnectScreen.this.f_95686_, ConnectScreen.this.f_278471_, f_169260_)));
                        return;
                    }
                    inetsocketaddress = optional.get();
                    ConnectScreen connectScreen = ConnectScreen.this;
                    synchronized (connectScreen) {
                        if (ConnectScreen.this.f_95685_) {
                            return;
                        }
                        connection = new Connection(PacketFlow.CLIENTBOUND);
                        connection.m_292855_(p_251955_.m_293199_().m_293273_());
                        ConnectScreen.this.f_290020_ = Connection.m_290025_(inetsocketaddress, p_251955_.f_91066_.m_92175_(), connection);
                    }
                    ConnectScreen.this.f_290020_.syncUninterruptibly();
                    connectScreen = ConnectScreen.this;
                    synchronized (connectScreen) {
                        if (ConnectScreen.this.f_95685_) {
                            connection.m_129507_(f_290019_);
                            return;
                        }
                        ConnectScreen.this.f_95684_ = connection;
                    }
                    ConnectScreen.this.f_95684_.m_295889_(inetsocketaddress.getHostName(), inetsocketaddress.getPort(), new ClientHandshakePacketListenerImpl(ConnectScreen.this.f_95684_, p_251955_, p_252078_, ConnectScreen.this.f_95686_, false, null, ConnectScreen.this::m_95717_));
                    ConnectScreen.this.f_95684_.m_129512_((Packet<?>)new ServerboundHelloPacket(p_251955_.m_91094_().m_92546_(), p_251955_.m_91094_().m_240411_()));
                }
                catch (Exception exception2) {
                    Exception exception1;
                    if (ConnectScreen.this.f_95685_) {
                        return;
                    }
                    Throwable throwable = exception2.getCause();
                    Exception exception = throwable instanceof Exception ? (exception1 = (Exception)throwable) : exception2;
                    f_95683_.error("Couldn't connect to server", (Throwable)exception2);
                    String s = inetsocketaddress == null ? exception.getMessage() : exception.getMessage().replaceAll(inetsocketaddress.getHostName() + ":" + inetsocketaddress.getPort(), "").replaceAll(inetsocketaddress.toString(), "");
                    p_251955_.execute(() -> p_251955_.m_91152_((Screen)new DisconnectedScreen(ConnectScreen.this.f_95686_, ConnectScreen.this.f_278471_, (Component)Component.m_237110_((String)"disconnect.genericReason", (Object[])new Object[]{s}))));
                }
            }
        };
        thread.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(f_95683_));
        thread.start();
    }

    private void m_95717_(Component p_95718_) {
        this.f_95687_ = p_95718_;
    }

    @Override
    public void m_86600_() {
        if (this.f_95684_ != null) {
            if (this.f_95684_.m_129536_()) {
                this.f_95684_.m_129483_();
            } else {
                this.f_95684_.m_129541_();
            }
        }
    }

    @Override
    public boolean m_6913_() {
        return false;
    }

    @Override
    protected void m_7856_() {
        this.m_142416_(Button.m_253074_(CommonComponents.f_130656_, p_289624_ -> {
            ConnectScreen connectScreen = this;
            synchronized (connectScreen) {
                this.f_95685_ = true;
                if (this.f_290020_ != null) {
                    this.f_290020_.cancel(true);
                    this.f_290020_ = null;
                }
                if (this.f_95684_ != null) {
                    this.f_95684_.m_129507_(f_290019_);
                }
            }
            this.f_96541_.m_91152_(this.f_95686_);
        }).m_252987_(this.f_96543_ / 2 - 100, this.f_96544_ / 4 + 120 + 12, 200, 20).m_253136_());
    }

    @Override
    public void m_88315_(GuiGraphics p_283201_, int p_95701_, int p_95702_, float p_95703_) {
        super.m_88315_(p_283201_, p_95701_, p_95702_, p_95703_);
        long i = Util.m_137550_();
        if (i - this.f_95688_ > 2000L) {
            this.f_95688_ = i;
            this.f_96541_.m_240477_().m_168785_((Component)Component.m_237115_((String)"narrator.joining"));
        }
        p_283201_.m_280653_(this.f_96547_, this.f_95687_, this.f_96543_ / 2, this.f_96544_ / 2 - 50, 0xFFFFFF);
    }
}

