/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.animatable;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.PacketDistributor;
import software.bernie.geckolib.GeckoLib;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.network.GeckoLibNetwork;
import software.bernie.geckolib.network.SerializableDataTicket;
import software.bernie.geckolib.network.packet.BlockEntityAnimDataSyncPacket;
import software.bernie.geckolib.network.packet.BlockEntityAnimTriggerPacket;
import software.bernie.geckolib.util.RenderUtils;

public interface GeoBlockEntity
extends GeoAnimatable {
    @Nullable
    default public <D> D getAnimData(SerializableDataTicket<D> dataTicket) {
        return this.getAnimatableInstanceCache().getManagerForId(0L).getData(dataTicket);
    }

    default public <D> void setAnimData(SerializableDataTicket<D> dataTicket, D data) {
        BlockEntity blockEntity = (BlockEntity)this;
        Level level = blockEntity.m_58904_();
        if (level == null) {
            GeckoLib.LOGGER.error("Attempting to set animation data for BlockEntity too early! Must wait until after the BlockEntity has been set in the world. (" + blockEntity.getClass().toString() + ")");
            return;
        }
        if (level.m_5776_()) {
            this.getAnimatableInstanceCache().getManagerForId(0L).setData(dataTicket, data);
        } else {
            BlockPos pos = blockEntity.m_58899_();
            GeckoLibNetwork.send(new BlockEntityAnimDataSyncPacket<D>(pos, dataTicket, data), PacketDistributor.TRACKING_CHUNK.with((Object)level.m_46745_(pos)));
        }
    }

    default public void triggerAnim(@Nullable String controllerName, String animName) {
        BlockEntity blockEntity = (BlockEntity)this;
        Level level = blockEntity.m_58904_();
        if (level == null) {
            GeckoLib.LOGGER.error("Attempting to trigger an animation for a BlockEntity too early! Must wait until after the BlockEntity has been set in the world. (" + blockEntity.getClass().toString() + ")");
            return;
        }
        if (level.m_5776_()) {
            this.getAnimatableInstanceCache().getManagerForId(0L).tryTriggerAnimation(controllerName, animName);
        } else {
            BlockPos pos = blockEntity.m_58899_();
            GeckoLibNetwork.send(new BlockEntityAnimTriggerPacket(pos, controllerName, animName), PacketDistributor.TRACKING_CHUNK.with((Object)level.m_46745_(pos)));
        }
    }

    @Override
    default public double getTick(Object blockEntity) {
        return RenderUtils.getCurrentTick();
    }
}

