/*
 * Decompiled with CFR 0.152.
 */
package info.pixelmon.repack.org.tukaani.xz;

import info.pixelmon.repack.org.tukaani.xz.ArrayCache;
import info.pixelmon.repack.org.tukaani.xz.FilterEncoder;
import info.pixelmon.repack.org.tukaani.xz.FinishableOutputStream;
import info.pixelmon.repack.org.tukaani.xz.LZMA2Coder;
import info.pixelmon.repack.org.tukaani.xz.LZMA2Options;
import info.pixelmon.repack.org.tukaani.xz.lzma.LZMAEncoder;

class LZMA2Encoder
extends LZMA2Coder
implements FilterEncoder {
    private final LZMA2Options options;
    private final byte[] props = new byte[1];

    LZMA2Encoder(LZMA2Options lZMA2Options) {
        if (lZMA2Options.getPresetDict() != null) {
            throw new IllegalArgumentException("XZ doesn't support a preset dictionary for now");
        }
        if (lZMA2Options.getMode() == 0) {
            this.props[0] = 0;
        } else {
            int n = Math.max(lZMA2Options.getDictSize(), 4096);
            this.props[0] = (byte)(LZMAEncoder.getDistSlot(n - 1) - 23);
        }
        this.options = (LZMA2Options)lZMA2Options.clone();
    }

    @Override
    public long getFilterID() {
        return 33L;
    }

    @Override
    public byte[] getFilterProps() {
        return this.props;
    }

    @Override
    public boolean supportsFlushing() {
        return true;
    }

    @Override
    public FinishableOutputStream getOutputStream(FinishableOutputStream finishableOutputStream, ArrayCache arrayCache) {
        return this.options.getOutputStream(finishableOutputStream, arrayCache);
    }
}

