/*
 * Decompiled with CFR 0.152.
 */
package info.pixelmon.repack.org.tukaani.xz;

import info.pixelmon.repack.org.tukaani.xz.DeltaOptions;
import info.pixelmon.repack.org.tukaani.xz.FinishableOutputStream;
import info.pixelmon.repack.org.tukaani.xz.XZIOException;
import info.pixelmon.repack.org.tukaani.xz.delta.DeltaEncoder;
import java.io.IOException;

class DeltaOutputStream
extends FinishableOutputStream {
    private static final int FILTER_BUF_SIZE = 4096;
    private FinishableOutputStream out;
    private final DeltaEncoder delta;
    private final byte[] filterBuf = new byte[4096];
    private boolean finished = false;
    private IOException exception = null;
    private final byte[] tempBuf = new byte[1];

    static int getMemoryUsage() {
        return 5;
    }

    DeltaOutputStream(FinishableOutputStream finishableOutputStream, DeltaOptions deltaOptions) {
        this.out = finishableOutputStream;
        this.delta = new DeltaEncoder(deltaOptions.getDistance());
    }

    @Override
    public void write(int n) throws IOException {
        this.tempBuf[0] = (byte)n;
        this.write(this.tempBuf, 0, 1);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n + n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.exception != null) {
            throw this.exception;
        }
        if (this.finished) {
            throw new XZIOException("Stream finished");
        }
        try {
            while (n2 > 4096) {
                this.delta.encode(byArray, n, 4096, this.filterBuf);
                this.out.write(this.filterBuf);
                n += 4096;
                n2 -= 4096;
            }
            this.delta.encode(byArray, n, n2, this.filterBuf);
            this.out.write(this.filterBuf, 0, n2);
        }
        catch (IOException iOException) {
            this.exception = iOException;
            throw iOException;
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.exception != null) {
            throw this.exception;
        }
        if (this.finished) {
            throw new XZIOException("Stream finished or closed");
        }
        try {
            this.out.flush();
        }
        catch (IOException iOException) {
            this.exception = iOException;
            throw iOException;
        }
    }

    @Override
    public void finish() throws IOException {
        if (!this.finished) {
            if (this.exception != null) {
                throw this.exception;
            }
            try {
                this.out.finish();
            }
            catch (IOException iOException) {
                this.exception = iOException;
                throw iOException;
            }
            this.finished = true;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.out != null) {
            block4: {
                try {
                    this.out.close();
                }
                catch (IOException iOException) {
                    if (this.exception != null) break block4;
                    this.exception = iOException;
                }
            }
            this.out = null;
        }
        if (this.exception != null) {
            throw this.exception;
        }
    }
}

