/*
 * Decompiled with CFR 0.152.
 */
package info.pixelmon.repack.org.tukaani.xz;

import info.pixelmon.repack.org.tukaani.xz.FinishableOutputStream;
import java.io.IOException;
import java.io.OutputStream;

class CountingOutputStream
extends FinishableOutputStream {
    private final OutputStream out;
    private long size = 0L;

    public CountingOutputStream(OutputStream outputStream) {
        this.out = outputStream;
    }

    @Override
    public void write(int n) throws IOException {
        this.out.write(n);
        if (this.size >= 0L) {
            ++this.size;
        }
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.out.write(byArray, n, n2);
        if (this.size >= 0L) {
            this.size += (long)n2;
        }
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    public long getSize() {
        return this.size;
    }
}

