/*
 * Decompiled with CFR 0.152.
 */
package info.pixelmon.repack.org.spongepowered.yaml;

import info.pixelmon.repack.org.spongepowered.CommentedConfigurationNodeIntermediary;
import info.pixelmon.repack.org.spongepowered.ConfigurationNode;
import info.pixelmon.repack.org.spongepowered.loader.AbstractConfigurationLoader;
import info.pixelmon.repack.org.spongepowered.yaml.internal.snakeyaml.DumperOptions;
import info.pixelmon.repack.org.spongepowered.yaml.internal.snakeyaml.comments.CommentLine;
import info.pixelmon.repack.org.spongepowered.yaml.internal.snakeyaml.comments.CommentType;
import info.pixelmon.repack.org.spongepowered.yaml.internal.snakeyaml.nodes.MappingNode;
import info.pixelmon.repack.org.spongepowered.yaml.internal.snakeyaml.nodes.Node;
import info.pixelmon.repack.org.spongepowered.yaml.internal.snakeyaml.nodes.NodeTuple;
import info.pixelmon.repack.org.spongepowered.yaml.internal.snakeyaml.nodes.SequenceNode;
import info.pixelmon.repack.org.spongepowered.yaml.internal.snakeyaml.nodes.Tag;
import info.pixelmon.repack.org.spongepowered.yaml.internal.snakeyaml.representer.Represent;
import info.pixelmon.repack.org.spongepowered.yaml.internal.snakeyaml.representer.Representer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

final class YamlRepresenter
extends Representer {
    YamlRepresenter(DumperOptions options) {
        super(options);
        this.multiRepresenters.put(ConfigurationNode.class, new ConfigurationNodeRepresent());
    }

    private final class ConfigurationNodeRepresent
    implements Represent {
        private ConfigurationNodeRepresent() {
        }

        @Override
        public Node representData(Object nodeObject) {
            String nodeComment;
            Node yamlNode;
            ArrayList<NodeTuple> children;
            ConfigurationNode node = (ConfigurationNode)nodeObject;
            if (node.isMap()) {
                children = new ArrayList<NodeTuple>();
                for (Map.Entry<Object, ? extends ConfigurationNode> entry : node.childrenMap().entrySet()) {
                    Node value = YamlRepresenter.this.represent(entry.getValue());
                    Node key = YamlRepresenter.this.represent(String.valueOf(entry.getKey()));
                    key.setBlockComments(value.getBlockComments());
                    value.setBlockComments(Collections.emptyList());
                    children.add(new NodeTuple(key, value));
                }
                yamlNode = new MappingNode(Tag.MAP, children, DumperOptions.FlowStyle.AUTO);
            } else if (node.isList()) {
                children = new ArrayList();
                for (ConfigurationNode configurationNode : node.childrenList()) {
                    children.add((NodeTuple)((Object)YamlRepresenter.this.represent(configurationNode)));
                }
                yamlNode = new SequenceNode(Tag.SEQ, children, DumperOptions.FlowStyle.AUTO);
            } else {
                yamlNode = YamlRepresenter.this.represent(node.rawScalar());
            }
            if (node instanceof CommentedConfigurationNodeIntermediary && (nodeComment = ((CommentedConfigurationNodeIntermediary)node).comment()) != null) {
                yamlNode.setBlockComments(Arrays.stream(AbstractConfigurationLoader.CONFIGURATE_LINE_PATTERN.split(nodeComment)).map(this::commentLineFor).collect(Collectors.toList()));
            }
            return yamlNode;
        }

        private CommentLine commentLineFor(String comment) {
            return new CommentLine(null, null, " " + comment, CommentType.BLOCK);
        }
    }
}

