/*
 * Decompiled with CFR 0.152.
 */
package info.pixelmon.repack.org.spongepowered.yaml;

import info.pixelmon.repack.org.spongepowered.CommentedConfigurationNode;
import info.pixelmon.repack.org.spongepowered.ConfigurationNode;
import info.pixelmon.repack.org.spongepowered.ConfigurationOptions;
import info.pixelmon.repack.org.spongepowered.yaml.internal.snakeyaml.LoaderOptions;
import info.pixelmon.repack.org.spongepowered.yaml.internal.snakeyaml.comments.CommentLine;
import info.pixelmon.repack.org.spongepowered.yaml.internal.snakeyaml.constructor.Constructor;
import info.pixelmon.repack.org.spongepowered.yaml.internal.snakeyaml.nodes.MappingNode;
import info.pixelmon.repack.org.spongepowered.yaml.internal.snakeyaml.nodes.Node;
import info.pixelmon.repack.org.spongepowered.yaml.internal.snakeyaml.nodes.NodeId;
import info.pixelmon.repack.org.spongepowered.yaml.internal.snakeyaml.nodes.ScalarNode;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

class YamlConstructor
extends Constructor {
    private static final Pattern LINE_BREAK_PATTERN = Pattern.compile("\\R");
    @Nullable ConfigurationOptions options;

    YamlConstructor(LoaderOptions loadingConfig) {
        super(loadingConfig);
    }

    @Override
    @EnsuresNonNull(value={"options"})
    public Object getSingleData(Class<?> type) {
        if (this.options == null) {
            throw new IllegalStateException("options must be set before calling load!");
        }
        return super.getSingleData(type);
    }

    @Override
    protected Object constructObjectNoCheck(Node yamlNode) {
        CommentedConfigurationNode node = CommentedConfigurationNode.root(this.options);
        if (yamlNode.getNodeId() == NodeId.mapping) {
            node.raw(Collections.emptyMap());
            ((MappingNode)yamlNode).getValue().forEach(tuple -> {
                ScalarNode keyNode = (ScalarNode)tuple.getKeyNode();
                Node valueNode = tuple.getValueNode();
                ((CommentedConfigurationNode)((CommentedConfigurationNode)node.node(new Object[]{keyNode.getValue()})).from((ConfigurationNode)this.constructObject(valueNode))).comment(YamlConstructor.commentFor(keyNode.getBlockComments()));
            });
            return node.comment(YamlConstructor.commentFor(yamlNode.getBlockComments()));
        }
        Object raw = super.constructObjectNoCheck(yamlNode);
        if (raw instanceof Collection) {
            node.raw(Collections.emptyList());
            ((Collection)raw).forEach(value -> ((CommentedConfigurationNode)node.appendListNode()).from((ConfigurationNode)value));
        } else {
            node.raw(raw);
        }
        return node.comment(YamlConstructor.commentFor(yamlNode.getBlockComments()));
    }

    private static @Nullable String commentFor(@Nullable List<CommentLine> commentLines) {
        if (commentLines == null || commentLines.isEmpty()) {
            return null;
        }
        return commentLines.stream().map(input -> {
            String lineStripped = YamlConstructor.removeLineBreaksForLine(input.getValue());
            if (!lineStripped.isEmpty() && lineStripped.charAt(0) == ' ') {
                return lineStripped.substring(1);
            }
            return lineStripped;
        }).collect(Collectors.joining("\n"));
    }

    private static String removeLineBreaksForLine(String line) {
        return LINE_BREAK_PATTERN.matcher(line).replaceAll("");
    }
}

