/*
 * Decompiled with CFR 0.152.
 */
package info.pixelmon.repack.org.spongepowered.yaml;

import info.pixelmon.repack.org.spongepowered.CommentedConfigurationNode;
import info.pixelmon.repack.org.spongepowered.ConfigurationNode;
import info.pixelmon.repack.org.spongepowered.ConfigurationOptions;
import info.pixelmon.repack.org.spongepowered.loader.AbstractConfigurationLoader;
import info.pixelmon.repack.org.spongepowered.loader.CommentHandler;
import info.pixelmon.repack.org.spongepowered.loader.CommentHandlers;
import info.pixelmon.repack.org.spongepowered.loader.LoaderOptionSource;
import info.pixelmon.repack.org.spongepowered.serialize.SerializationException;
import info.pixelmon.repack.org.spongepowered.util.UnmodifiableCollections;
import info.pixelmon.repack.org.spongepowered.yaml.NodeStyle;
import info.pixelmon.repack.org.spongepowered.yaml.YamlConstructor;
import info.pixelmon.repack.org.spongepowered.yaml.YamlRepresenter;
import info.pixelmon.repack.org.spongepowered.yaml.internal.snakeyaml.DumperOptions;
import info.pixelmon.repack.org.spongepowered.yaml.internal.snakeyaml.LoaderOptions;
import info.pixelmon.repack.org.spongepowered.yaml.internal.snakeyaml.Yaml;
import info.pixelmon.repack.org.spongepowered.yaml.internal.snakeyaml.constructor.BaseConstructor;
import info.pixelmon.repack.org.spongepowered.yaml.internal.snakeyaml.representer.Representer;
import java.io.BufferedReader;
import java.io.Writer;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class YamlConfigurationLoader
extends AbstractConfigurationLoader<CommentedConfigurationNode> {
    private static final Set<Class<?>> NATIVE_TYPES = UnmodifiableCollections.toSet(Boolean.class, Integer.class, Long.class, BigInteger.class, Double.class, byte[].class, String.class, java.util.Date.class, Date.class, Timestamp.class);
    private final ThreadLocal<YamlConstructor> constructor;
    private final ThreadLocal<Yaml> yaml;

    public static Builder builder() {
        return new Builder();
    }

    private YamlConfigurationLoader(Builder builder) {
        super(builder, new CommentHandler[]{CommentHandlers.HASH});
        LoaderOptions loaderOpts = new LoaderOptions().setAcceptTabs(true).setProcessComments(builder.commentsEnabled());
        loaderOpts.setCodePointLimit(Integer.MAX_VALUE);
        DumperOptions opts = builder.options;
        opts.setDefaultFlowStyle(NodeStyle.asSnakeYaml(builder.style));
        opts.setProcessComments(builder.commentsEnabled());
        this.constructor = ThreadLocal.withInitial(() -> new YamlConstructor(loaderOpts));
        this.yaml = ThreadLocal.withInitial(() -> new Yaml((BaseConstructor)this.constructor.get(), (Representer)new YamlRepresenter(opts), opts, loaderOpts));
    }

    @Override
    protected void loadInternal(CommentedConfigurationNode node, BufferedReader reader) throws SerializationException {
        this.constructor.get().options = node.options();
        node.set(this.yaml.get().load(reader));
    }

    @Override
    protected void saveInternal(ConfigurationNode node, Writer writer) {
        this.yaml.get().dump(node, writer);
    }

    @Override
    public CommentedConfigurationNode createNode(ConfigurationOptions options) {
        return CommentedConfigurationNode.root(options);
    }

    public static final class Builder
    extends AbstractConfigurationLoader.Builder<Builder, YamlConfigurationLoader> {
        private final DumperOptions options = new DumperOptions();
        private @Nullable NodeStyle style;
        private boolean enableComments;

        Builder() {
            this.indent(4);
            this.defaultOptions(o -> o.nativeTypes(NATIVE_TYPES));
            this.from(DEFAULT_OPTIONS_SOURCE);
        }

        @Override
        protected void populate(LoaderOptionSource options) {
            @Nullable NodeStyle declared = options.getEnum(NodeStyle.class, "yaml", "node-style");
            if (declared != null) {
                this.style = declared;
            }
            this.enableComments = options.getBoolean(true, "yaml", "comments-enabled");
        }

        public Builder indent(int indent) {
            this.options.setIndent(indent);
            return this;
        }

        public int indent() {
            return this.options.getIndent();
        }

        public Builder nodeStyle(@Nullable NodeStyle style) {
            this.style = style;
            return this;
        }

        public @Nullable NodeStyle nodeStyle() {
            return this.style;
        }

        public Builder commentsEnabled(boolean enableComments) {
            this.enableComments = enableComments;
            return this;
        }

        public boolean commentsEnabled() {
            return this.enableComments;
        }

        @Override
        public YamlConfigurationLoader build() {
            return new YamlConfigurationLoader(this);
        }
    }
}

