/*
 * Decompiled with CFR 0.152.
 */
package info.pixelmon.repack.org.spongepowered.objectmapping;

import info.pixelmon.repack.org.spongepowered.BasicConfigurationNode;
import info.pixelmon.repack.org.spongepowered.ConfigurationNode;
import info.pixelmon.repack.org.spongepowered.ConfigurationOptions;
import info.pixelmon.repack.org.spongepowered.objectmapping.Definition;
import info.pixelmon.repack.org.spongepowered.objectmapping.FieldData;
import info.pixelmon.repack.org.spongepowered.objectmapping.FieldDiscoverer;
import info.pixelmon.repack.org.spongepowered.objectmapping.ObjectMapper;
import info.pixelmon.repack.org.spongepowered.objectmapping.ObjectMapperImpl;
import info.pixelmon.repack.org.spongepowered.objectmapping.meta.Comment;
import info.pixelmon.repack.org.spongepowered.objectmapping.meta.Constraint;
import info.pixelmon.repack.org.spongepowered.objectmapping.meta.Matches;
import info.pixelmon.repack.org.spongepowered.objectmapping.meta.NodeResolver;
import info.pixelmon.repack.org.spongepowered.objectmapping.meta.PostProcessor;
import info.pixelmon.repack.org.spongepowered.objectmapping.meta.Processor;
import info.pixelmon.repack.org.spongepowered.objectmapping.meta.Required;
import info.pixelmon.repack.org.spongepowered.serialize.SerializationException;
import info.pixelmon.repack.org.spongepowered.serialize.TypeSerializer;
import info.pixelmon.repack.org.spongepowered.util.CheckedFunction;
import info.pixelmon.repack.org.spongepowered.util.NamingScheme;
import info.pixelmon.repack.org.spongepowered.util.NamingSchemes;
import io.leangen.geantyref.GenericTypeReflector;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

final class ObjectMapperFactoryImpl
implements ObjectMapper.Factory,
TypeSerializer<Object> {
    private static final int MAXIMUM_MAPPERS_SIZE = 64;
    private final Map<Type, ObjectMapper<?>> mappers = new LinkedHashMap<Type, ObjectMapper<?>>(){
        private static final long serialVersionUID = 1838651306004330732L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<Type, ObjectMapper<?>> eldest) {
            return this.size() > 64;
        }
    };
    private final List<NodeResolver.Factory> resolverFactories;
    private final List<FieldDiscoverer<?>> fieldDiscoverers;
    private final Map<Class<? extends Annotation>, List<Definition<?, ?, ? extends Constraint.Factory<?, ?>>>> constraints;
    private final Map<Class<? extends Annotation>, List<Definition<?, ?, ? extends Processor.Factory<?, ?>>>> processors;
    private final List<PostProcessor.Factory> postProcessors;
    public static final String CLASS_KEY = "__class__";
    static final ObjectMapper.Factory INSTANCE = ObjectMapperFactoryImpl.defaultBuilder().build();

    ObjectMapperFactoryImpl(Builder builder) {
        this.resolverFactories = new ArrayList<NodeResolver.Factory>(builder.resolvers);
        Collections.reverse(this.resolverFactories);
        @Nullable NamingScheme scheme = builder.namingScheme;
        if (scheme != null) {
            this.resolverFactories.add((name, element) -> {
                String key = scheme.coerce(name);
                return node -> node.node(key);
            });
        }
        this.fieldDiscoverers = new ArrayList(builder.discoverer);
        Collections.reverse(this.fieldDiscoverers);
        this.constraints = new HashMap();
        for (Definition def : builder.constraints) {
            this.constraints.computeIfAbsent(def.annotation(), k -> new ArrayList()).add(def);
        }
        this.constraints.values().forEach(Collections::reverse);
        this.processors = new HashMap();
        for (Definition def : builder.processors) {
            this.processors.computeIfAbsent(def.annotation(), k -> new ArrayList()).add(def);
        }
        this.processors.values().forEach(Collections::reverse);
        this.postProcessors = new ArrayList<PostProcessor.Factory>(builder.postProcessors);
        Collections.reverse(this.postProcessors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectMapper<?> get(Type type) throws SerializationException {
        Objects.requireNonNull(type, "type");
        if (GenericTypeReflector.isMissingTypeParameters(type)) {
            throw new SerializationException(type, "Raw types are not supported!");
        }
        Map<Type, ObjectMapper<?>> map = this.mappers;
        synchronized (map) {
            return ObjectMapperFactoryImpl.computeFromMap(this.mappers, type, this::computeMapper);
        }
    }

    @Override
    public TypeSerializer<Object> asTypeSerializer() {
        return this;
    }

    private ObjectMapper<?> computeMapper(Type type) throws SerializationException {
        for (FieldDiscoverer<?> discoverer : this.fieldDiscoverers) {
            @Nullable ObjectMapper<V> result = this.newMapper(type, discoverer);
            if (result == null) continue;
            return result;
        }
        throw new SerializationException(type, "Could not find factory for type " + type);
    }

    private <I, V> @Nullable ObjectMapper<V> newMapper(Type type, FieldDiscoverer<I> discoverer) throws SerializationException {
        ArrayList fields = new ArrayList();
        @Nullable FieldDiscoverer.InstanceFactory<I> candidate = discoverer.discover(GenericTypeReflector.annotate(type), (name, fieldType, container, deserializer, serializer) -> this.makeData(fields, name, fieldType, container, deserializer, serializer));
        if (candidate == null) {
            return null;
        }
        List<PostProcessor> postProcessors = this.computePostProcessors(type);
        if (candidate instanceof FieldDiscoverer.MutableInstanceFactory) {
            return new ObjectMapperImpl.Mutable(type, fields, (FieldDiscoverer.MutableInstanceFactory)candidate, postProcessors);
        }
        return new ObjectMapperImpl(type, fields, candidate, postProcessors);
    }

    private List<PostProcessor> computePostProcessors(Type type) throws SerializationException {
        if (this.postProcessors.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<PostProcessor> createdProcessors = new ArrayList<PostProcessor>();
        for (PostProcessor.Factory factory : this.postProcessors) {
            @Nullable PostProcessor candidate = factory.createProcessor(type);
            if (candidate == null) continue;
            createdProcessors.add(candidate);
        }
        return Collections.unmodifiableList(createdProcessors);
    }

    private <I, O> void makeData(List<FieldData<I, O>> fields, String name, AnnotatedType type, AnnotatedElement container, FieldData.Deserializer<I> deserializer, CheckedFunction<O, @Nullable Object, Exception> serializer) {
        NodeResolver resolver = null;
        for (NodeResolver.Factory factory : this.resolverFactories) {
            @Nullable NodeResolver next = factory.make(name, container);
            if (next == null) continue;
            if (next == NodeResolver.SKIP_FIELD) break;
            resolver = next;
            break;
        }
        if (resolver == null) {
            return;
        }
        Type normalizedType = GenericTypeReflector.box(type.getType());
        ArrayList constraints = new ArrayList();
        ArrayList processors = new ArrayList();
        for (Annotation annotation : container.getAnnotations()) {
            List<Definition<?, ?, Processor.Factory<?, ?>>> processorDefs;
            List<Definition<?, ?, Constraint.Factory<?, ?>>> definitions = this.constraints.get(annotation.annotationType());
            if (definitions != null) {
                for (Definition<?, ?, Constraint.Factory<?, ?>> def : definitions) {
                    if (!GenericTypeReflector.isSuperType(def.type(), normalizedType)) continue;
                    constraints.add(def.factory().make(annotation, type.getType()));
                }
            }
            if ((processorDefs = this.processors.get(annotation.annotationType())) == null) continue;
            for (Definition<?, ?, Processor.Factory<?, ?>> processorDef : processorDefs) {
                if (!GenericTypeReflector.isSuperType(processorDef.type(), normalizedType)) continue;
                processors.add(processorDef.factory().make(annotation, type.getType()));
            }
        }
        AnnotatedType combinedType = GenericTypeReflector.updateAnnotations(type, container.getAnnotations());
        fields.add(FieldData.of(name, combinedType, constraints, processors, deserializer, serializer, resolver));
    }

    @Override
    public Object deserialize(Type type, ConfigurationNode node) throws SerializationException {
        Type clazz = this.instantiableType(node, type, node.node(CLASS_KEY).getString());
        return this.get(clazz).load(node);
    }

    private Type instantiableType(ConfigurationNode node, Type type, @Nullable String configuredName) throws SerializationException {
        Class<?> retClass;
        Class<?> rawType = GenericTypeReflector.erase(type);
        if (rawType.isInterface() || Modifier.isAbstract(rawType.getModifiers())) {
            if (configuredName == null) {
                throw new SerializationException(node, type, "No available configured type for instances of this type");
            }
            try {
                retClass = Class.forName(configuredName);
            }
            catch (ClassNotFoundException e) {
                throw new SerializationException(node, type, "Unknown class of object " + configuredName, (Throwable)e);
            }
            if (!GenericTypeReflector.isSuperType(type, retClass)) {
                throw new SerializationException(node, type, "Configured type " + configuredName + " does not extend " + rawType.getCanonicalName());
            }
        } else {
            retClass = type;
        }
        return retClass;
    }

    @Override
    public void serialize(Type type, @Nullable Object obj, ConfigurationNode node) throws SerializationException {
        ObjectMapper<?> mapper;
        if (obj == null) {
            ConfigurationNode clazz = node.node(CLASS_KEY);
            node.set(null);
            if (!clazz.virtual()) {
                node.node(CLASS_KEY).set(clazz);
            }
            return;
        }
        Class<?> rawType = GenericTypeReflector.erase(type);
        if (rawType.isInterface() || Modifier.isAbstract(rawType.getModifiers())) {
            node.node(CLASS_KEY).set(obj.getClass().getName());
            mapper = this.get(obj.getClass());
        } else {
            mapper = this.get(type);
        }
        mapper.save(obj, node);
    }

    @Override
    public @Nullable Object emptyValue(Type specificType, ConfigurationOptions options) {
        try {
            return this.get(specificType).load(BasicConfigurationNode.root(options.shouldCopyDefaults(false)));
        }
        catch (SerializationException ex) {
            return null;
        }
    }

    private static <K, V, E extends Exception> V computeFromMap(Map<K, V> map, K key, CheckedFunction<K, V, E> creator) throws E {
        try {
            return (V)map.computeIfAbsent(key, k -> {
                try {
                    return creator.apply(k);
                }
                catch (Exception e) {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new StacklessWrapper(e);
                }
            });
        }
        catch (StacklessWrapper ex) {
            throw (Exception)ex.getCause();
        }
    }

    static ObjectMapper.Factory.Builder defaultBuilder() {
        return new Builder().defaultNamingScheme(NamingSchemes.LOWER_CASE_DASHED).addNodeResolver(NodeResolver.nodeKey()).addNodeResolver(NodeResolver.keyFromSetting()).addNodeResolver(NodeResolver.nodeFromParent()).addProcessor(Comment.class, Processor.comments()).addConstraint(Matches.class, String.class, Constraint.pattern()).addConstraint(Required.class, Constraint.required()).addPostProcessor(PostProcessor.methodsAnnotatedPostProcess()).addDiscoverer(FieldDiscoverer.emptyConstructorObject()).addDiscoverer(FieldDiscoverer.record());
    }

    static class Builder
    implements ObjectMapper.Factory.Builder {
        private @Nullable NamingScheme namingScheme;
        private final List<NodeResolver.Factory> resolvers = new ArrayList<NodeResolver.Factory>();
        private final List<FieldDiscoverer<?>> discoverer = new ArrayList();
        private final List<Definition<?, ?, ? extends Constraint.Factory<?, ?>>> constraints = new ArrayList();
        private final List<Definition<?, ?, ? extends Processor.Factory<?, ?>>> processors = new ArrayList();
        private final List<PostProcessor.Factory> postProcessors = new ArrayList<PostProcessor.Factory>();

        Builder() {
        }

        @Override
        public ObjectMapper.Factory.Builder defaultNamingScheme(NamingScheme scheme) {
            this.namingScheme = scheme;
            return this;
        }

        @Override
        public Builder addNodeResolver(NodeResolver.Factory resolver) {
            this.resolvers.add(resolver);
            return this;
        }

        @Override
        public Builder addDiscoverer(FieldDiscoverer<?> discoverer) {
            this.discoverer.add(discoverer);
            return this;
        }

        @Override
        public <A extends Annotation, T> Builder addProcessor(Class<A> definition, Class<T> valueType, Processor.Factory<A, T> factory) {
            this.processors.add(Definition.of(definition, valueType, factory));
            return this;
        }

        @Override
        public <A extends Annotation, T> Builder addConstraint(Class<A> definition, Class<T> valueType, Constraint.Factory<A, T> factory) {
            this.constraints.add(Definition.of(definition, valueType, factory));
            return this;
        }

        @Override
        public Builder addPostProcessor(PostProcessor.Factory factory) {
            this.postProcessors.add(Objects.requireNonNull(factory, "factory"));
            return this;
        }

        @Override
        public ObjectMapper.Factory build() {
            return new ObjectMapperFactoryImpl(this);
        }
    }

    private static class StacklessWrapper
    extends RuntimeException {
        private static final long serialVersionUID = 1759625646560465255L;

        StacklessWrapper(Throwable cause) {
            super(cause);
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }
}

