/*
 * Decompiled with CFR 0.152.
 */
package info.pixelmon.repack.org.spongepowered;

import info.pixelmon.repack.org.spongepowered.AbstractConfigurationNode;
import info.pixelmon.repack.org.spongepowered.ConfigValue;
import info.pixelmon.repack.org.spongepowered.ScopedConfigurationNode;
import info.pixelmon.repack.org.spongepowered.serialize.Scalars;
import info.pixelmon.repack.org.spongepowered.util.UnmodifiableCollections;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.checkerframework.checker.nullness.qual.Nullable;

final class ListConfigValue<N extends ScopedConfigurationNode<N>, A extends AbstractConfigurationNode<N, A>>
implements ConfigValue<N, A> {
    static final AtomicReferenceFieldUpdater<ListConfigValue, List> VALUES_HANDLE = AtomicReferenceFieldUpdater.newUpdater(ListConfigValue.class, List.class, "values");
    static final Object UNALLOCATED_IDX = new Object(){

        public String toString() {
            return "<list unallocated>";
        }
    };
    private final A holder;
    volatile List<A> values = new ArrayList<A>();

    static boolean likelyListKey(@Nullable Object key) {
        return key instanceof Integer && (Integer)key == 0 || key == UNALLOCATED_IDX;
    }

    ListConfigValue(A holder) {
        this.holder = holder;
    }

    ListConfigValue(A holder, @Nullable Object startValue) {
        this.holder = holder;
        if (startValue != null) {
            Object child = ((AbstractConfigurationNode)holder).createNode(0);
            ((AbstractConfigurationNode)child).attached = true;
            ((AbstractConfigurationNode)child).raw(startValue);
            this.values.add(child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get() {
        List<A> values;
        List<A> list = values = this.values;
        synchronized (list) {
            ArrayList<Object> ret = new ArrayList<Object>(values.size());
            for (AbstractConfigurationNode obj : values) {
                ret.add(obj.raw());
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<N> unwrapped() {
        List<A> orig;
        List<A> list = orig = this.values;
        synchronized (list) {
            ArrayList ret = new ArrayList(orig.size());
            for (AbstractConfigurationNode element : orig) {
                ret.add(element.self());
            }
            return Collections.unmodifiableList(ret);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public void set(@Nullable Object value) {
        if (!(value instanceof Collection)) {
            value = Collections.singleton(value);
        }
        @Nullable Collection valueAsList = value;
        ArrayList newValue = new ArrayList(valueAsList.size());
        int count = 0;
        for (Object o : valueAsList) {
            if (o == null) continue;
            Object child = ((AbstractConfigurationNode)this.holder).createNode(count);
            newValue.add(count, child);
            ((AbstractConfigurationNode)child).attached = true;
            ((AbstractConfigurationNode)child).raw(o);
            ++count;
        }
        this.detachNodes(VALUES_HANDLE.getAndSet(this, newValue));
    }

    @Override
    public @Nullable A putChild(Object key, @Nullable A value) {
        return this.putChildInternal(key, value, false);
    }

    @Override
    public @Nullable A putChildIfAbsent(Object key, @Nullable A value) {
        return this.putChildInternal(key, value, true);
    }

    private @Nullable A putChildInternal(Object index, @Nullable A value, boolean onlyIfAbsent) {
        if (index == UNALLOCATED_IDX) {
            if (value != null) {
                List<A> values;
                do {
                    values = this.values;
                    values.add(value);
                    ((AbstractConfigurationNode)value).key = values.lastIndexOf(value);
                } while (!VALUES_HANDLE.compareAndSet(this, values, values));
            }
            return null;
        }
        return this.putChildInternal((Integer)index, value, onlyIfAbsent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private @Nullable A putChildInternal(int index, @Nullable A value, boolean onlyIfAbsent) {
        List<A> values;
        AbstractConfigurationNode ret = null;
        do {
            List<A> list = values = this.values;
            synchronized (list) {
                if (value == null) {
                    if (index >= 0 && index < values.size()) {
                        ret = (AbstractConfigurationNode)values.remove(index);
                        for (int i = index; i < values.size(); ++i) {
                            ((AbstractConfigurationNode)values.get((int)i)).key = index;
                        }
                    }
                } else if (index >= 0 && index < values.size()) {
                    if (onlyIfAbsent) {
                        return (A)((AbstractConfigurationNode)values.get(index));
                    }
                    ret = (AbstractConfigurationNode)values.set(index, value);
                } else {
                    values.add(index, value);
                }
            }
        } while (!VALUES_HANDLE.compareAndSet(this, values, values));
        return (A)ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable A child(@Nullable Object key) {
        List<A> values;
        @Nullable Integer value = Scalars.INTEGER.tryDeserialize(key);
        if (value == null || value < 0) {
            return null;
        }
        List<A> list = values = this.values;
        synchronized (list) {
            if (value >= values.size()) {
                return null;
            }
            return (A)((AbstractConfigurationNode)values.get(value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<A> iterateChildren() {
        List<A> values;
        List<A> list = values = this.values;
        synchronized (list) {
            return UnmodifiableCollections.copyOf(values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListConfigValue<N, A> copy(A holder) {
        ArrayList<A> copyValues;
        List<A> values;
        ListConfigValue<N, A> copy = new ListConfigValue<N, A>(holder);
        List<A> list = values = this.values;
        synchronized (list) {
            copyValues = new ArrayList<A>(values.size());
            for (AbstractConfigurationNode obj : values) {
                copyValues.add(obj.copy(holder));
            }
        }
        copy.values = copyValues;
        return copy;
    }

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void detachNodes(List<? extends AbstractConfigurationNode<?, ?>> children) {
        List<AbstractConfigurationNode<?, ?>> list = children;
        synchronized (list) {
            for (AbstractConfigurationNode<?, ?> node : children) {
                node.attached = false;
                if (!Objects.equals(node.parent(), this.holder)) continue;
                node.clear();
            }
        }
    }

    @Override
    public void clear() {
        List oldValues = VALUES_HANDLE.getAndSet(this, new ArrayList());
        this.detachNodes(oldValues);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ListConfigValue)) {
            return false;
        }
        ListConfigValue that = (ListConfigValue)other;
        return Objects.equals(this.values, that.values);
    }

    public int hashCode() {
        return this.values.hashCode();
    }

    public String toString() {
        return "ListConfigValue{values=" + this.values.toString() + '}';
    }
}

