/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.tileentity;

import com.pixelmonmod.tcg.api.config.TCGConfigProxy;
import com.pixelmonmod.tcg.init.registry.TileEntityRegistration;
import com.pixelmonmod.tcg.listener.TCGServerEventListeners;
import java.awt.Color;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class EssenceJarTileEntity
extends BlockEntity {
    private int essence = 0;
    private double fillPercent = 0.0;
    private Color color = new Color(DyeColor.CYAN.m_41071_());
    private MutableComponent colorName = Component.m_237115_((String)("color.minecraft." + DyeColor.CYAN.m_41065_()));

    public EssenceJarTileEntity(BlockPos blockPos, BlockState state) {
        super((BlockEntityType)TileEntityRegistration.ESSENCE_JAR.get(), blockPos, state);
    }

    public EssenceJarTileEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState state) {
        super(blockEntityType, blockPos, state);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.save0(tag);
    }

    public void save0(CompoundTag tag) {
        tag.m_128405_("EssenceJarCount", this.essence);
        tag.m_128347_("EssenceJarPercent", this.recalculateFillPercent());
        tag.m_128405_("EssenceJarColorRed", this.color.getRed());
        tag.m_128405_("EssenceJarColorGreen", this.color.getGreen());
        tag.m_128405_("EssenceJarColorBlue", this.color.getBlue());
        tag.m_128359_("EssenceJarColorName", Component.Serializer.m_130703_((Component)this.colorName));
    }

    public void m_142466_(CompoundTag tag) {
        this.load0(tag);
        super.m_142466_(tag);
    }

    private boolean load0(CompoundTag tag) {
        this.essence = tag.m_128451_("EssenceJarCount");
        this.fillPercent = tag.m_128459_("EssenceJarPercent");
        if (tag.m_128441_("EssenceJarColorRed")) {
            this.color = new Color(tag.m_128451_("EssenceJarColorRed"), tag.m_128451_("EssenceJarColorGreen"), tag.m_128451_("EssenceJarColorBlue"));
            this.colorName = Component.Serializer.m_130701_((String)tag.m_128461_("EssenceJarColorName"));
            return true;
        }
        return false;
    }

    public double recalculateFillPercent() {
        this.fillPercent = Math.min(1.0, (double)this.essence / (double)TCGConfigProxy.getConfig().getEssenceToFillJar());
        return Mth.m_14008_((double)this.fillPercent, (double)0.0, (double)1.0);
    }

    public void m_6596_() {
        this.recalculateFillPercent();
        super.m_6596_();
        if (this.f_58857_ == null || this.m_58900_() == null) {
            return;
        }
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 11);
        this.f_58857_.m_5518_().m_7174_(this.f_58858_);
    }

    public boolean setValuesFromItem(ItemStack stack) {
        return this.load0(stack.m_41698_("BlockEntityTag"));
    }

    public void applyValuesToItem(ItemStack stack) {
        this.save0(stack.m_41698_("BlockEntityTag"));
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        this.m_183515_(nbt);
        return nbt;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection network, ClientboundBlockEntityDataPacket packet) {
        this.m_142466_(packet.m_131708_());
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 11);
        this.f_58857_.m_5518_().m_7174_(this.f_58858_);
    }

    public Color getColor() {
        return this.color;
    }

    public int getEssence() {
        return this.essence;
    }

    public int addEssence(int essence) {
        int current = this.essence + essence;
        int target = TCGConfigProxy.getConfig().getEssenceToFillJar();
        this.essence = Math.min(current, target);
        this.m_6596_();
        if (this.f_58857_ instanceof ServerLevel) {
            TCGServerEventListeners.playEssenceJarEffect(this.essence, essence, current, target, (ServerLevel)this.f_58857_, this.m_58899_(), this.getColor());
        }
        return Math.max(0, current - target);
    }

    public void setEssence(int essence) {
        this.essence = essence;
        this.m_6596_();
    }

    public double getFillPercent() {
        return this.recalculateFillPercent();
    }

    public double getFillPercentDirect() {
        return Mth.m_14008_((double)this.fillPercent, (double)0.0, (double)1.0);
    }

    public boolean isFilled() {
        return this.fillPercent >= 1.0;
    }

    public EssenceJarTileEntity setColor(DyeColor dyeColor) {
        if (dyeColor != null) {
            return this.setColor(new Color(dyeColor.m_41071_())).setColorName(dyeColor);
        }
        return this;
    }

    public EssenceJarTileEntity setColor(Color color) {
        this.color = color;
        return this;
    }

    public EssenceJarTileEntity setColorName(DyeColor dyeColor) {
        return this.setColorName(Component.m_237115_((String)("color.minecraft." + dyeColor.m_41065_())));
    }

    public EssenceJarTileEntity setColorName(MutableComponent colorName) {
        this.colorName = colorName;
        return this;
    }

    public MutableComponent getColorName() {
        return this.colorName;
    }
}

