/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.tileentity;

import com.pixelmonmod.tcg.init.registry.TileEntityRegistration;
import com.pixelmonmod.tcg.tileentity.BattleOwnedTileEntityController;
import com.pixelmonmod.tcg.tileentity.OwnedTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class BattleSpectatorOwnedTileEntity
extends OwnedTileEntity {
    private static final String CONTROLLER_KEY = "Controller";
    private static final String X_KEY = "X";
    private static final String Y_KEY = "Y";
    private static final String Z_KEY = "Z";
    private static final String PLAYER_INDEX_KEY = "PlayerIndex";
    private BlockPos controllerPosition;
    private int playerIndex;

    public BattleSpectatorOwnedTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileEntityRegistration.BATTLE_SPECTATOR.get(), pos, state);
    }

    public BattleSpectatorOwnedTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        super.deserializeNBT(nbt);
        int x = 0;
        int y = 0;
        int z = 0;
        if (nbt.m_128441_(CONTROLLER_KEY)) {
            CompoundTag controllerNBT = nbt.m_128469_(CONTROLLER_KEY);
            if (controllerNBT.m_128441_(X_KEY)) {
                x = controllerNBT.m_128451_(X_KEY);
            }
            if (controllerNBT.m_128441_(Y_KEY)) {
                y = controllerNBT.m_128451_(Y_KEY);
            }
            if (controllerNBT.m_128441_(Z_KEY)) {
                z = controllerNBT.m_128451_(Z_KEY);
            }
        }
        this.controllerPosition = new BlockPos(x, y, z);
        if (nbt.m_128441_(PLAYER_INDEX_KEY)) {
            this.playerIndex = nbt.m_128451_(PLAYER_INDEX_KEY);
        }
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = super.serializeNBT();
        if (this.controllerPosition != null) {
            CompoundTag controllerNBT = new CompoundTag();
            controllerNBT.m_128405_(X_KEY, this.controllerPosition.m_123341_());
            controllerNBT.m_128405_(Y_KEY, this.controllerPosition.m_123342_());
            controllerNBT.m_128405_(Z_KEY, this.controllerPosition.m_123343_());
            nbt.m_128365_(CONTROLLER_KEY, (Tag)controllerNBT);
        }
        nbt.m_128405_(PLAYER_INDEX_KEY, this.playerIndex);
        return nbt;
    }

    public BattleOwnedTileEntityController getBattleController() {
        if (this.controllerPosition == null) {
            return null;
        }
        BlockEntity te = this.f_58857_.m_7702_(this.controllerPosition);
        if (te instanceof BattleOwnedTileEntityController) {
            return (BattleOwnedTileEntityController)te;
        }
        return null;
    }

    public BlockPos getControllerPosition() {
        return this.controllerPosition;
    }

    public void setControllerPosition(BlockPos controllerPosition) {
        this.controllerPosition = controllerPosition;
    }

    public int getPlayerIndex() {
        return this.playerIndex;
    }

    public void setPlayerIndex(int playerIndex) {
        this.playerIndex = playerIndex;
    }
}

