/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.tileentity;

import com.pixelmonmod.tcg.TCG;
import com.pixelmonmod.tcg.duel.state.PlayerServerState;
import com.pixelmonmod.tcg.tileentity.OwnedTileEntity;
import java.text.SimpleDateFormat;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.server.ServerLifecycleHooks;

public class BattleRuleOwnedTileEntity
extends OwnedTileEntity {
    private static final String DECK_SIZE_KEY = "DeckSize";
    private static final String PRIZE_COUNT_KEY = "PrizeCount";
    private static final String STARTING_COMMAND_KEY = "StartingCommand";
    private static final String ENDING_COMMAND_KEY = "EndingCommand";
    private static final String STARTING_MESSAGE_KEY = "StartingMessage";
    private static final String ENDING_MESSAGE_KEY = "EndingMessage";
    private static final String CUSTOM_NAME_KEY = "CustomName";
    private static final String TIME_LIMIT_KEY = "TimeLimit";
    private static final String ELO_MINIMUM_KEY = "EloMinimum";
    private static final String SHADOW_GAME_KEY = "ShadowGame";
    private static final SimpleDateFormat timestampFormat = new SimpleDateFormat("HH:mm:ss");
    protected int deckSize = 60;
    protected int prizeCount = 6;
    protected int eloMinimum = 0;
    protected String startingCommand = "";
    protected String endingCommand = "";
    protected String startingMessage = "";
    protected String endingMessage = "";
    private String customName = "@";
    protected int timeLimit = 0;
    protected boolean isShadowGame = false;

    public BattleRuleOwnedTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        super.deserializeNBT(nbt);
        if (nbt.m_128441_(DECK_SIZE_KEY)) {
            this.deckSize = nbt.m_128451_(DECK_SIZE_KEY);
        }
        if (nbt.m_128441_(PRIZE_COUNT_KEY)) {
            this.prizeCount = nbt.m_128451_(PRIZE_COUNT_KEY);
        }
        if (nbt.m_128441_(TIME_LIMIT_KEY)) {
            this.timeLimit = nbt.m_128451_(TIME_LIMIT_KEY);
        }
        if (nbt.m_128441_(ELO_MINIMUM_KEY)) {
            this.eloMinimum = nbt.m_128451_(ELO_MINIMUM_KEY);
        }
        if (nbt.m_128441_(STARTING_COMMAND_KEY)) {
            this.startingCommand = nbt.m_128461_(STARTING_COMMAND_KEY);
        }
        if (nbt.m_128441_(ENDING_COMMAND_KEY)) {
            this.endingCommand = nbt.m_128461_(ENDING_COMMAND_KEY);
        }
        if (nbt.m_128441_(STARTING_MESSAGE_KEY)) {
            this.startingMessage = nbt.m_128461_(STARTING_MESSAGE_KEY);
        }
        if (nbt.m_128441_(ENDING_MESSAGE_KEY)) {
            this.endingMessage = nbt.m_128461_(ENDING_MESSAGE_KEY);
        }
        if (nbt.m_128441_(CUSTOM_NAME_KEY)) {
            this.customName = nbt.m_128461_(CUSTOM_NAME_KEY);
        }
        if (nbt.m_128441_(SHADOW_GAME_KEY)) {
            this.isShadowGame = nbt.m_128471_(SHADOW_GAME_KEY);
        }
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = super.serializeNBT();
        nbt.m_128405_(DECK_SIZE_KEY, this.deckSize);
        nbt.m_128405_(PRIZE_COUNT_KEY, this.prizeCount);
        nbt.m_128405_(TIME_LIMIT_KEY, this.timeLimit);
        nbt.m_128405_(ELO_MINIMUM_KEY, this.eloMinimum);
        nbt.m_128359_(STARTING_COMMAND_KEY, this.startingCommand);
        nbt.m_128359_(ENDING_COMMAND_KEY, this.endingCommand);
        nbt.m_128359_(STARTING_MESSAGE_KEY, this.startingMessage);
        nbt.m_128359_(ENDING_MESSAGE_KEY, this.endingMessage);
        nbt.m_128359_(CUSTOM_NAME_KEY, this.customName);
        nbt.m_128379_(SHADOW_GAME_KEY, this.isShadowGame);
        return nbt;
    }

    public int trigger(Level level, String command, String winnerName, String loserName) {
        if (level.f_46443_) {
            return 0;
        }
        MinecraftServer minecraftServer = ServerLifecycleHooks.getCurrentServer();
        TCG.LOGGER.info("Try to trigger \"" + command + "\"");
        if (!command.isEmpty()) {
            String formattedCommand = this.formatCommand(command, winnerName, loserName);
            minecraftServer.m_129892_().m_230957_(minecraftServer.m_129893_(), formattedCommand);
        }
        return 0;
    }

    public String formatCommand(String command, String winnerName, String loserName) {
        return command;
    }

    public int getDeckSize() {
        return this.deckSize;
    }

    public void setDeckSize(int deckSize) {
        this.deckSize = deckSize;
    }

    public int getTimeLimit() {
        return this.timeLimit;
    }

    public int getPrizeCount() {
        return this.prizeCount;
    }

    public void setPrizeCount(int prizeCount) {
        this.prizeCount = prizeCount;
    }

    public int getEloMinimum() {
        return this.eloMinimum;
    }

    public void setEloMinimum(int eloMinimum) {
        this.eloMinimum = eloMinimum;
    }

    public String getStartingCommand() {
        return this.startingCommand;
    }

    public void setStartingCommand(String startingCommand) {
        this.startingCommand = startingCommand;
    }

    public String getEndingCommand() {
        return this.endingCommand;
    }

    public void setEndingCommand(String endingCommand) {
        this.endingCommand = endingCommand;
    }

    public String getStartingMessage() {
        return this.startingMessage;
    }

    public void setStartingMessage(String startingMessage) {
        this.startingMessage = startingMessage;
    }

    public String getEndingMessage() {
        return this.endingMessage;
    }

    public void setEndingMessage(String endingMessage) {
        this.endingMessage = endingMessage;
    }

    public void setTimeLimit(int timeLimit) {
        this.timeLimit = timeLimit;
    }

    public String getName() {
        return "BattleBox";
    }

    @Nullable
    public MinecraftServer getServer() {
        return null;
    }

    public void endGame(PlayerServerState winner, PlayerServerState loser, boolean tiedGame) {
    }

    public boolean isShadowGame() {
        return this.isShadowGame;
    }

    public void setShadowGame(boolean b) {
        this.isShadowGame = b;
    }

    public void toggleShadowGame() {
        this.isShadowGame = !this.isShadowGame;
    }
}

