/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.network.sync;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.tcg.api.accessors.ThemeDecks;
import com.pixelmonmod.tcg.api.card.ThemeDeck;
import com.pixelmonmod.tcg.api.util.helper.NetworkHelper;
import com.pixelmonmod.tcg.network.data.AbstractTCGPacket;
import com.pixelmonmod.tcg.network.data.PacketDirection;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class SyncThemeDecksPacket
extends AbstractTCGPacket {
    private List<ThemeDeck> themeDecks;

    public SyncThemeDecksPacket() {
        super(PacketDirection.PLAY_CLIENT, true);
    }

    public SyncThemeDecksPacket(List<ThemeDeck> themeDecks) {
        this();
        this.themeDecks = themeDecks;
    }

    public static void sync(ServerPlayer player) {
        List<ThemeDeck> themeDecks = ThemeDecks.getAll();
        int groups = Math.max(1, themeDecks.size() / 10);
        int size = themeDecks.size() / groups;
        for (int group = 0; group < groups; ++group) {
            ArrayList sublist = Lists.newArrayList();
            if (group + 1 == groups) {
                for (i = size * group; i < themeDecks.size(); ++i) {
                    sublist.add(themeDecks.get(i));
                }
            } else {
                for (i = size * group; i < size * (group + 1); ++i) {
                    sublist.add(themeDecks.get(i));
                }
            }
            NetworkHelper.sendPacket(player, new SyncThemeDecksPacket(sublist));
        }
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        this.themeDecks = Lists.newArrayList();
        int count = buffer.readInt();
        for (int i = 0; i < count; ++i) {
            String json = buffer.m_130277_() + buffer.m_130277_();
            ThemeDecks.register((ThemeDeck)ThemeDecks.GSON.fromJson(json, ThemeDeck.class));
        }
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.themeDecks.size());
        for (ThemeDeck themeDeck : this.themeDecks) {
            int length = themeDeck.getJson().length() / 2;
            String firstHalf = themeDeck.getJson().substring(0, length);
            String secondHalf = themeDeck.getJson().substring(length);
            buffer.m_130070_(firstHalf);
            buffer.m_130070_(secondHalf);
        }
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
    }
}

