/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.network.packets.battles;

import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.tcg.api.card.ImmutableCard;
import com.pixelmonmod.tcg.duel.state.PlayerServerState;
import com.pixelmonmod.tcg.network.ByteBufTCG;
import com.pixelmonmod.tcg.network.data.AbstractTCGPacket;
import com.pixelmonmod.tcg.network.data.PacketDirection;
import com.pixelmonmod.tcg.network.packets.enums.BoardLocation;
import com.pixelmonmod.tcg.tileentity.BattleOwnedTileEntityController;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class UpdateServerCardRecordPacket
extends AbstractTCGPacket {
    private BlockPos blockPos;
    private BoardLocation location;
    private int locationSubIndex;
    private ImmutableCard card;
    private int handIndex;

    public UpdateServerCardRecordPacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public UpdateServerCardRecordPacket(BlockPos blockPos, BoardLocation location, int locationSubIndex, ImmutableCard card, int handIndex) {
        this();
        this.blockPos = blockPos;
        this.location = location;
        this.locationSubIndex = locationSubIndex;
        this.card = card;
        this.handIndex = handIndex;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.blockPos);
        buffer.writeInt(this.location.ordinal());
        buffer.writeInt(this.locationSubIndex);
        ByteBufTCG.writeCard(buffer, this.card);
        buffer.writeInt(this.handIndex);
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        this.blockPos = buffer.m_130135_();
        this.location = BoardLocation.values()[buffer.readInt()];
        this.locationSubIndex = buffer.readInt();
        this.card = ByteBufTCG.readCard(buffer);
        this.handIndex = buffer.readInt();
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        ServerPlayer e = context.getSender();
        ServerLevel w = e.m_284548_();
        BattleOwnedTileEntityController b = (BattleOwnedTileEntityController)w.m_7702_(this.blockPos);
        PlayerServerState player = null;
        for (PlayerServerState p : b.getGameServer().getPlayers()) {
            if (p == null || p.getEntityPlayer() != e) continue;
            player = p;
        }
        if (player == null) {
            return;
        }
        switch (this.location) {
            case Active: {
                b.playCardFromHandToActive(player, this.handIndex, this.card);
                return;
            }
            case Bench: {
                b.playPokemonCardToBench(player, this.handIndex, this.card, this.locationSubIndex);
                return;
            }
            case Trainer: {
                b.playTrainerCard(player, this.handIndex, this.card);
                return;
            }
            case Stadium: {
                b.playStadiumCard(player, this.handIndex, this.card);
                return;
            }
        }
    }
}

