/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.network.packets.battles;

import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.tcg.client.gui.duel.TCGScreen;
import com.pixelmonmod.tcg.duel.state.TrainerCardState;
import com.pixelmonmod.tcg.network.ByteBufTCG;
import com.pixelmonmod.tcg.network.data.AbstractTCGPacket;
import com.pixelmonmod.tcg.network.data.PacketDirection;
import com.pixelmonmod.tcg.network.packets.enums.BoardLocation;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class TrainerPlayedPacket
extends AbstractTCGPacket {
    private String playerName;
    private TrainerCardState trainer;

    public TrainerPlayedPacket() {
        super(PacketDirection.PLAY_CLIENT);
    }

    public TrainerPlayedPacket(String playerName, TrainerCardState trainer) {
        this();
        this.playerName = playerName;
        this.trainer = trainer;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.playerName);
        ByteBufTCG.writeCard(buffer, this.trainer.getData());
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        this.playerName = buffer.m_130277_();
        this.trainer = new TrainerCardState(ByteBufTCG.readCard(buffer));
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ != null && mc.f_91080_ instanceof TCGScreen) {
            TCGScreen gui = (TCGScreen)mc.f_91080_;
            gui.getInspectingCard().set(this.trainer, false, BoardLocation.Trainer, 0, true, String.format("%s just played", this.playerName));
        }
    }
}

