/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.network.packets.battles;

import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.tcg.api.config.TCGConfigProxy;
import com.pixelmonmod.tcg.client.gui.duel.TCGScreen;
import com.pixelmonmod.tcg.network.ByteBufTCG;
import com.pixelmonmod.tcg.network.data.AbstractTCGPacket;
import com.pixelmonmod.tcg.network.data.PacketDirection;
import com.pixelmonmod.tcg.tileentity.BattleOwnedTileEntityController;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class TCGGuiClientPacket
extends AbstractTCGPacket {
    private int playerIndex;
    private BlockPos blockPos;
    private boolean isSpectating;

    public TCGGuiClientPacket() {
        super(PacketDirection.PLAY_CLIENT);
    }

    public TCGGuiClientPacket(BlockPos blockPos, int playerIndex, boolean isSpectating) {
        this();
        this.blockPos = blockPos;
        this.playerIndex = playerIndex;
        this.isSpectating = isSpectating;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        ByteBufTCG.writeBlockPos(buffer, this.blockPos);
        buffer.writeInt(this.playerIndex);
        buffer.writeBoolean(this.isSpectating);
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        this.blockPos = ByteBufTCG.readBlockPos(buffer);
        this.playerIndex = buffer.readInt();
        this.isSpectating = buffer.readBoolean();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void handlePacket(CustomPayloadEvent.Context context) {
        ClientLevel w;
        BattleOwnedTileEntityController b;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ != null && (b = (BattleOwnedTileEntityController)(w = mc.f_91073_).m_7702_(this.blockPos)) != null && !(mc.f_91080_ instanceof TCGScreen)) {
            TCGConfigProxy.getConfig().setSavedUIScale((Integer)Minecraft.m_91087_().f_91066_.m_231928_().m_231551_());
            Minecraft.m_91087_().f_91066_.m_231928_().m_231514_((Object)4);
            TCGScreen gui = new TCGScreen(b, this.playerIndex, this.isSpectating);
            b.setGui(gui);
            context.enqueueWork(() -> mc.m_91152_((Screen)gui));
        }
    }
}

