/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.network.packets.battles;

import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.tcg.duel.state.GamePhase;
import com.pixelmonmod.tcg.duel.state.GameServerState;
import com.pixelmonmod.tcg.duel.state.PlayerServerState;
import com.pixelmonmod.tcg.network.ByteBufTCG;
import com.pixelmonmod.tcg.network.data.AbstractTCGPacket;
import com.pixelmonmod.tcg.network.data.PacketDirection;
import com.pixelmonmod.tcg.tileentity.BattleOwnedTileEntityController;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class SwitchPacket
extends AbstractTCGPacket {
    private BlockPos blockPos;
    private int switchingIn;

    public SwitchPacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public SwitchPacket(BlockPos blockPos, int switchingIn) {
        this();
        this.blockPos = blockPos;
        this.switchingIn = switchingIn;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        ByteBufTCG.writeBlockPos(buffer, this.blockPos);
        buffer.writeInt(this.switchingIn);
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        this.blockPos = ByteBufTCG.readBlockPos(buffer);
        this.switchingIn = buffer.readInt();
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        ServerPlayer e = context.getSender();
        ServerLevel w = e.m_284548_();
        BattleOwnedTileEntityController b = (BattleOwnedTileEntityController)w.m_7702_(this.blockPos);
        GameServerState server = b.getGameServer();
        PlayerServerState player = server.getPlayer(e);
        if (b.getGameServer().getGamePhase().after(GamePhase.PreMatch) && player != null && player.getEntityPlayer() == e) {
            b.requestSwitch(player, this.switchingIn);
        }
    }
}

