/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.network.packets.battles;

import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.tcg.api.accessors.Cards;
import com.pixelmonmod.tcg.api.card.ImmutableCard;
import com.pixelmonmod.tcg.client.gui.duel.TCGScreen;
import com.pixelmonmod.tcg.duel.state.CommonCardState;
import com.pixelmonmod.tcg.network.data.AbstractTCGPacket;
import com.pixelmonmod.tcg.network.data.PacketDirection;
import com.pixelmonmod.tcg.network.packets.enums.BoardLocation;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class ShowOpponentCardPacket
extends AbstractTCGPacket {
    private String message;
    private String playerName;
    private ImmutableCard card;

    public ShowOpponentCardPacket() {
        super(PacketDirection.PLAY_CLIENT);
    }

    public ShowOpponentCardPacket(String message, String playerName, ImmutableCard card) {
        this();
        this.message = message;
        this.playerName = playerName;
        this.card = card;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.message);
        buffer.m_130070_(this.playerName);
        buffer.m_130070_(this.card.getCode());
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        this.message = buffer.m_130277_();
        this.playerName = buffer.m_130277_();
        this.card = Cards.fromCode(buffer.m_130277_());
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ != null && mc.f_91080_ instanceof TCGScreen) {
            TCGScreen gui = (TCGScreen)mc.f_91080_;
            gui.getInspectingCard().set(new CommonCardState(this.card), false, BoardLocation.Trainer, 0, true, String.format(this.message, this.playerName));
        }
    }
}

