/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.network.packets.battles;

import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.tcg.duel.state.GamePhase;
import com.pixelmonmod.tcg.duel.state.GameServerState;
import com.pixelmonmod.tcg.duel.state.PlayerClientOpponentState;
import com.pixelmonmod.tcg.duel.state.PlayerServerState;
import com.pixelmonmod.tcg.network.data.AbstractTCGPacket;
import com.pixelmonmod.tcg.network.data.PacketDirection;
import com.pixelmonmod.tcg.tileentity.BattleOwnedTileEntityController;
import com.pixelmonmod.tcg.tileentity.ServerOwnedTileEntityBattleController;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class RenderStateSyncPacket
extends AbstractTCGPacket {
    private BlockPos blockPos;
    private GamePhase gamePhase;
    private int currentTurn;
    private PlayerClientOpponentState[] players;
    private GameServerState server;
    private boolean isShadowGame;

    public RenderStateSyncPacket() {
        super(PacketDirection.PLAY_CLIENT);
    }

    public RenderStateSyncPacket(BlockPos blockPos, GameServerState server, Player entityPlayer, ServerOwnedTileEntityBattleController bc) {
        this();
        this.blockPos = blockPos;
        this.gamePhase = server.getGamePhase();
        this.currentTurn = server.getCurrentTurn();
        this.isShadowGame = bc.isShadowGame();
        this.players = new PlayerClientOpponentState[server.getPlayers().length];
        for (int i = 0; i < server.getPlayers().length; ++i) {
            PlayerServerState player = server.getPlayer(i);
            if (player == null) continue;
            this.players[i] = new PlayerClientOpponentState(player, server.getGamePhase(), server, player.getEntityPlayer() == entityPlayer);
        }
        this.server = server;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.blockPos);
        buffer.writeInt(this.gamePhase.ordinal());
        buffer.writeInt(this.currentTurn);
        buffer.writeBoolean(this.isShadowGame);
        buffer.writeInt(this.players.length);
        for (PlayerClientOpponentState player : this.players) {
            buffer.writeBoolean(player != null);
            if (player == null) continue;
            player.write(buffer);
        }
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        this.blockPos = buffer.m_130135_();
        this.gamePhase = GamePhase.values()[buffer.readInt()];
        this.currentTurn = buffer.readInt();
        this.isShadowGame = buffer.readBoolean();
        int size = buffer.readInt();
        this.players = new PlayerClientOpponentState[size];
        for (int i = 0; i < size; ++i) {
            if (!buffer.readBoolean()) continue;
            this.players[i] = new PlayerClientOpponentState(buffer, this.server);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void handlePacket(CustomPayloadEvent.Context context) {
        ClientLevel w;
        BattleOwnedTileEntityController b;
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer e = mc.f_91074_;
        if (mc.f_91073_ != null && (b = (BattleOwnedTileEntityController)(w = mc.f_91073_).m_7702_(this.blockPos)) != null) {
            b.setRenderClientSideValues(this.gamePhase, this.currentTurn, this.players);
            b.setShadowGame(this.isShadowGame);
        }
    }
}

