/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.network.packets.battles;

import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.tcg.network.data.AbstractTCGPacket;
import com.pixelmonmod.tcg.network.data.PacketDirection;
import com.pixelmonmod.tcg.tileentity.BattleOwnedTileEntityController;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class CustomGUIChoiceToServerPacket
extends AbstractTCGPacket {
    private BlockPos blockPos;
    private boolean isOpened;
    private int[] result;

    public CustomGUIChoiceToServerPacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public CustomGUIChoiceToServerPacket(BlockPos blockPos, boolean isOpened, int ... result) {
        this();
        this.blockPos = blockPos;
        this.isOpened = isOpened;
        this.result = result;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.blockPos);
        buffer.writeBoolean(this.isOpened);
        buffer.writeBoolean(this.result != null);
        if (this.result != null) {
            buffer.writeInt(this.result.length);
            for (int item : this.result) {
                buffer.writeInt(item);
            }
        }
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        this.blockPos = buffer.m_130135_();
        this.isOpened = buffer.readBoolean();
        if (buffer.readBoolean()) {
            this.result = new int[buffer.readInt()];
            for (int i = 0; i < this.result.length; ++i) {
                this.result[i] = buffer.readInt();
            }
        }
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        ServerPlayer e = context.getSender();
        ServerLevel w = e.m_284548_();
        BattleOwnedTileEntityController b = (BattleOwnedTileEntityController)w.m_7702_(this.blockPos);
        b.setCustomGUIResult((Player)e, this.isOpened, this.result);
    }
}

