/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.network.packets;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.tcg.TCG;
import com.pixelmonmod.tcg.api.accessors.CardSets;
import com.pixelmonmod.tcg.api.accessors.Cards;
import com.pixelmonmod.tcg.api.accessors.TCGItems;
import com.pixelmonmod.tcg.api.card.CardRarity;
import com.pixelmonmod.tcg.api.card.ImmutableCard;
import com.pixelmonmod.tcg.api.events.PackOpenEvent;
import com.pixelmonmod.tcg.item.PackItem;
import com.pixelmonmod.tcg.network.data.AbstractTCGPacket;
import com.pixelmonmod.tcg.network.data.PacketDirection;
import com.pixelmonmod.tcg.network.packets.OpenPackGuiPacket;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSource;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class OpenPackPacket
extends AbstractTCGPacket {
    private int id;

    public OpenPackPacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public OpenPackPacket(int id) {
        this();
        this.id = id;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.id);
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        this.id = buffer.readInt();
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        ServerPlayer player = context.getSender();
        ItemStack itemInHand = player.m_21120_(InteractionHand.MAIN_HAND);
        if (itemInHand == ItemStack.f_41583_) {
            return;
        }
        if (!(itemInHand.m_41720_() instanceof PackItem)) {
            return;
        }
        int setID = itemInHand.m_41783_().m_128451_("SetID");
        float weight = itemInHand.m_41783_().m_128457_("Weight");
        ImmutableCard[] c = new ImmutableCard[]{Cards.getRandomCardOfRarity(setID, CardRarity.COMMON, false), Cards.getRandomCardOfRarity(setID, CardRarity.COMMON, false), Cards.getRandomCardOfRarity(setID, CardRarity.COMMON, false), Cards.getRandomCardOfRarity(setID, CardRarity.COMMON, false), Cards.getRandomCardOfRarity(setID, CardRarity.COMMON, false), Cards.getRandomCardOfRarity(setID, CardRarity.COMMON, false), Cards.getRandomCardOfRarity(setID, CardRarity.UNCOMMON, false), Cards.getRandomCardOfRarity(setID, CardRarity.UNCOMMON, false), Cards.getRandomCardOfRarity(setID, CardRarity.UNCOMMON, false), Cards.getRareOrBetterCard(setID, weight, true), Cards.getRandomBasicEnergyCard()};
        PackOpenEvent.Pre preEvent = new PackOpenEvent.Pre(player, itemInHand, c);
        if (TCG.EVENT_BUS.post((Event)preEvent)) {
            return;
        }
        if (!player.m_7500_()) {
            itemInHand.m_41774_(1);
        }
        int dropped = 0;
        int givenCards = 0;
        for (int i = 0; i < preEvent.getCards().length; ++i) {
            ImmutableCard[] cz = preEvent.getCards()[i];
            if (cz == null) continue;
            ItemStack itemStack = c[i].getItemStack(1);
            if (!player.m_36356_(itemStack)) {
                player.m_36176_(itemStack, true);
                ++dropped;
            }
            ++givenCards;
        }
        TCG.EVENT_BUS.post((Event)new PackOpenEvent.Post(player, itemInHand, preEvent.getCards()));
        ArrayList nonNullCards = Lists.newArrayList();
        for (ImmutableCard immutableCard : c) {
            if (immutableCard == null) continue;
            nonNullCards.add(immutableCard);
        }
        ImmutableCard[] nonNullCardArray = nonNullCards.toArray(new ImmutableCard[0]);
        player.m_143399_((AbstractContainerMenu)player.f_36095_);
        if (dropped > 0) {
            ChatHandler.sendFormattedChat((CommandSource)player, ChatFormatting.RED, "pixelmon.drops.fullinventory", dropped + " " + Component.m_237115_((String)(TCGItems.card.m_7626_(null) + ".name")));
        }
        if (givenCards > 0) {
            this.reply(context, new OpenPackGuiPacket(nonNullCardArray));
        } else {
            TCG.LOGGER.error("Card Set: " + CardSets.get(setID).getName() + " has no valid cards!");
        }
    }
}

