/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.network.packets;

import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.tcg.api.card.ImmutableCard;
import com.pixelmonmod.tcg.api.config.TCGConfigProxy;
import com.pixelmonmod.tcg.client.gui.PackScreen;
import com.pixelmonmod.tcg.network.ByteBufTCG;
import com.pixelmonmod.tcg.network.data.AbstractTCGPacket;
import com.pixelmonmod.tcg.network.data.PacketDirection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class OpenPackGuiPacket
extends AbstractTCGPacket {
    private ImmutableCard[] cards;

    public OpenPackGuiPacket() {
        super(PacketDirection.PLAY_CLIENT);
    }

    public OpenPackGuiPacket(ImmutableCard[] cards) {
        this();
        this.cards = cards;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.cards.length);
        for (ImmutableCard card : this.cards) {
            ByteBufTCG.writeCard(buffer, card);
        }
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        int size = buffer.readInt();
        this.cards = new ImmutableCard[size];
        for (int i = 0; i < size; ++i) {
            this.cards[i] = ByteBufTCG.readCard(buffer);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void handlePacket(CustomPayloadEvent.Context context) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null) {
            if (TCGConfigProxy.getConfig() != null) {
                TCGConfigProxy.getConfig().setSavedUIScale((Integer)mc.f_91066_.m_231928_().m_231551_());
                mc.f_91066_.m_231928_().m_231514_((Object)4);
            }
            context.enqueueWork(() -> mc.m_91152_((Screen)new PackScreen(0, this.cards)));
        }
    }
}

