/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.network.packets;

import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.tcg.duel.state.PlayerServerState;
import com.pixelmonmod.tcg.network.data.AbstractTCGPacket;
import com.pixelmonmod.tcg.network.data.PacketDirection;
import com.pixelmonmod.tcg.tileentity.BattleOwnedTileEntityController;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class GenericGUIPacket
extends AbstractTCGPacket {
    private GUITypes type;
    private boolean isOpen;
    private BlockPos blockPos;

    public GenericGUIPacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public GenericGUIPacket(GUITypes type, boolean isOpen, BlockPos blockPos) {
        this();
        this.type = type;
        this.isOpen = isOpen;
        this.blockPos = blockPos;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.type.ordinal());
        buffer.writeBoolean(this.isOpen);
        buffer.writeBoolean(this.blockPos != null);
        if (this.blockPos != null) {
            buffer.m_130064_(this.blockPos);
        }
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        this.type = GUITypes.values()[buffer.readInt()];
        this.isOpen = buffer.readBoolean();
        if (buffer.readBoolean()) {
            this.blockPos = buffer.m_130135_();
        }
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        ServerPlayer player = context.getSender();
        switch (this.type) {
            case DECK: {
                return;
            }
            case BATTLE: {
                PlayerServerState playerState;
                ServerLevel w;
                BattleOwnedTileEntityController b;
                if (!this.isOpen && (b = (BattleOwnedTileEntityController)(w = player.m_284548_()).m_7702_(this.blockPos)) != null && (playerState = b.getGameServer().getPlayer(player)) != null) {
                    playerState.setInGUI(false);
                }
                return;
            }
            case SPECTATE: {
                ServerLevel w;
                BattleOwnedTileEntityController b;
                if (!this.isOpen && (b = (BattleOwnedTileEntityController)(w = player.m_284548_()).m_7702_(this.blockPos)) != null) {
                    b.getGameServer().getSpectators().remove(player);
                }
                return;
            }
        }
    }

    public static enum GUITypes {
        DECK,
        BATTLE,
        SPECTATE;


        public static GUITypes spectating(boolean spectating) {
            return spectating ? SPECTATE : BATTLE;
        }
    }
}

