/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.network.packets;

import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.tcg.network.data.AbstractTCGPacket;
import com.pixelmonmod.tcg.network.data.PacketDirection;
import com.pixelmonmod.tcg.tileentity.BattleSpectatorOwnedTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class BattleSpectatorUpdatePacket
extends AbstractTCGPacket {
    private BlockPos pos;
    private BlockPos controllerPosition;
    private int playerIndex;

    public BattleSpectatorUpdatePacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public BattleSpectatorUpdatePacket(BattleSpectatorOwnedTileEntity spectator) {
        this();
        this.pos = spectator.m_58899_();
        this.controllerPosition = spectator.getControllerPosition();
        this.playerIndex = spectator.getPlayerIndex();
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        buffer.m_130064_(this.controllerPosition);
        buffer.writeInt(this.playerIndex);
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        this.pos = buffer.m_130135_();
        this.controllerPosition = buffer.m_130135_();
        this.playerIndex = buffer.readInt();
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        ServerPlayer player = context.getSender();
        BattleSpectatorOwnedTileEntity tileEntity = (BattleSpectatorOwnedTileEntity)player.m_284548_().m_7702_(this.pos);
        if (tileEntity != null) {
            tileEntity.setControllerPosition(this.controllerPosition);
            tileEntity.setPlayerIndex(this.playerIndex);
            tileEntity.m_6596_();
            player.m_284548_().m_7260_(this.pos, player.m_284548_().m_8055_(this.pos), player.m_284548_().m_8055_(this.pos), 0);
        }
    }
}

