/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.network.data;

import com.pixelmonmod.tcg.TCG;
import com.pixelmonmod.tcg.network.data.PacketDirection;
import com.pixelmonmod.tcg.network.data.TCGPacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.PacketDistributor;

public abstract class AbstractTCGPacket
implements TCGPacket {
    private final boolean sync;
    private final PacketDirection direction;

    public AbstractTCGPacket(PacketDirection direction) {
        this(direction, false);
    }

    public AbstractTCGPacket(PacketDirection direction, boolean sync) {
        this.direction = direction;
        this.sync = sync;
    }

    public AbstractTCGPacket(boolean sync) {
        this.direction = null;
        this.sync = sync;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
    }

    @Override
    public void handle(CustomPayloadEvent.Context context) {
        if (this.sync) {
            context.enqueueWork(() -> this.handlePacket(context));
        } else {
            this.handlePacket(context);
        }
        context.setPacketHandled(true);
    }

    protected abstract void handlePacket(CustomPayloadEvent.Context var1);

    protected void reply(CustomPayloadEvent.Context context, Object packet) {
        TCG.network.send(packet, PacketDistributor.PLAYER.with((Object)context.getSender()));
    }
}

