/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.network;

import com.pixelmonmod.tcg.api.accessors.Cards;
import com.pixelmonmod.tcg.api.card.ImmutableCard;
import com.pixelmonmod.tcg.duel.state.CommonCardState;
import com.pixelmonmod.tcg.duel.state.PokemonCardState;
import com.pixelmonmod.tcg.duel.state.TrainerCardState;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;

public class ByteBufTCG {
    private static final int COMMON_TYPE = 0;
    private static final int POKEMON_TYPE = 1;
    private static final int TRAINER_TYPE = 2;

    public static void writeBlockPos(FriendlyByteBuf buf, BlockPos blockPos) {
        buf.writeInt(blockPos.m_123341_());
        buf.writeInt(blockPos.m_123342_());
        buf.writeInt(blockPos.m_123343_());
    }

    public static BlockPos readBlockPos(FriendlyByteBuf buf) {
        return new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
    }

    public static void writeCard(FriendlyByteBuf buf, ImmutableCard card) {
        buf.m_130070_(card.getCode());
    }

    public static void writeFaceDownCard(FriendlyByteBuf buf) {
        buf.m_130070_(ImmutableCard.FACE_DOWN_CODE);
    }

    public static ImmutableCard readCard(FriendlyByteBuf buf) {
        String cardCode = buf.m_130277_();
        if (cardCode.equalsIgnoreCase(ImmutableCard.FACE_DOWN_CODE)) {
            return ImmutableCard.faceDown();
        }
        return Cards.fromCode(cardCode);
    }

    public static void writeCardList(FriendlyByteBuf buf, List<ImmutableCard> cards) {
        buf.writeInt(cards.size());
        for (ImmutableCard card : cards) {
            ByteBufTCG.writeCard(buf, card);
        }
    }

    public static void writeFaceDownCardList(FriendlyByteBuf buf, List<ImmutableCard> cards) {
        buf.writeInt(cards.size());
        for (ImmutableCard card : cards) {
            ByteBufTCG.writeFaceDownCard(buf);
        }
    }

    public static List<ImmutableCard> readCardList(FriendlyByteBuf buf) {
        int size = buf.readInt();
        ArrayList<ImmutableCard> cards = new ArrayList<ImmutableCard>();
        for (int i = 0; i < size; ++i) {
            cards.add(ByteBufTCG.readCard(buf));
        }
        return cards;
    }

    public static CommonCardState readCardState(FriendlyByteBuf buf) {
        int type = buf.readInt();
        switch (type) {
            case 0: {
                return new CommonCardState(buf);
            }
            case 1: {
                return new PokemonCardState(buf);
            }
            case 2: {
                return new TrainerCardState(buf);
            }
        }
        return null;
    }

    public static void writeCardState(FriendlyByteBuf buf, CommonCardState cardState) {
        if (cardState instanceof PokemonCardState) {
            buf.writeInt(1);
        } else if (cardState instanceof TrainerCardState) {
            buf.writeInt(2);
        } else {
            buf.writeInt(0);
        }
        cardState.write(buf, true);
    }
}

