/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.listener;

import com.pixelmonmod.pixelmon.api.events.BeatWildPixelmonEvent;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.tcg.api.accessors.TCGBlocks;
import com.pixelmonmod.tcg.api.config.TCGConfigProxy;
import com.pixelmonmod.tcg.block.EssenceJarBlock;
import com.pixelmonmod.tcg.client.container.BinderContainer;
import com.pixelmonmod.tcg.client.container.DeckContainer;
import com.pixelmonmod.tcg.tileentity.EssenceJarTileEntity;
import java.awt.Color;
import java.util.TreeMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.joml.Vector3f;

public class TCGServerEventListeners {
    @SubscribeEvent
    public void onDisconnect(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.getEntity().f_36096_ instanceof BinderContainer) {
            ((BinderContainer)event.getEntity().f_36096_).binder.inventory.m_5785_(event.getEntity());
        }
        if (event.getEntity().f_36096_ instanceof DeckContainer) {
            ((DeckContainer)event.getEntity().f_36096_).inventory.m_5785_(event.getEntity());
        }
    }

    @SubscribeEvent
    public void onKnockoutEvent(BeatWildPixelmonEvent event) {
        int essence = 0;
        for (PixelmonWrapper wrapper : event.wpp.allPokemon) {
            essence += TCGConfigProxy.getConfig().getEssenceDropped(wrapper.pokemon.isLegendary() || wrapper.pokemon.isMythical() || wrapper.pokemon.isUltraBeast());
        }
        for (ItemStack stack : event.player.m_150109_().f_35974_) {
            if (stack.m_41720_() != TCGBlocks.essence_jar.m_5456_() || (essence = EssenceJarBlock.addEssence(stack, essence, event.player)) > 0) continue;
            return;
        }
        ServerLevel world = event.player.m_284548_();
        ChunkPos origin = new ChunkPos(event.player.m_20183_());
        double radius = TCGConfigProxy.getConfig().getEssenceRadius();
        double radiusSqr = radius * radius;
        int chunkRadius = (int)(radius / 16.0) + 1;
        TreeMap<Double, EssenceJarTileEntity> jars = new TreeMap<Double, EssenceJarTileEntity>();
        for (int x = -chunkRadius; x <= chunkRadius; ++x) {
            for (int z = -chunkRadius; z <= chunkRadius; ++z) {
                ChunkAccess chunk = world.m_6522_(origin.f_45578_ + x, origin.f_45579_ + z, ChunkStatus.f_62326_, false);
                if (chunk == null) continue;
                for (BlockPos pos : chunk.m_5928_()) {
                    BlockEntity te;
                    double dist = pos.m_123331_((Vec3i)event.player.m_20183_());
                    if (!(dist <= radiusSqr) || !((te = chunk.m_7702_(pos)) instanceof EssenceJarTileEntity)) continue;
                    jars.put(dist, (EssenceJarTileEntity)te);
                }
            }
        }
        for (EssenceJarTileEntity jar : jars.values()) {
            essence = jar.addEssence(essence);
            if (essence > 0) continue;
            return;
        }
    }

    public static void playEssenceJarEffect(int totalEssence, int essence, int current, int target, ServerLevel world, BlockPos pos, Color color) {
        int added = essence - Math.max(0, current - target);
        if (added > 0) {
            int i;
            for (i = 0; i < added; ++i) {
                world.m_8767_((ParticleOptions)ParticleTypes.f_123811_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.65, (double)pos.m_123343_() + 0.5, 0, (double)((float)color.getRed() / 255.0f), (double)((float)color.getGreen() / 255.0f), (double)((float)color.getBlue() / 255.0f), 1.0);
            }
            if (totalEssence >= target) {
                for (i = 0; i < 10; ++i) {
                    world.m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f), RandomHelper.getRandom().nextFloat() + 1.0f), (double)pos.m_123341_() + 0.5 + (RandomHelper.getRandom().nextDouble() - 0.5) * 0.75, (double)pos.m_123342_() + 0.4 + (RandomHelper.getRandom().nextDouble() - 0.5) * 0.5, (double)pos.m_123343_() + 0.5 + (RandomHelper.getRandom().nextDouble() - 0.5) * 0.75, 0, RandomHelper.getRandom().nextDouble() - 0.5, RandomHelper.getRandom().nextDouble() - 0.5, RandomHelper.getRandom().nextDouble() - 0.5, 1.0);
                }
                world.m_5594_(null, pos, SoundEvents.f_12275_, SoundSource.BLOCKS, 0.75f, 1.5f);
            } else {
                world.m_5594_(null, pos, SoundEvents.f_11772_, SoundSource.BLOCKS, Math.min(2.0f, 0.25f * (float)added), 1.0f);
            }
        }
    }
}

