/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.item;

import com.pixelmonmod.tcg.api.accessors.ThemeDecks;
import com.pixelmonmod.tcg.api.card.ImmutableCard;
import com.pixelmonmod.tcg.api.card.ThemeDeck;
import com.pixelmonmod.tcg.api.util.helper.LogicHelper;
import com.pixelmonmod.tcg.client.container.DeckContainer;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;

public class DeckItem
extends Item {
    public DeckItem() {
        super(new Item.Properties().m_41487_(1));
    }

    public Component m_7626_(ItemStack stack) {
        Component textComponent = super.m_7626_(stack);
        if (stack.m_41783_() != null && stack.m_41783_().m_128441_("deck")) {
            ThemeDeck deck = ThemeDecks.get(stack.m_41783_().m_128461_("deck"));
            if (deck != null) {
                textComponent = Component.m_237113_((String)("deck." + deck.getName().toLowerCase() + ".name"));
            }
            if (stack.m_41783_().m_128471_("locked")) {
                textComponent = textComponent.m_6881_().m_130946_(" (").m_7220_((Component)Component.m_237113_((String)"item.deck.locked")).m_130946_(")");
            }
        }
        return textComponent;
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, world, tooltip, flag);
        List<ImmutableCard> cards = LogicHelper.getCards(null, stack);
        tooltip.add((Component)Component.m_237113_((String)("Cards: " + cards.size())));
    }

    public int m_8105_(ItemStack item) {
        return 1;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!world.f_46443_ && hand == InteractionHand.MAIN_HAND) {
            DeckItem.openDeck(stack, (ServerPlayer)player);
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        Player player = context.m_43723_();
        if (!level.f_46443_ || player.m_6047_()) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public static void openDeck(final ItemStack stack, final ServerPlayer player) {
        if (stack.m_41720_() instanceof DeckItem) {
            final Deck deck = Deck.readFromItemStack((Player)player, stack);
            SimpleMenuProvider containerProvider = new SimpleMenuProvider((a, b, c) -> new DeckContainer(a, (Player)player, player.m_150109_(), deck), (Component)Component.m_237115_((String)""));
            if (!player.m_150109_().m_36063_(stack)) {
                return;
            }
            player.openMenu((MenuProvider)containerProvider, deck::writeToBuffer);
            player.f_36096_.m_38893_(new ContainerListener(){

                public void m_7934_(AbstractContainerMenu container, int slot, ItemStack item) {
                    if (!player.m_150109_().m_36063_(stack)) {
                        return;
                    }
                    if (slot >= deck.inventory.m_6643_()) {
                        return;
                    }
                    deck.inventory.m_6836_(slot, item);
                    deck.writeToStack(stack);
                }

                public void m_142153_(AbstractContainerMenu p_71112_1_, int p_71112_2_, int p_71112_3_) {
                    if (!player.m_150109_().m_36063_(stack)) {
                        return;
                    }
                    deck.writeToStack(stack);
                }
            });
        }
    }

    public static class Deck {
        public static final int size = 62;
        public Container inventory;
        private int slot;
        public boolean locked;

        public Deck(Container inventory, boolean locked, int slot) {
            this.inventory = inventory;
            this.locked = locked;
            this.slot = slot;
        }

        public int getSlot() {
            return this.slot;
        }

        public void writeToBuffer(FriendlyByteBuf buffer) {
            CompoundTag compound = new CompoundTag();
            this.saveInventory(compound);
            buffer.m_130079_((Tag)compound);
            buffer.writeBoolean(this.locked);
            if (this.slot >= 0) {
                buffer.writeInt(this.slot);
            }
        }

        public static Deck fromBuffer(FriendlyByteBuf buffer) {
            CompoundTag compound = buffer.m_130260_();
            SimpleContainer inventory = Deck.fromTag(compound);
            return new Deck((Container)inventory, buffer.readBoolean(), buffer.readInt());
        }

        public void writeToStack(ItemStack stack) {
            CompoundTag compound = stack.m_41784_();
            this.saveInventory(compound);
            compound.m_128379_("DeckLocked", this.locked);
        }

        public void saveInventory(CompoundTag CompoundTag2) {
            ListTag list = new ListTag();
            for (int i = 0; i < this.inventory.m_6643_(); ++i) {
                CompoundTag nbt = new CompoundTag();
                nbt.m_128405_("slot", i);
                nbt.m_128365_("item", (Tag)this.inventory.m_8020_(i).m_41739_(new CompoundTag()));
                list.add((Object)nbt);
            }
            CompoundTag2.m_128365_("DeckItems", (Tag)list);
        }

        public static SimpleContainer fromTag(CompoundTag nbt) {
            ListTag list = nbt.m_128437_("DeckItems", 10);
            SimpleContainer inventory = new SimpleContainer(62);
            for (Tag inbt : list) {
                CompoundTag listNBT = (CompoundTag)inbt;
                inventory.m_6836_(listNBT.m_128451_("slot"), ItemStack.m_41712_((CompoundTag)listNBT.m_128469_("item")));
            }
            return inventory;
        }

        public static Deck readFromItemStack(Player player, ItemStack stack) {
            if (!(stack.m_41720_() instanceof DeckItem)) {
                return null;
            }
            CompoundTag compound = stack.m_41783_();
            SimpleContainer inventory = new SimpleContainer(62);
            if (compound != null && compound.m_128441_("DeckItems")) {
                inventory = Deck.fromTag(compound);
            }
            boolean locked = false;
            if (compound != null) {
                locked = compound.m_128471_("DeckLocked");
            }
            int slot = -1;
            if (player != null) {
                for (int i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
                    ItemStack item = (ItemStack)player.m_150109_().f_35974_.get(i);
                    if (!Objects.equals(item, stack)) continue;
                    slot = i;
                    break;
                }
            }
            Deck deck = new Deck((Container)inventory, locked, slot);
            inventory.m_19164_(p_76316_1_ -> deck.writeToStack(stack));
            return deck;
        }

        public boolean isLocked() {
            return this.locked;
        }
    }
}

