/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.item;

import com.pixelmonmod.tcg.api.accessors.CardSets;
import com.pixelmonmod.tcg.api.accessors.Cards;
import com.pixelmonmod.tcg.api.card.ImmutableCard;
import com.pixelmonmod.tcg.api.card.set.CardSet;
import com.pixelmonmod.tcg.api.util.helper.NetworkHelper;
import com.pixelmonmod.tcg.client.gui.CardScreen;
import com.pixelmonmod.tcg.network.packets.CardSyncPacket;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CardItem
extends Item {
    private static final String name = "card";

    public CardItem() {
        super(new Item.Properties().m_41487_(1));
    }

    public Component m_7626_(ItemStack itemstack) {
        ImmutableCard c;
        if (itemstack.m_41783_() != null && (c = Cards.fromNBT(itemstack.m_41783_())) != null) {
            return Component.m_237115_((String)c.getName());
        }
        return super.m_7626_(itemstack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, world, tooltip, flag);
        if (stack.m_41783_() != null) {
            ImmutableCard c = Cards.fromNBT(stack.m_41783_());
            CardSet cardSet = CardSets.get(c.getSetID());
            if (c != null && stack.m_41737_("Lore") == null && cardSet != null) {
                tooltip.clear();
                tooltip.add(c.getTranslatedName());
                tooltip.add((Component)Component.m_237115_((String)I18n.m_118938_((String)"item.card.lore.code", (Object[])new Object[]{c.getCode()})));
                tooltip.add((Component)Component.m_237115_((String)I18n.m_118938_((String)"item.card.lore.set", (Object[])new Object[]{cardSet.getName()})));
                tooltip.add((Component)Component.m_237115_((String)I18n.m_118938_((String)"item.card.lore.rarity", (Object[])new Object[]{c.getRarity().getLocalizedName()})));
                tooltip.add((Component)Component.m_237115_((String)I18n.m_118938_((String)"item.card.lore.type", (Object[])new Object[]{c.getCardType().getLocalizedName()})));
            }
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        if (world.f_46443_) {
            this.openScreen(player, hand);
        }
        return super.m_7203_(world, player, hand);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void openScreen(Player player, InteractionHand hand) {
        if (player.m_21120_(hand).m_41783_() != null) {
            Minecraft.m_91087_().m_91152_((Screen)new CardScreen(Cards.fromNBT(player.m_21120_(hand).m_41783_())));
        }
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (entityIn != null && !worldIn.f_46443_ && entityIn instanceof ServerPlayer) {
            ImmutableCard c;
            CompoundTag tag;
            ServerPlayer p = (ServerPlayer)entityIn;
            if (stack.m_41783_() == null) {
                stack.m_41751_(new CompoundTag());
            }
            if (!(tag = stack.m_41783_()).m_128441_(ImmutableCard.CARD_CODE_NBT_KEY) && (c = Cards.getRandomCard()) != null) {
                tag.m_128359_(ImmutableCard.CARD_CODE_NBT_KEY, c.getCode());
                NetworkHelper.sendPacket(new CardSyncPacket(itemSlot, c.getCode(), false), p);
            }
        }
    }

    public static String getName() {
        return name;
    }
}

