/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.item;

import com.pixelmonmod.tcg.client.container.BinderContainer;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class BinderItem
extends Item {
    private static final String name = "binder";

    public BinderItem() {
        super(new Item.Properties().m_41487_(1));
    }

    public int m_8105_(ItemStack p_77626_1_) {
        return 1;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (!level.f_46443_ && !player.m_6047_()) {
            BinderItem.openBinder(player.m_21120_(hand), (ServerPlayer)player);
        }
        return super.m_7203_(level, player, hand);
    }

    public static void openBinder(final ItemStack stack, final ServerPlayer player) {
        if (!(stack.m_41720_() instanceof BinderItem)) {
            return;
        }
        if (!player.m_150109_().m_36063_(stack)) {
            return;
        }
        final Binder binder = Binder.readFromItemStack((Player)player, stack);
        SimpleMenuProvider containerProvider = new SimpleMenuProvider((a, b, c) -> new BinderContainer(a, player.m_150109_(), binder), (Component)Component.m_237119_());
        player.openMenu((MenuProvider)containerProvider, binder::writeToBuffer);
        player.f_36096_.m_38893_(new ContainerListener(){

            public void m_7934_(AbstractContainerMenu p_39315_, int slot, ItemStack item) {
                if (!player.m_150109_().m_36063_(stack)) {
                    return;
                }
                if (slot >= binder.inventory.m_6643_()) {
                    return;
                }
                binder.inventory.m_6836_(slot, item);
                binder.writeToStack(stack);
            }

            public void m_142153_(AbstractContainerMenu p_150524_, int p_150525_, int p_150526_) {
                if (!player.m_150109_().m_36063_(stack)) {
                    return;
                }
                binder.writeToStack(stack);
            }
        });
    }

    public static class Binder {
        public Container inventory;
        private int slot;
        private int page;

        public Binder(Container inventory, int slot) {
            this.inventory = inventory;
            this.slot = slot;
            this.page = 0;
        }

        public int getSlot() {
            return this.slot;
        }

        public void writeToStack(ItemStack stack) {
            CompoundTag compound = stack.m_41784_();
            this.saveInventory(compound);
        }

        public void writeToBuffer(FriendlyByteBuf buffer) {
            CompoundTag compound = new CompoundTag();
            this.saveInventory(compound);
            buffer.m_130079_((Tag)compound);
            buffer.writeInt(this.slot);
        }

        public void saveInventory(CompoundTag CompoundTag2) {
            ListTag list = new ListTag();
            for (int i = 0; i < this.inventory.m_6643_(); ++i) {
                CompoundTag nbt = new CompoundTag();
                nbt.m_128405_("slot", i);
                nbt.m_128365_("item", (Tag)this.inventory.m_8020_(i).m_41739_(new CompoundTag()));
                list.add((Object)nbt);
            }
            CompoundTag2.m_128365_("PokeBagItems", (Tag)list);
        }

        public int getPage() {
            return this.page;
        }

        public int getSizePage() {
            return 24;
        }

        public void decrementPage() {
            if (this.page > 0) {
                this.page = this.getPage() - 1;
            }
        }

        public void incrementPage() {
            if (this.page < 11) {
                this.page = this.getPage() + 1;
            }
        }

        public static Container fromTag(CompoundTag nbt) {
            ListTag list = nbt.m_128437_("PokeBagItems", 10);
            SimpleContainer inventory = new SimpleContainer(288);
            for (Tag inbt : list) {
                CompoundTag listNBT = (CompoundTag)inbt;
                inventory.m_6836_(listNBT.m_128451_("slot"), ItemStack.m_41712_((CompoundTag)listNBT.m_128469_("item")));
            }
            return inventory;
        }

        public static Binder readFromItemStack(Player player, ItemStack stack) {
            if (!(stack.m_41720_() instanceof BinderItem)) {
                return null;
            }
            CompoundTag compound = stack.m_41783_();
            SimpleContainer inventory = new SimpleContainer(288);
            if (compound != null && compound.m_128441_("TCGBinderItems")) {
                inventory = Binder.fromTag(compound);
            }
            int slot = -1;
            for (int i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
                ItemStack item = (ItemStack)player.m_150109_().f_35974_.get(i);
                if (!Objects.equals(item, stack)) continue;
                slot = i;
                break;
            }
            Binder binder = new Binder((Container)inventory, slot);
            return binder;
        }

        public static Binder fromBuffer(FriendlyByteBuf buffer) {
            CompoundTag compound = buffer.m_130260_();
            Container inventory = Binder.fromTag(compound);
            return new Binder(inventory, buffer.readInt());
        }
    }
}

