/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.init.registry;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.tcg.TCG;
import com.pixelmonmod.tcg.network.data.TCGPacket;
import com.pixelmonmod.tcg.network.packets.BattleSpectatorUpdatePacket;
import com.pixelmonmod.tcg.network.packets.CardBackSyncPacket;
import com.pixelmonmod.tcg.network.packets.CardSyncPacket;
import com.pixelmonmod.tcg.network.packets.CoinSyncPacket;
import com.pixelmonmod.tcg.network.packets.GenericGUIPacket;
import com.pixelmonmod.tcg.network.packets.OpenBinderPacket;
import com.pixelmonmod.tcg.network.packets.OpenPackGuiPacket;
import com.pixelmonmod.tcg.network.packets.OpenPackPacket;
import com.pixelmonmod.tcg.network.packets.PackSyncPacket;
import com.pixelmonmod.tcg.network.packets.battles.CardSelectorToServerPacket;
import com.pixelmonmod.tcg.network.packets.battles.CoinFlipAckPacket;
import com.pixelmonmod.tcg.network.packets.battles.CustomGUIChoiceToServerPacket;
import com.pixelmonmod.tcg.network.packets.battles.EndGamePacket;
import com.pixelmonmod.tcg.network.packets.battles.ForceEndBattlePacket;
import com.pixelmonmod.tcg.network.packets.battles.GameStateSyncPacket;
import com.pixelmonmod.tcg.network.packets.battles.GenericActionRequestPacket;
import com.pixelmonmod.tcg.network.packets.battles.PrizeSelectorToClientPacket;
import com.pixelmonmod.tcg.network.packets.battles.PrizeSelectorToServerPacket;
import com.pixelmonmod.tcg.network.packets.battles.RenderStatePreBattleSyncPacket;
import com.pixelmonmod.tcg.network.packets.battles.RenderStateSyncPacket;
import com.pixelmonmod.tcg.network.packets.battles.RetreatAndSwitchPacket;
import com.pixelmonmod.tcg.network.packets.battles.ShowOpponentCardPacket;
import com.pixelmonmod.tcg.network.packets.battles.SwitchPacket;
import com.pixelmonmod.tcg.network.packets.battles.TCGGuiClientPacket;
import com.pixelmonmod.tcg.network.packets.battles.TrainerPlayedPacket;
import com.pixelmonmod.tcg.network.packets.battles.UpdateServerCardRecordPacket;
import com.pixelmonmod.tcg.network.sync.SyncCardSetsPacket;
import com.pixelmonmod.tcg.network.sync.SyncCardsPacket;
import com.pixelmonmod.tcg.network.sync.SyncThemeDecksPacket;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

public class PacketRegistration {
    private static int id = 0;

    public static void registerPackets() {
        PacketRegistration.register(PackSyncPacket.class, PackSyncPacket::new);
        PacketRegistration.register(OpenPackPacket.class, OpenPackPacket::new);
        PacketRegistration.register(OpenPackGuiPacket.class, OpenPackGuiPacket::new);
        PacketRegistration.register(OpenBinderPacket.class, OpenBinderPacket::new);
        PacketRegistration.register(GenericGUIPacket.class, GenericGUIPacket::new);
        PacketRegistration.register(CoinSyncPacket.class, CoinSyncPacket::new);
        PacketRegistration.register(CardSyncPacket.class, CardSyncPacket::new);
        PacketRegistration.register(CardBackSyncPacket.class, CardBackSyncPacket::new);
        PacketRegistration.register(BattleSpectatorUpdatePacket.class, BattleSpectatorUpdatePacket::new);
        PacketRegistration.register(UpdateServerCardRecordPacket.class, UpdateServerCardRecordPacket::new);
        PacketRegistration.register(TrainerPlayedPacket.class, TrainerPlayedPacket::new);
        PacketRegistration.register(TCGGuiClientPacket.class, TCGGuiClientPacket::new);
        PacketRegistration.register(SwitchPacket.class, SwitchPacket::new);
        PacketRegistration.register(ShowOpponentCardPacket.class, ShowOpponentCardPacket::new);
        PacketRegistration.register(RetreatAndSwitchPacket.class, RetreatAndSwitchPacket::new);
        PacketRegistration.register(RenderStateSyncPacket.class, RenderStateSyncPacket::new);
        PacketRegistration.register(RenderStatePreBattleSyncPacket.class, RenderStatePreBattleSyncPacket::new);
        PacketRegistration.register(PrizeSelectorToServerPacket.class, PrizeSelectorToServerPacket::new);
        PacketRegistration.register(PrizeSelectorToClientPacket.class, PrizeSelectorToClientPacket::new);
        PacketRegistration.register(GenericActionRequestPacket.class, GenericActionRequestPacket::new);
        PacketRegistration.register(GameStateSyncPacket.class, GameStateSyncPacket::new);
        PacketRegistration.register(ForceEndBattlePacket.class, ForceEndBattlePacket::new);
        PacketRegistration.register(EndGamePacket.class, EndGamePacket::new);
        PacketRegistration.register(CustomGUIChoiceToServerPacket.class, CustomGUIChoiceToServerPacket::new);
        PacketRegistration.register(CoinFlipAckPacket.class, CoinFlipAckPacket::new);
        PacketRegistration.register(CardSelectorToServerPacket.class, CardSelectorToServerPacket::new);
        PacketRegistration.register(SyncCardsPacket.class, SyncCardsPacket::new);
        PacketRegistration.register(SyncCardSetsPacket.class, SyncCardSetsPacket::new);
        PacketRegistration.register(SyncThemeDecksPacket.class, SyncThemeDecksPacket::new);
    }

    private static void register(Class<? extends TCGPacket> clazz) {
        PacketRegistration.register(clazz, null);
    }

    private static void register(Class<? extends TCGPacket> clazz, Supplier<? extends TCGPacket> supplier) {
        PacketInfo annotation = clazz.getAnnotation(PacketInfo.class);
        if (annotation == null) {
            Pixelmon.LOGGER.error("Packet without annotation! " + clazz.getCanonicalName());
            return;
        }
        if (supplier != null) {
            for (NetworkDirection networkDirection : annotation.value()) {
                TCG.network.messageBuilder(clazz, id++, networkDirection).encoder(PacketRegistration::encode).decoder(buffer -> PacketRegistration.decodeUsingSupplier(buffer, supplier)).consumerNetworkThread((pixelmonPacket, context) -> PacketRegistration.handle(pixelmonPacket, context)).add();
            }
        } else {
            for (NetworkDirection networkDirection : annotation.value()) {
                TCG.network.messageBuilder(clazz, id++, networkDirection).encoder(PacketRegistration::encode).decoder(buffer -> PacketRegistration.decodeReflectively(buffer, clazz)).consumerNetworkThread((pixelmonPacket, context) -> PacketRegistration.handle(pixelmonPacket, context)).add();
            }
        }
    }

    private static <T extends TCGPacket> void encode(T t, FriendlyByteBuf FriendlyByteBuf2) {
        t.encode(FriendlyByteBuf2);
    }

    private static <T extends TCGPacket> T decodeUsingSupplier(FriendlyByteBuf FriendlyByteBuf2, Supplier<? extends TCGPacket> supplier) {
        TCGPacket t = supplier.get();
        t.decode(FriendlyByteBuf2);
        return (T)t;
    }

    private static <T extends TCGPacket> T decodeReflectively(FriendlyByteBuf FriendlyByteBuf2, Class<? extends TCGPacket> clazz) {
        try {
            TCGPacket t = clazz.newInstance();
            t.decode(FriendlyByteBuf2);
            return (T)t;
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static <T extends TCGPacket> void handle(T t, CustomPayloadEvent.Context contextSupplier) {
        t.handle(contextSupplier);
    }
}

