/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.init.registry;

import com.pixelmonmod.pixelmon.client.models.items.BEWLRCallable;
import com.pixelmonmod.pixelmon.client.models.items.PixelmonBEWLRs;
import com.pixelmonmod.pixelmon.items.PixelmonBlockItem;
import com.pixelmonmod.tcg.block.BattleControllerBlock;
import com.pixelmonmod.tcg.block.BattleSpectatorBlock;
import com.pixelmonmod.tcg.block.EssenceJarBlock;
import com.pixelmonmod.tcg.init.registry.ItemRegistration;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="tcg", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class BlockRegistration {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"tcg");
    public static final RegistryObject<Block> SMALL_BATTLE_CONTROLLER = BlockRegistration.registerBlock("small_battle_controller", () -> new BattleControllerBlock("small_battle_controller", 1.0f));
    public static final RegistryObject<Block> MEDIUM_BATTLE_CONTROLLER = BlockRegistration.registerBlock("medium_battle_controller", () -> new BattleControllerBlock("medium_battle_controller", 2.0f));
    public static final RegistryObject<Block> LARGE_BATTLE_CONTROLLER = BlockRegistration.registerBlock("large_battle_controller", () -> new BattleControllerBlock("large_battle_controller", 4.0f));
    public static final RegistryObject<Block> BATTLE_SPECTATOR = BlockRegistration.registerBlock("battle_spectator", BattleSpectatorBlock::new);
    public static final RegistryObject<Block> ESSENCE_JAR = BlockRegistration.registerBlockWithISTER("essence_jar", EssenceJarBlock::new, () -> PixelmonBEWLRs.ESSENCE_JAR_ISTER, new Item.Properties().m_41487_(1));

    private static <A extends Block, B extends Item> void registerBlockWithCustomItem(String name, Supplier<A> block, Function<A, B> item) {
        RegistryObject result = BLOCKS.register(name, block);
        ItemRegistration.ITEMS.register(name, () -> (Item)item.apply((Block)result.get()));
    }

    private static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> block) {
        RegistryObject result = BLOCKS.register(name, block);
        BlockRegistration.registerBlockItem(name, result);
        return result;
    }

    private static <T extends Block> RegistryObject<T> registerBlockWithISTER(String name, Supplier<T> block, Supplier<BEWLRCallable> ister) {
        RegistryObject result = BLOCKS.register(name, block);
        BlockRegistration.registerBlockItemWithBEWLR(name, result, ister);
        return result;
    }

    private static <T extends Block> RegistryObject<T> registerBlockWithISTER(String name, Supplier<T> block, Supplier<BEWLRCallable> ister, Item.Properties itemProperties) {
        RegistryObject result = BLOCKS.register(name, block);
        BlockRegistration.registerBlockItemWithBEWLR(name, result, ister, itemProperties);
        return result;
    }

    private static <T extends Block> RegistryObject<T> registerBlockPixelmon(String name, Supplier<T> block) {
        RegistryObject result = BLOCKS.register(name, block);
        BlockRegistration.registerBlockItemPixelmon(name, result);
        return result;
    }

    private static <T extends Block> RegistryObject<T> registerBlockNoItem(String name, Supplier<T> block) {
        return BLOCKS.register(name, block);
    }

    private static <T extends Block> void registerBlockItem(String name, RegistryObject<T> block) {
        ItemRegistration.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    private static <T extends Block> void registerBlockItemWithBEWLR(String name, RegistryObject<T> block, Supplier<BEWLRCallable> bewlr) {
        ItemRegistration.ITEMS.register(name, () -> new PixelmonBlockItem((Block)block.get(), new Item.Properties(), bewlr));
    }

    private static <T extends Block> void registerBlockItemPixelmon(String name, RegistryObject<T> block) {
        ItemRegistration.ITEMS.register(name, () -> new PixelmonBlockItem((Block)block.get(), new Item.Properties()));
    }

    private static <T extends Block> void registerBlockItemWithBEWLR(String name, RegistryObject<T> block, Supplier<BEWLRCallable> bewlr, Item.Properties itemProperties) {
        ItemRegistration.ITEMS.register(name, () -> new PixelmonBlockItem((Block)block.get(), itemProperties, bewlr));
    }
}

