/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.init.loaders;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.pixelmonmod.api.loader.DatapackLoader;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.comm.packetHandlers.sync.DataSyncControlPacket;
import com.pixelmonmod.pixelmon.tools.TriConsumer;
import com.pixelmonmod.tcg.api.accessors.CardSets;
import com.pixelmonmod.tcg.api.accessors.Cards;
import com.pixelmonmod.tcg.api.accessors.TCGItems;
import com.pixelmonmod.tcg.api.accessors.ThemeDecks;
import com.pixelmonmod.tcg.network.sync.SyncCardSetsPacket;
import com.pixelmonmod.tcg.network.sync.SyncCardsPacket;
import com.pixelmonmod.tcg.network.sync.SyncThemeDecksPacket;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="tcg", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class TCGLoaders {
    public static final Map<String, TriConsumer<Gson, ResourceLocation, JsonElement>> CONFIG_PROCESSORS = Maps.newHashMap();
    public static final String CARDSET_DATA = "cardsets";
    public static final String THEMEDECK_DATA = "themedecks";
    public static final String CARD_DATA = "cards";

    @SubscribeEvent
    public static void addReloadListeners(AddReloadListenerEvent event) {
        DatapackLoader.builder("tcg").gson(Cards.GSON).type(CARD_DATA).process(Cards::register).create(event);
        DatapackLoader.builder("tcg").gson(CardSets.GSON).type(CARDSET_DATA).process(CardSets::register).create(event);
        DatapackLoader.builder("tcg").gson(ThemeDecks.GSON).type(THEMEDECK_DATA).process(ThemeDecks::register).create(event);
    }

    @SubscribeEvent
    public static void syncData(OnDatapackSyncEvent event) {
        ServerPlayer player = event.getPlayer();
        if (player != null) {
            Item card = TCGItems.card;
            if (card == null) {
                event.getPlayer().f_8906_.f_291338_.channel().close();
                return;
            }
            NetworkHelper.sendPacket(player, new DataSyncControlPacket("tcg", true, 60000L));
            SyncCardsPacket.sync(player);
            SyncCardSetsPacket.sync(player);
            SyncThemeDecksPacket.sync(player);
            NetworkHelper.sendPacket(player, new DataSyncControlPacket("tcg", false, -1L));
        }
    }
}

