/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.entity;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.pixelmonmod.tcg.api.accessors.CardBacks;
import com.pixelmonmod.tcg.api.accessors.CardSets;
import com.pixelmonmod.tcg.api.accessors.Coins;
import com.pixelmonmod.tcg.api.accessors.TCGBlocks;
import com.pixelmonmod.tcg.api.card.personalization.CardBack;
import com.pixelmonmod.tcg.api.card.personalization.Coin;
import com.pixelmonmod.tcg.api.card.set.CardSet;
import com.pixelmonmod.tcg.api.config.TCGConfigProxy;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.awt.Color;
import java.util.ArrayList;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;

public class TCGTrades {
    public static final Int2ObjectMap<VillagerTrades.ItemListing[]> TCG_TRADER_TRADES;

    private static Int2ObjectMap<VillagerTrades.ItemListing[]> toIntMap(ImmutableMap<Integer, VillagerTrades.ItemListing[]> map) {
        return new Int2ObjectOpenHashMap(map);
    }

    static {
        ArrayList trades = Lists.newArrayList();
        for (DyeColor color : DyeColor.values()) {
            for (CardSet set : CardSets.getAll()) {
                if (!set.hasPack()) continue;
                trades.add(new EssenceJarForItemStack(25, set::getItemStack, color));
            }
            if (!TCGConfigProxy.getConfig().shouldGenerateCosmeticsInCardShop()) continue;
            for (CardBack cardBack : CardBacks.getAll()) {
                trades.add(new EssenceJarForItemStack(25, cardBack::getItemStack, color));
            }
            for (Coin coin : Coins.getAll()) {
                trades.add(new EssenceJarForItemStack(25, coin::getItemStack, color));
            }
        }
        TCG_TRADER_TRADES = TCGTrades.toIntMap((ImmutableMap<Integer, VillagerTrades.ItemListing[]>)ImmutableMap.builder().put((Object)1, (Object)trades.toArray(new VillagerTrades.ItemListing[0])).build());
    }

    static class EssenceJarForItemStack
    implements VillagerTrades.ItemListing {
        final int xp;
        private final Supplier<ItemStack> itemStack;
        private final String name;
        private final Color color;

        public EssenceJarForItemStack(int xp, Supplier<ItemStack> itemStack, DyeColor color) {
            this.xp = xp;
            this.itemStack = itemStack;
            this.name = Component.Serializer.m_130703_((Component)Component.m_237115_((String)("color.minecraft." + color.m_41065_())));
            this.color = new Color(color.m_41071_());
        }

        @Nullable
        public MerchantOffer m_213663_(Entity entity, RandomSource rand) {
            if (this.itemStack == null) {
                return null;
            }
            ItemStack cost = new ItemStack((ItemLike)TCGBlocks.essence_jar, 1);
            cost.m_41698_("BlockEntityTag").m_128405_("EssenceJarCount", TCGConfigProxy.getConfig().getEssenceToFillJar());
            cost.m_41698_("BlockEntityTag").m_128347_("EssenceJarPercent", 1.0);
            cost.m_41698_("BlockEntityTag").m_128405_("EssenceJarColorRed", this.color.getRed());
            cost.m_41698_("BlockEntityTag").m_128405_("EssenceJarColorGreen", this.color.getGreen());
            cost.m_41698_("BlockEntityTag").m_128405_("EssenceJarColorBlue", this.color.getBlue());
            cost.m_41698_("BlockEntityTag").m_128359_("EssenceJarColorName", this.name);
            return new MerchantOffer(cost, this.itemStack.get(), Integer.MAX_VALUE, this.xp, 0.0f);
        }
    }
}

