/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.duel.trainer;

import com.pixelmonmod.tcg.api.util.helper.SelectorHelper;
import com.pixelmonmod.tcg.client.gui.duel.CardWithLocation;
import com.pixelmonmod.tcg.duel.state.CardSelectorState;
import com.pixelmonmod.tcg.duel.state.GameClientState;
import com.pixelmonmod.tcg.duel.state.GameServerState;
import com.pixelmonmod.tcg.duel.state.PokemonCardState;
import com.pixelmonmod.tcg.duel.state.TrainerCardState;
import com.pixelmonmod.tcg.duel.trainer.BaseTrainerEffect;
import com.pixelmonmod.tcg.network.packets.enums.BoardLocation;

public class Potion
extends BaseTrainerEffect {
    public Potion() {
        super("potion");
    }

    @Override
    public boolean canPlay(GameClientState client) {
        return true;
    }

    @Override
    public boolean canPlaceOn(CardWithLocation card) {
        return card != null && card.getCard() != null && card.isMine() && (card.getLocation() == BoardLocation.Active || card.getLocation() == BoardLocation.Bench);
    }

    @Override
    public CardSelectorState getSelectorState(TrainerCardState trainer, GameServerState server) {
        return SelectorHelper.generateSelectorForActiveAndBench(server.getPlayer(server.getCurrentTurn()), "card.base94.effect.selector");
    }

    @Override
    public boolean canApply(TrainerCardState trainer, GameServerState server) {
        return trainer.getParameters().size() == 1;
    }

    @Override
    public void apply(TrainerCardState trainer, GameServerState server) {
        PokemonCardState pokemon = (PokemonCardState)trainer.getParameters().get(0);
        pokemon.getStatus().setDamage(pokemon.getStatus().getDamage() - 20);
    }

    @Override
    public boolean canSkipSelector() {
        return true;
    }

    @Override
    public void applySkipSelector(TrainerCardState trainer, PokemonCardState pokemon, GameServerState server, BoardLocation b, int p) {
        pokemon.getStatus().setDamage(pokemon.getStatus().getDamage() - 20);
    }
}

