/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.duel.trainer;

import com.pixelmonmod.tcg.duel.state.GameClientState;
import com.pixelmonmod.tcg.duel.state.GameServerState;
import com.pixelmonmod.tcg.duel.state.PlayerServerState;
import com.pixelmonmod.tcg.duel.state.PokemonCardState;
import com.pixelmonmod.tcg.duel.state.TrainerCardState;
import com.pixelmonmod.tcg.duel.trainer.BaseTrainerEffect;
import com.pixelmonmod.tcg.network.packets.enums.BoardLocation;
import java.util.List;
import java.util.stream.Collectors;

public class PokemonCenter
extends BaseTrainerEffect {
    public PokemonCenter() {
        super("pokemon_center");
    }

    @Override
    public boolean canPlay(GameClientState client) {
        return true;
    }

    @Override
    public boolean canApply(TrainerCardState trainer, GameServerState server) {
        return true;
    }

    @Override
    public void apply(TrainerCardState trainer, GameServerState server) {
        PlayerServerState me = server.getPlayer(server.getCurrentTurn());
        if (me.getActiveCard() != null) {
            this.apply(me.getActiveCard());
        }
        for (PokemonCardState card : me.getBenchCards()) {
            if (card == null) continue;
            this.apply(card);
        }
    }

    private void apply(PokemonCardState card) {
        if (card.getStatus().getDamage() > 0) {
            card.getStatus().setDamage(0);
            List energies = card.getAttachments().stream().filter(attachment -> attachment.isEnergyEquivalence()).collect(Collectors.toList());
            card.getAttachments().removeAll(energies);
        }
    }

    @Override
    public boolean canSkipSelector() {
        return false;
    }

    @Override
    public void applySkipSelector(TrainerCardState trainer, PokemonCardState pokemon, GameServerState server, BoardLocation b, int p) {
    }
}

