/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.duel.trainer;

import com.pixelmonmod.tcg.api.accessors.Cards;
import com.pixelmonmod.tcg.api.card.CardType;
import com.pixelmonmod.tcg.api.card.ImmutableCard;
import com.pixelmonmod.tcg.api.util.helper.LogicHelper;
import com.pixelmonmod.tcg.client.gui.duel.CardWithLocation;
import com.pixelmonmod.tcg.client.gui.enums.CardSelectorDisplay;
import com.pixelmonmod.tcg.duel.state.CardSelectorState;
import com.pixelmonmod.tcg.duel.state.CommonCardState;
import com.pixelmonmod.tcg.duel.state.GameClientState;
import com.pixelmonmod.tcg.duel.state.GameServerState;
import com.pixelmonmod.tcg.duel.state.PlayerServerState;
import com.pixelmonmod.tcg.duel.state.PokemonCardState;
import com.pixelmonmod.tcg.duel.state.TrainerCardState;
import com.pixelmonmod.tcg.duel.trainer.BaseTrainerEffect;
import com.pixelmonmod.tcg.network.packets.enums.BoardLocation;
import java.util.Optional;
import java.util.stream.Collectors;

public class PokemonBreeder
extends BaseTrainerEffect {
    public PokemonBreeder() {
        super("pokemon_breeder");
    }

    @Override
    public boolean canPlay(GameClientState client) {
        if (client.isDisablingEvolution()) {
            return false;
        }
        for (ImmutableCard stage2 : client.getMe().getHand().stream().filter(c -> c.getCardType() == CardType.STAGE2).collect(Collectors.toList())) {
            if (this.isBasicOf(stage2, client.getMe().getActiveCard())) {
                return true;
            }
            for (int i = 0; i < client.getMe().getBenchCards().length; ++i) {
                if (!this.isBasicOf(stage2, client.getMe().getBenchCards()[i])) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public CardSelectorState getSelectorState(TrainerCardState trainer, GameServerState server) {
        if (trainer.getParameters().isEmpty()) {
            CardSelectorState selector = new CardSelectorState(1, 1, CardSelectorDisplay.Select, false, "card.BS76.effect.selector.stage2");
            PlayerServerState player = server.getPlayer(server.getCurrentTurn());
            block0: for (ImmutableCard stage2 : player.getHand().stream().filter(c -> c.getCardType() == CardType.STAGE2).collect(Collectors.toList())) {
                if (this.isBasicOf(stage2, player.getActiveCard())) {
                    selector.getCardList().add(new CardWithLocation(new CommonCardState(stage2), true, BoardLocation.Hand, 0));
                    continue;
                }
                for (int i = 0; i < player.getBenchCards().length; ++i) {
                    if (!this.isBasicOf(stage2, player.getBenchCards()[i])) continue;
                    selector.getCardList().add(new CardWithLocation(new CommonCardState(stage2), true, BoardLocation.Hand, 0));
                    continue block0;
                }
            }
            return selector;
        }
        CardSelectorState selector = new CardSelectorState(1, 1, CardSelectorDisplay.Select, false, "card.BS76.effect.selector.basic");
        PlayerServerState player = server.getPlayer(server.getCurrentTurn());
        CommonCardState stage2 = trainer.getParameters().get(0);
        if (this.isBasicOf(stage2.getData(), player.getActiveCard())) {
            selector.getCardList().add(new CardWithLocation(player.getActiveCard(), true, BoardLocation.Active, 0));
        }
        for (int i = 0; i < player.getBenchCards().length; ++i) {
            if (!this.isBasicOf(stage2.getData(), player.getBenchCards()[i])) continue;
            selector.getCardList().add(new CardWithLocation(player.getBenchCards()[i], true, BoardLocation.Bench, i));
        }
        return selector;
    }

    @Override
    public boolean canApply(TrainerCardState trainer, GameServerState server) {
        return trainer.getParameters().size() >= 2;
    }

    @Override
    public void apply(TrainerCardState trainer, GameServerState server) {
        CommonCardState stage2 = trainer.getParameters().get(0);
        PokemonCardState basic = (PokemonCardState)trainer.getParameters().get(1);
        PokemonCardState newCard = LogicHelper.evolveCard(stage2.getData(), basic, server.getTurnCount());
        server.getLog().trackEvolve(basic, newCard, server.getCurrentTurn(), server);
        PlayerServerState player = server.getPlayer(server.getCurrentTurn());
        PokemonCardState oldCard = player.getActiveCard();
        if (player.getActiveCard() == basic) {
            player.setActiveCard(newCard);
        } else {
            for (int i = 0; i < player.getBenchCards().length; ++i) {
                if (player.getBenchCards()[i] != basic) continue;
                player.getBenchCards()[i] = newCard;
            }
        }
        if (newCard != null) {
            for (PlayerServerState player0 : server.getPlayers()) {
                for (PokemonCardState pokemon : player0.getActiveAndBenchCards()) {
                    if (pokemon.getAbility() != null && pokemon.getAbility().getEffect() != null) {
                        pokemon.getAbility().getEffect().onSwitchActiveCard(newCard, oldCard, player, pokemon, player0, server);
                    }
                    if (pokemon.getHiddenAbility() == null || pokemon.getHiddenAbility().getEffect() == null) continue;
                    pokemon.getHiddenAbility().getEffect().onSwitchActiveCard(newCard, oldCard, player, pokemon, player0, server);
                }
            }
        }
        player.getHand().remove(stage2.getData());
    }

    private boolean isBasicOf(ImmutableCard stage2, PokemonCardState card) {
        Optional<ImmutableCard> stage1;
        return card != null && card.getData().getCardType() == CardType.BASIC && (stage1 = Cards.getAll().stream().filter(c -> c.getPokemonID() == stage2.getPreviousEvolutionDexID() && c.getCardType() == CardType.STAGE1).findFirst()).isPresent() && stage1.get().getPreviousEvolutionDexID() == card.getData().getPokemonID();
    }

    @Override
    public boolean canSkipSelector() {
        return false;
    }

    @Override
    public void applySkipSelector(TrainerCardState trainer, PokemonCardState pokemon, GameServerState server, BoardLocation b, int p) {
    }
}

