/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.duel.trainer;

import com.pixelmonmod.tcg.api.card.CardType;
import com.pixelmonmod.tcg.api.util.helper.LogicHelper;
import com.pixelmonmod.tcg.api.util.helper.SelectorHelper;
import com.pixelmonmod.tcg.duel.state.CardSelectorState;
import com.pixelmonmod.tcg.duel.state.GameClientState;
import com.pixelmonmod.tcg.duel.state.GameServerState;
import com.pixelmonmod.tcg.duel.state.PlayerServerState;
import com.pixelmonmod.tcg.duel.state.PokemonCardState;
import com.pixelmonmod.tcg.duel.state.TrainerCardState;
import com.pixelmonmod.tcg.duel.trainer.BaseTrainerEffect;
import com.pixelmonmod.tcg.network.packets.enums.BoardLocation;

public class Lass
extends BaseTrainerEffect {
    public Lass() {
        super("lass");
    }

    @Override
    public boolean canPlay(GameClientState client) {
        return true;
    }

    @Override
    public CardSelectorState getSelectorState(TrainerCardState trainer, GameServerState server) {
        return SelectorHelper.generateSelectorForRevealingHand(server.getPlayer(server.getNextTurn()), null);
    }

    @Override
    public CardSelectorState getOpponentRevealingSelectorState(TrainerCardState trainer, GameServerState server) {
        return SelectorHelper.generateSelectorForRevealingHand(server.getPlayer(server.getCurrentTurn()), null);
    }

    @Override
    public boolean canApply(TrainerCardState trainer, GameServerState server) {
        PlayerServerState me = server.getPlayer(server.getCurrentTurn());
        PlayerServerState opp = server.getPlayer(server.getNextTurn());
        return me.getCardSelectorResult() != null && me.getCardSelectorResult().isOpened();
    }

    @Override
    public void apply(TrainerCardState trainer, GameServerState server) {
        PlayerServerState me = server.getPlayer(server.getCurrentTurn());
        PlayerServerState opp = server.getPlayer(server.getNextTurn());
        this.shuffleTrainersIntoDeck(me);
        this.shuffleTrainersIntoDeck(opp);
    }

    private void shuffleTrainersIntoDeck(PlayerServerState player) {
        int i = 0;
        while (i < player.getHand().size()) {
            if (player.getHand().get(i).getCardType() == CardType.TRAINER) {
                player.getDeck().add(player.getHand().get(i));
                player.getHand().remove(i);
                continue;
            }
            ++i;
        }
        LogicHelper.shuffleCardList(player.getDeck());
    }

    @Override
    public boolean canSkipSelector() {
        return false;
    }

    @Override
    public void applySkipSelector(TrainerCardState trainer, PokemonCardState pokemon, GameServerState server, BoardLocation b, int p) {
    }
}

